/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.crypto;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class LicenseKeyPair {
    private final KeyPair pair;
    private final String cipherTransformation;

    public String cipher() {
        return this.cipherTransformation;
    }

    private LicenseKeyPair(KeyPair pair, String cipherTransformation) {
        this.pair = pair;
        this.cipherTransformation = cipherTransformation;
    }

    public KeyPair getPair() {
        return this.pair;
    }

    public byte[] getPublic() {
        this.keyNotNull(this.pair.getPublic());
        PublicKey key2 = this.pair.getPublic();
        return this.getKeyBytes(key2);
    }

    public byte[] getPrivate() {
        this.keyNotNull(this.pair.getPrivate());
        PrivateKey key2 = this.pair.getPrivate();
        return this.getKeyBytes(key2);
    }

    private byte[] getKeyBytes(Key key2) {
        byte[] algorithm = this.cipherTransformation.getBytes(StandardCharsets.UTF_8);
        int len2 = algorithm.length + 1 + key2.getEncoded().length;
        byte[] buffer = new byte[len2];
        System.arraycopy(algorithm, 0, buffer, 0, algorithm.length);
        buffer[algorithm.length] = 0;
        System.arraycopy(key2.getEncoded(), 0, buffer, algorithm.length + 1, key2.getEncoded().length);
        return buffer;
    }

    private void keyNotNull(Key key2) {
        if (key2 == null) {
            throw new IllegalArgumentException("KeyPair does not have the key");
        }
    }

    public static class Create {
        public static LicenseKeyPair from(PublicKey publicKey, PrivateKey privateKey, String cipher) {
            return new LicenseKeyPair(new KeyPair(publicKey, privateKey), cipher);
        }

        public static LicenseKeyPair from(KeyPair keyPair, String cipher) {
            return new LicenseKeyPair(keyPair, cipher);
        }

        private static String algorithmPrefix(String cipher) {
            if (cipher.contains("/")) {
                return cipher.substring(0, cipher.indexOf("/"));
            }
            return cipher;
        }

        public static LicenseKeyPair from(String cipher, int size2) throws NoSuchAlgorithmException {
            String algorithm = Create.algorithmPrefix(cipher);
            KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm);
            generator.initialize(size2);
            return new LicenseKeyPair(generator.genKeyPair(), cipher);
        }

        public static LicenseKeyPair from(byte[] encoded, int type2) throws NoSuchAlgorithmException, InvalidKeySpecException {
            String cipher = Create.getCipher(encoded);
            if (type2 == 2) {
                return Create.from(null, Create.getPrivateEncoded(encoded), cipher);
            }
            return Create.from(Create.getPublicEncoded(encoded), null, cipher);
        }

        public static LicenseKeyPair from(byte[] privateEncoded, byte[] publicEncoded) throws NoSuchAlgorithmException, InvalidKeySpecException {
            String cipher = Create.getCipher(publicEncoded);
            return Create.from(Create.getPublicEncoded(publicEncoded), Create.getPrivateEncoded(privateEncoded), cipher);
        }

        private static PublicKey getPublicEncoded(byte[] buffer) throws NoSuchAlgorithmException, InvalidKeySpecException {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(Create.getEncoded(buffer));
            KeyFactory factory2 = KeyFactory.getInstance(Create.algorithmPrefix(Create.getCipher(buffer)));
            return factory2.generatePublic(spec);
        }

        private static PrivateKey getPrivateEncoded(byte[] buffer) throws NoSuchAlgorithmException, InvalidKeySpecException {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(Create.getEncoded(buffer));
            KeyFactory factory2 = KeyFactory.getInstance(Create.algorithmPrefix(Create.getCipher(buffer)));
            return factory2.generatePrivate(spec);
        }

        private static String getCipher(byte[] buffer) {
            for (int i2 = 0; i2 < buffer.length; ++i2) {
                if (buffer[i2] != 0) continue;
                return new String(Arrays.copyOf(buffer, i2), StandardCharsets.UTF_8);
            }
            throw new IllegalArgumentException("key does not contain cipher specification");
        }

        private static byte[] getEncoded(byte[] buffer) {
            for (int i2 = 0; i2 < buffer.length; ++i2) {
                if (buffer[i2] != 0) continue;
                return Arrays.copyOfRange(buffer, i2 + 1, buffer.length);
            }
            throw new IllegalArgumentException("key does not contain algorithm specification");
        }
    }
}

