/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax0.license3j.crypto.LicenseKeyPair;
import javax0.license3j.io.ByteArrayReader;
import javax0.license3j.io.IOFormat;

public class KeyPairReader
implements Closeable {
    private final InputStream is;
    final AtomicBoolean closed = new AtomicBoolean(false);

    public KeyPairReader(InputStream is) {
        this.is = Objects.requireNonNull(is);
    }

    public KeyPairReader(File file2) throws FileNotFoundException {
        this(new FileInputStream(file2));
    }

    public KeyPairReader(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public LicenseKeyPair readPublic() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.readPublic(IOFormat.BINARY);
    }

    public LicenseKeyPair readPublic(IOFormat format2) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.read(format2, 1);
    }

    public LicenseKeyPair readPrivate() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.readPrivate(IOFormat.BINARY);
    }

    public LicenseKeyPair readPrivate(IOFormat format2) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.read(format2, 2);
    }

    private LicenseKeyPair read(IOFormat format2, int type2) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        switch (format2) {
            case BINARY: {
                return LicenseKeyPair.Create.from(ByteArrayReader.readInput(this.is), type2);
            }
            case BASE64: {
                return LicenseKeyPair.Create.from(Base64.getDecoder().decode(ByteArrayReader.readInput(this.is)), type2);
            }
        }
        throw new IllegalArgumentException("License format " + String.valueOf((Object)format2) + " is unknown.");
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.is.close();
        }
    }
}

