/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.parsers;

public class NumericParser {
    private static long numberParse(String s2, long minValue, long maxValue) {
        String trimmed = s2.trim();
        long parsedValue = trimmed.startsWith("0x") ? java.lang.Long.parseLong(trimmed.substring(2), 16) : java.lang.Long.parseLong(trimmed);
        long correctedValue = parsedValue > maxValue && parsedValue < 2L * maxValue + 2L ? parsedValue - 2L * maxValue - 2L : parsedValue;
        if (correctedValue > maxValue || correctedValue < minValue) {
            throw new NumberFormatException(s2);
        }
        return correctedValue;
    }

    public static class Long {
        public static long parse(String s2) {
            return NumericParser.numberParse(s2, java.lang.Long.MIN_VALUE, java.lang.Long.MAX_VALUE);
        }
    }

    public static class Int {
        public static int parse(String s2) {
            return (int)NumericParser.numberParse(s2, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }

    public static class Short {
        public static short parse(String s2) {
            return (short)NumericParser.numberParse(s2, -32768L, 32767L);
        }
    }

    public static class Byte {
        public static byte parse(String s2) {
            return (byte)NumericParser.numberParse(s2, -128L, 127L);
        }
    }
}

