/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.ParserRules;
import joptsimple.internal.Classes;
import joptsimple.internal.Messages;
import joptsimple.internal.Rows;
import joptsimple.internal.Strings;

public class BuiltinHelpFormatter
implements HelpFormatter {
    private final Rows nonOptionRows;
    private final Rows optionRows;

    BuiltinHelpFormatter() {
        this(80, 2);
    }

    public BuiltinHelpFormatter(int desiredOverallWidth, int desiredColumnSeparatorWidth) {
        this.nonOptionRows = new Rows(desiredOverallWidth * 2, 0);
        this.optionRows = new Rows(desiredOverallWidth, desiredColumnSeparatorWidth);
    }

    @Override
    public String format(Map<String, ? extends OptionDescriptor> options2) {
        this.optionRows.reset();
        this.nonOptionRows.reset();
        Comparator<OptionDescriptor> comparator = new Comparator<OptionDescriptor>(){

            @Override
            public int compare(OptionDescriptor first2, OptionDescriptor second2) {
                return first2.options().iterator().next().compareTo(second2.options().iterator().next());
            }
        };
        TreeSet<OptionDescriptor> sorted2 = new TreeSet<OptionDescriptor>(comparator);
        sorted2.addAll(options2.values());
        this.addRows(sorted2);
        return this.formattedHelpOutput();
    }

    protected void addOptionRow(String single2) {
        this.addOptionRow(single2, "");
    }

    protected void addOptionRow(String left, String right) {
        this.optionRows.add(left, right);
    }

    protected void addNonOptionRow(String single2) {
        this.nonOptionRows.add(single2, "");
    }

    protected void fitRowsToWidth() {
        this.nonOptionRows.fitToWidth();
        this.optionRows.fitToWidth();
    }

    protected String nonOptionOutput() {
        return this.nonOptionRows.render();
    }

    protected String optionOutput() {
        return this.optionRows.render();
    }

    protected String formattedHelpOutput() {
        StringBuilder formatted = new StringBuilder();
        String nonOptionDisplay = this.nonOptionOutput();
        if (!Strings.isNullOrEmpty(nonOptionDisplay)) {
            formatted.append(nonOptionDisplay).append(Strings.LINE_SEPARATOR);
        }
        formatted.append(this.optionOutput());
        return formatted.toString();
    }

    protected void addRows(Collection<? extends OptionDescriptor> options2) {
        this.addNonOptionsDescription(options2);
        if (options2.isEmpty()) {
            this.addOptionRow(this.message("no.options.specified", new Object[0]));
        } else {
            this.addHeaders(options2);
            this.addOptions(options2);
        }
        this.fitRowsToWidth();
    }

    protected void addNonOptionsDescription(Collection<? extends OptionDescriptor> options2) {
        OptionDescriptor nonOptions = this.findAndRemoveNonOptionsSpec(options2);
        if (this.shouldShowNonOptionArgumentDisplay(nonOptions)) {
            this.addNonOptionRow(this.message("non.option.arguments.header", new Object[0]));
            this.addNonOptionRow(this.createNonOptionArgumentsDisplay(nonOptions));
        }
    }

    protected boolean shouldShowNonOptionArgumentDisplay(OptionDescriptor nonOptionDescriptor) {
        return !Strings.isNullOrEmpty(nonOptionDescriptor.description()) || !Strings.isNullOrEmpty(nonOptionDescriptor.argumentTypeIndicator()) || !Strings.isNullOrEmpty(nonOptionDescriptor.argumentDescription());
    }

    protected String createNonOptionArgumentsDisplay(OptionDescriptor nonOptionDescriptor) {
        StringBuilder buffer = new StringBuilder();
        this.maybeAppendOptionInfo(buffer, nonOptionDescriptor);
        this.maybeAppendNonOptionsDescription(buffer, nonOptionDescriptor);
        return buffer.toString();
    }

    protected void maybeAppendNonOptionsDescription(StringBuilder buffer, OptionDescriptor nonOptions) {
        buffer.append(buffer.length() > 0 && !Strings.isNullOrEmpty(nonOptions.description()) ? " -- " : "").append(nonOptions.description());
    }

    protected OptionDescriptor findAndRemoveNonOptionsSpec(Collection<? extends OptionDescriptor> options2) {
        Iterator<? extends OptionDescriptor> it = options2.iterator();
        while (it.hasNext()) {
            OptionDescriptor next2 = it.next();
            if (!next2.representsNonOptions()) continue;
            it.remove();
            return next2;
        }
        throw new AssertionError((Object)"no non-options argument spec");
    }

    protected void addHeaders(Collection<? extends OptionDescriptor> options2) {
        if (this.hasRequiredOption(options2)) {
            this.addOptionRow(this.message("option.header.with.required.indicator", new Object[0]), this.message("description.header", new Object[0]));
            this.addOptionRow(this.message("option.divider.with.required.indicator", new Object[0]), this.message("description.divider", new Object[0]));
        } else {
            this.addOptionRow(this.message("option.header", new Object[0]), this.message("description.header", new Object[0]));
            this.addOptionRow(this.message("option.divider", new Object[0]), this.message("description.divider", new Object[0]));
        }
    }

    protected final boolean hasRequiredOption(Collection<? extends OptionDescriptor> options2) {
        for (OptionDescriptor optionDescriptor : options2) {
            if (!optionDescriptor.isRequired()) continue;
            return true;
        }
        return false;
    }

    protected void addOptions(Collection<? extends OptionDescriptor> options2) {
        for (OptionDescriptor optionDescriptor : options2) {
            if (optionDescriptor.representsNonOptions()) continue;
            this.addOptionRow(this.createOptionDisplay(optionDescriptor), this.createDescriptionDisplay(optionDescriptor));
        }
    }

    protected String createOptionDisplay(OptionDescriptor descriptor2) {
        StringBuilder buffer = new StringBuilder(descriptor2.isRequired() ? "* " : "");
        Iterator<String> i2 = descriptor2.options().iterator();
        while (i2.hasNext()) {
            String option = i2.next();
            buffer.append(this.optionLeader(option));
            buffer.append(option);
            if (!i2.hasNext()) continue;
            buffer.append(", ");
        }
        this.maybeAppendOptionInfo(buffer, descriptor2);
        return buffer.toString();
    }

    protected String optionLeader(String option) {
        return option.length() > 1 ? "--" : ParserRules.HYPHEN;
    }

    protected void maybeAppendOptionInfo(StringBuilder buffer, OptionDescriptor descriptor2) {
        String indicator = this.extractTypeIndicator(descriptor2);
        String description = descriptor2.argumentDescription();
        if (descriptor2.acceptsArguments() || !Strings.isNullOrEmpty(description) || descriptor2.representsNonOptions()) {
            this.appendOptionHelp(buffer, indicator, description, descriptor2.requiresArgument());
        }
    }

    protected String extractTypeIndicator(OptionDescriptor descriptor2) {
        String indicator = descriptor2.argumentTypeIndicator();
        if (!Strings.isNullOrEmpty(indicator) && !String.class.getName().equals(indicator)) {
            return Classes.shortNameOf(indicator);
        }
        return "String";
    }

    protected void appendOptionHelp(StringBuilder buffer, String typeIndicator, String description, boolean required) {
        if (required) {
            this.appendTypeIndicator(buffer, typeIndicator, description, '<', '>');
        } else {
            this.appendTypeIndicator(buffer, typeIndicator, description, '[', ']');
        }
    }

    protected void appendTypeIndicator(StringBuilder buffer, String typeIndicator, String description, char start2, char end2) {
        buffer.append(' ').append(start2);
        if (typeIndicator != null) {
            buffer.append(typeIndicator);
        }
        if (!Strings.isNullOrEmpty(description)) {
            if (typeIndicator != null) {
                buffer.append(": ");
            }
            buffer.append(description);
        }
        buffer.append(end2);
    }

    protected String createDescriptionDisplay(OptionDescriptor descriptor2) {
        List<?> defaultValues = descriptor2.defaultValues();
        if (defaultValues.isEmpty()) {
            return descriptor2.description();
        }
        String defaultValuesDisplay = this.createDefaultValuesDisplay(defaultValues);
        return (descriptor2.description() + ' ' + Strings.surround(this.message("default.value.header", new Object[0]) + ' ' + defaultValuesDisplay, '(', ')')).trim();
    }

    protected String createDefaultValuesDisplay(List<?> defaultValues) {
        return defaultValues.size() == 1 ? defaultValues.get(0).toString() : defaultValues.toString();
    }

    protected String message(String keySuffix, Object ... args2) {
        return Messages.message(Locale.getDefault(), "joptsimple.HelpFormatterMessages", BuiltinHelpFormatter.class, keySuffix, args2);
    }
}

