/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joptsimple.AbstractOptionSpec;
import joptsimple.AlternativeLongOptionSpec;
import joptsimple.ArgumentList;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.MissingRequiredOptionsException;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionDeclarer;
import joptsimple.OptionException;
import joptsimple.OptionParserState;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.OptionSpecTokenizer;
import joptsimple.ParserRules;
import joptsimple.UnavailableOptionException;
import joptsimple.UnconfiguredOptionException;
import joptsimple.internal.AbbreviationMap;
import joptsimple.internal.OptionNameMap;
import joptsimple.internal.SimpleOptionNameMap;
import joptsimple.util.KeyValuePair;

public class OptionParser
implements OptionDeclarer {
    private final OptionNameMap<AbstractOptionSpec<?>> recognizedOptions;
    private final ArrayList<AbstractOptionSpec<?>> trainingOrder;
    private final Map<List<String>, Set<OptionSpec<?>>> requiredIf;
    private final Map<List<String>, Set<OptionSpec<?>>> requiredUnless;
    private final Map<List<String>, Set<OptionSpec<?>>> availableIf;
    private final Map<List<String>, Set<OptionSpec<?>>> availableUnless;
    private OptionParserState state;
    private boolean posixlyCorrect;
    private boolean allowsUnrecognizedOptions;
    private HelpFormatter helpFormatter = new BuiltinHelpFormatter();

    public OptionParser() {
        this(true);
    }

    public OptionParser(boolean allowAbbreviations) {
        this.trainingOrder = new ArrayList();
        this.requiredIf = new HashMap();
        this.requiredUnless = new HashMap();
        this.availableIf = new HashMap();
        this.availableUnless = new HashMap();
        this.state = OptionParserState.moreOptions(false);
        this.recognizedOptions = allowAbbreviations ? new AbbreviationMap() : new SimpleOptionNameMap();
        this.recognize(new NonOptionArgumentSpec());
    }

    public OptionParser(String optionSpecification) {
        this();
        new OptionSpecTokenizer(optionSpecification).configure(this);
    }

    @Override
    public OptionSpecBuilder accepts(String option) {
        return this.acceptsAll(Collections.singletonList(option));
    }

    @Override
    public OptionSpecBuilder accepts(String option, String description) {
        return this.acceptsAll(Collections.singletonList(option), description);
    }

    @Override
    public OptionSpecBuilder acceptsAll(List<String> options2) {
        return this.acceptsAll(options2, "");
    }

    @Override
    public OptionSpecBuilder acceptsAll(List<String> options2, String description) {
        if (options2.isEmpty()) {
            throw new IllegalArgumentException("need at least one option");
        }
        ParserRules.ensureLegalOptions(options2);
        return new OptionSpecBuilder(this, options2, description);
    }

    @Override
    public NonOptionArgumentSpec<String> nonOptions() {
        NonOptionArgumentSpec<String> spec = new NonOptionArgumentSpec<String>();
        this.recognize(spec);
        return spec;
    }

    @Override
    public NonOptionArgumentSpec<String> nonOptions(String description) {
        NonOptionArgumentSpec<String> spec = new NonOptionArgumentSpec<String>(description);
        this.recognize(spec);
        return spec;
    }

    @Override
    public void posixlyCorrect(boolean setting) {
        this.posixlyCorrect = setting;
        this.state = OptionParserState.moreOptions(setting);
    }

    boolean posixlyCorrect() {
        return this.posixlyCorrect;
    }

    @Override
    public void allowsUnrecognizedOptions() {
        this.allowsUnrecognizedOptions = true;
    }

    boolean doesAllowsUnrecognizedOptions() {
        return this.allowsUnrecognizedOptions;
    }

    @Override
    public void recognizeAlternativeLongOptions(boolean recognize) {
        if (recognize) {
            this.recognize(new AlternativeLongOptionSpec());
        } else {
            this.recognizedOptions.remove(String.valueOf("W"));
        }
    }

    void recognize(AbstractOptionSpec<?> spec) {
        this.recognizedOptions.putAll(spec.options(), spec);
        this.trainingOrder.add(spec);
    }

    public void printHelpOn(OutputStream sink2) throws IOException {
        this.printHelpOn(new OutputStreamWriter(sink2));
    }

    public void printHelpOn(Writer sink2) throws IOException {
        sink2.write(this.helpFormatter.format(this._recognizedOptions()));
        sink2.flush();
    }

    public void formatHelpWith(HelpFormatter formatter) {
        if (formatter == null) {
            throw new NullPointerException();
        }
        this.helpFormatter = formatter;
    }

    public Map<String, OptionSpec<?>> recognizedOptions() {
        return new LinkedHashMap(this._recognizedOptions());
    }

    private Map<String, AbstractOptionSpec<?>> _recognizedOptions() {
        LinkedHashMap options2 = new LinkedHashMap();
        for (AbstractOptionSpec<?> spec : this.trainingOrder) {
            for (String option : spec.options()) {
                options2.put(option, spec);
            }
        }
        return options2;
    }

    public OptionSet parse(String ... arguments) {
        ArgumentList argumentList = new ArgumentList(arguments);
        OptionSet detected2 = new OptionSet(this.recognizedOptions.toJavaUtilMap());
        detected2.add(this.recognizedOptions.get("[arguments]"));
        while (argumentList.hasMore()) {
            this.state.handleArgument(this, argumentList, detected2);
        }
        this.reset();
        this.ensureRequiredOptions(detected2);
        this.ensureAllowedOptions(detected2);
        return detected2;
    }

    public void mutuallyExclusive(OptionSpecBuilder ... specs) {
        for (int i2 = 0; i2 < specs.length; ++i2) {
            for (int j2 = 0; j2 < specs.length; ++j2) {
                if (i2 == j2) continue;
                specs[i2].availableUnless(specs[j2], new OptionSpec[0]);
            }
        }
    }

    private void ensureRequiredOptions(OptionSet options2) {
        List<AbstractOptionSpec<?>> missingRequiredOptions = this.missingRequiredOptions(options2);
        boolean helpOptionPresent = this.isHelpOptionPresent(options2);
        if (!missingRequiredOptions.isEmpty() && !helpOptionPresent) {
            throw new MissingRequiredOptionsException((List<? extends OptionSpec<?>>)missingRequiredOptions);
        }
    }

    private void ensureAllowedOptions(OptionSet options2) {
        List<AbstractOptionSpec<?>> forbiddenOptions = this.unavailableOptions(options2);
        boolean helpOptionPresent = this.isHelpOptionPresent(options2);
        if (!forbiddenOptions.isEmpty() && !helpOptionPresent) {
            throw new UnavailableOptionException((List<? extends OptionSpec<?>>)forbiddenOptions);
        }
    }

    private List<AbstractOptionSpec<?>> missingRequiredOptions(OptionSet options2) {
        AbstractOptionSpec<?> required;
        ArrayList missingRequiredOptions = new ArrayList();
        for (AbstractOptionSpec<?> abstractOptionSpec : this.recognizedOptions.toJavaUtilMap().values()) {
            if (!abstractOptionSpec.isRequired() || options2.has(abstractOptionSpec)) continue;
            missingRequiredOptions.add(abstractOptionSpec);
        }
        for (Map.Entry entry : this.requiredIf.entrySet()) {
            required = this.specFor((String)((List)entry.getKey()).iterator().next());
            if (!this.optionsHasAnyOf(options2, (Collection)entry.getValue()) || options2.has(required)) continue;
            missingRequiredOptions.add(required);
        }
        for (Map.Entry entry : this.requiredUnless.entrySet()) {
            required = this.specFor((String)((List)entry.getKey()).iterator().next());
            if (this.optionsHasAnyOf(options2, (Collection)entry.getValue()) || options2.has(required)) continue;
            missingRequiredOptions.add(required);
        }
        return missingRequiredOptions;
    }

    private List<AbstractOptionSpec<?>> unavailableOptions(OptionSet options2) {
        AbstractOptionSpec<?> forbidden;
        ArrayList unavailableOptions = new ArrayList();
        for (Map.Entry<List<String>, Set<OptionSpec<?>>> eachEntry : this.availableIf.entrySet()) {
            forbidden = this.specFor(eachEntry.getKey().iterator().next());
            if (this.optionsHasAnyOf(options2, (Collection)eachEntry.getValue()) || !options2.has(forbidden)) continue;
            unavailableOptions.add(forbidden);
        }
        for (Map.Entry<List<String>, Set<OptionSpec<?>>> eachEntry : this.availableUnless.entrySet()) {
            forbidden = this.specFor(eachEntry.getKey().iterator().next());
            if (!this.optionsHasAnyOf(options2, (Collection)eachEntry.getValue()) || !options2.has(forbidden)) continue;
            unavailableOptions.add(forbidden);
        }
        return unavailableOptions;
    }

    private boolean optionsHasAnyOf(OptionSet options2, Collection<OptionSpec<?>> specs) {
        for (OptionSpec<?> each : specs) {
            if (!options2.has(each)) continue;
            return true;
        }
        return false;
    }

    private boolean isHelpOptionPresent(OptionSet options2) {
        boolean helpOptionPresent = false;
        for (AbstractOptionSpec<?> each : this.recognizedOptions.toJavaUtilMap().values()) {
            if (!each.isForHelp() || !options2.has(each)) continue;
            helpOptionPresent = true;
            break;
        }
        return helpOptionPresent;
    }

    void handleLongOptionToken(String candidate, ArgumentList arguments, OptionSet detected2) {
        KeyValuePair optionAndArgument = OptionParser.parseLongOptionWithArgument(candidate);
        if (!this.isRecognized(optionAndArgument.key)) {
            throw OptionException.unrecognizedOption(optionAndArgument.key);
        }
        AbstractOptionSpec<?> optionSpec = this.specFor(optionAndArgument.key);
        optionSpec.handleOption(this, arguments, detected2, optionAndArgument.value);
    }

    void handleShortOptionToken(String candidate, ArgumentList arguments, OptionSet detected2) {
        KeyValuePair optionAndArgument = OptionParser.parseShortOptionWithArgument(candidate);
        if (this.isRecognized(optionAndArgument.key)) {
            this.specFor(optionAndArgument.key).handleOption(this, arguments, detected2, optionAndArgument.value);
        } else {
            this.handleShortOptionCluster(candidate, arguments, detected2);
        }
    }

    private void handleShortOptionCluster(String candidate, ArgumentList arguments, OptionSet detected2) {
        char[] options2 = OptionParser.extractShortOptionsFrom(candidate);
        this.validateOptionCharacters(options2);
        for (int i2 = 0; i2 < options2.length; ++i2) {
            AbstractOptionSpec<?> optionSpec = this.specFor(options2[i2]);
            if (optionSpec.acceptsArguments() && options2.length > i2 + 1) {
                String detectedArgument = String.valueOf(options2, i2 + 1, options2.length - 1 - i2);
                optionSpec.handleOption(this, arguments, detected2, detectedArgument);
                break;
            }
            optionSpec.handleOption(this, arguments, detected2, null);
        }
    }

    void handleNonOptionArgument(String candidate, ArgumentList arguments, OptionSet detectedOptions) {
        this.specFor("[arguments]").handleOption(this, arguments, detectedOptions, candidate);
    }

    void noMoreOptions() {
        this.state = OptionParserState.noMoreOptions();
    }

    boolean looksLikeAnOption(String argument) {
        return ParserRules.isShortOptionToken(argument) || ParserRules.isLongOptionToken(argument);
    }

    boolean isRecognized(String option) {
        return this.recognizedOptions.contains(option);
    }

    void requiredIf(List<String> precedentSynonyms, String required) {
        this.requiredIf(precedentSynonyms, this.specFor(required));
    }

    void requiredIf(List<String> precedentSynonyms, OptionSpec<?> required) {
        this.putDependentOption(precedentSynonyms, required, this.requiredIf);
    }

    void requiredUnless(List<String> precedentSynonyms, String required) {
        this.requiredUnless(precedentSynonyms, this.specFor(required));
    }

    void requiredUnless(List<String> precedentSynonyms, OptionSpec<?> required) {
        this.putDependentOption(precedentSynonyms, required, this.requiredUnless);
    }

    void availableIf(List<String> precedentSynonyms, String available) {
        this.availableIf(precedentSynonyms, this.specFor(available));
    }

    void availableIf(List<String> precedentSynonyms, OptionSpec<?> available) {
        this.putDependentOption(precedentSynonyms, available, this.availableIf);
    }

    void availableUnless(List<String> precedentSynonyms, String available) {
        this.availableUnless(precedentSynonyms, this.specFor(available));
    }

    void availableUnless(List<String> precedentSynonyms, OptionSpec<?> available) {
        this.putDependentOption(precedentSynonyms, available, this.availableUnless);
    }

    private void putDependentOption(List<String> precedentSynonyms, OptionSpec<?> required, Map<List<String>, Set<OptionSpec<?>>> target) {
        for (String each : precedentSynonyms) {
            AbstractOptionSpec<?> spec = this.specFor(each);
            if (spec != null) continue;
            throw new UnconfiguredOptionException(precedentSynonyms);
        }
        Set<OptionSpec<?>> associated = target.get(precedentSynonyms);
        if (associated == null) {
            associated = new HashSet();
            target.put(precedentSynonyms, associated);
        }
        associated.add(required);
    }

    private AbstractOptionSpec<?> specFor(char option) {
        return this.specFor(String.valueOf(option));
    }

    private AbstractOptionSpec<?> specFor(String option) {
        return this.recognizedOptions.get(option);
    }

    private void reset() {
        this.state = OptionParserState.moreOptions(this.posixlyCorrect);
    }

    private static char[] extractShortOptionsFrom(String argument) {
        char[] options2 = new char[argument.length() - 1];
        argument.getChars(1, argument.length(), options2, 0);
        return options2;
    }

    private void validateOptionCharacters(char[] options2) {
        for (char each : options2) {
            String option = String.valueOf(each);
            if (!this.isRecognized(option)) {
                throw OptionException.unrecognizedOption(option);
            }
            if (!this.specFor(option).acceptsArguments()) continue;
            return;
        }
    }

    private static KeyValuePair parseLongOptionWithArgument(String argument) {
        return KeyValuePair.valueOf(argument.substring(2));
    }

    private static KeyValuePair parseShortOptionWithArgument(String argument) {
        return KeyValuePair.valueOf(argument.substring(1));
    }
}

