/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.internal;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Row;
import joptsimple.internal.Strings;

class Columns {
    private static final int INDENT_WIDTH = 2;
    private final int optionWidth;
    private final int descriptionWidth;

    Columns(int optionWidth, int descriptionWidth) {
        this.optionWidth = optionWidth;
        this.descriptionWidth = descriptionWidth;
    }

    List<Row> fit(Row row) {
        List<String> options2 = this.piecesOf(row.option, this.optionWidth);
        List<String> descriptions = this.piecesOf(row.description, this.descriptionWidth);
        ArrayList<Row> rows2 = new ArrayList<Row>();
        for (int i2 = 0; i2 < Math.max(options2.size(), descriptions.size()); ++i2) {
            rows2.add(new Row(Columns.itemOrEmpty(options2, i2), Columns.itemOrEmpty(descriptions, i2)));
        }
        return rows2;
    }

    private static String itemOrEmpty(List<String> items2, int index) {
        return index >= items2.size() ? "" : items2.get(index);
    }

    private List<String> piecesOf(String raw, int width) {
        ArrayList<String> pieces = new ArrayList<String>();
        for (String each : raw.trim().split(Strings.LINE_SEPARATOR)) {
            pieces.addAll(this.piecesOfEmbeddedLine(each, width));
        }
        return pieces;
    }

    private List<String> piecesOfEmbeddedLine(String line, int width) {
        ArrayList<String> pieces = new ArrayList<String>();
        BreakIterator words = BreakIterator.getLineInstance();
        words.setText(line);
        StringBuilder nextPiece = new StringBuilder();
        int start2 = words.first();
        int end2 = words.next();
        while (end2 != -1) {
            nextPiece = this.processNextWord(line, nextPiece, start2, end2, width, pieces);
            start2 = end2;
            end2 = words.next();
        }
        if (nextPiece.length() > 0) {
            pieces.add(nextPiece.toString());
        }
        return pieces;
    }

    private StringBuilder processNextWord(String source2, StringBuilder nextPiece, int start2, int end2, int width, List<String> pieces) {
        StringBuilder augmented = nextPiece;
        String word = source2.substring(start2, end2);
        if (augmented.length() + word.length() > width) {
            pieces.add(augmented.toString().replaceAll("\\s+$", ""));
            augmented = new StringBuilder(Strings.repeat(' ', 2)).append(word);
        } else {
            augmented.append(word);
        }
        return augmented;
    }
}

