/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.asm;

import java.lang.reflect.Field;
import java.util.HashMap;
import net.minidev.asm.Accessor;
import net.minidev.asm.BasicFiledFilter;
import net.minidev.asm.FieldFilter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMUtil {
    public static void autoBoxing(MethodVisitor mv, Class<?> clz) {
        ASMUtil.autoBoxing(mv, Type.getType(clz));
    }

    public static Accessor[] getAccessors(Class<?> type2, FieldFilter filter2) {
        Class<?> nextClass = type2;
        HashMap<String, Accessor> map2 = new HashMap<String, Accessor>();
        if (filter2 == null) {
            filter2 = BasicFiledFilter.SINGLETON;
        }
        while (nextClass != Object.class) {
            Field[] declaredFields;
            for (Field field : declaredFields = nextClass.getDeclaredFields()) {
                Accessor acc;
                String fn = field.getName();
                if (map2.containsKey(fn) || !(acc = new Accessor(nextClass, field, filter2)).isUsable()) continue;
                map2.put(fn, acc);
            }
            nextClass = nextClass.getSuperclass();
        }
        return map2.values().toArray(new Accessor[map2.size()]);
    }

    protected static void autoBoxing(MethodVisitor mv, Type fieldType) {
        switch (fieldType.getSort()) {
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
            }
        }
    }

    protected static void autoUnBoxing1(MethodVisitor mv, Type fieldType) {
        switch (fieldType.getSort()) {
            case 1: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case 3: {
                mv.visitTypeInsn(192, "java/lang/Byte");
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                break;
            }
            case 2: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case 4: {
                mv.visitTypeInsn(192, "java/lang/Short");
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                break;
            }
            case 5: {
                mv.visitTypeInsn(192, "java/lang/Integer");
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                break;
            }
            case 6: {
                mv.visitTypeInsn(192, "java/lang/Float");
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                break;
            }
            case 7: {
                mv.visitTypeInsn(192, "java/lang/Long");
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            case 8: {
                mv.visitTypeInsn(192, "java/lang/Double");
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                break;
            }
            case 9: {
                mv.visitTypeInsn(192, fieldType.getInternalName());
                break;
            }
            default: {
                mv.visitTypeInsn(192, fieldType.getInternalName());
            }
        }
    }

    protected static void autoUnBoxing2(MethodVisitor mv, Type fieldType) {
        switch (fieldType.getSort()) {
            case 1: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case 3: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "byteValue", "()B", false);
                break;
            }
            case 2: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case 4: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "shortValue", "()S", false);
                break;
            }
            case 5: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "intValue", "()I", false);
                break;
            }
            case 6: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F", false);
                break;
            }
            case 7: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "longValue", "()J", false);
                break;
            }
            case 8: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D", false);
                break;
            }
            case 9: {
                mv.visitTypeInsn(192, fieldType.getInternalName());
                break;
            }
            default: {
                mv.visitTypeInsn(192, fieldType.getInternalName());
            }
        }
    }

    public static Label[] newLabels(int cnt) {
        Label[] r = new Label[cnt];
        for (int i2 = 0; i2 < cnt; ++i2) {
            r[i2] = new Label();
        }
        return r;
    }

    public static String getSetterName(String key2) {
        int len2 = key2.length();
        char[] b2 = new char[len2 + 3];
        b2[0] = 115;
        b2[1] = 101;
        b2[2] = 116;
        char c2 = key2.charAt(0);
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 32);
        }
        b2[3] = c2;
        for (int i2 = 1; i2 < len2; ++i2) {
            b2[i2 + 3] = key2.charAt(i2);
        }
        return new String(b2);
    }

    public static String getGetterName(String key2) {
        int len2 = key2.length();
        char[] b2 = new char[len2 + 3];
        b2[0] = 103;
        b2[1] = 101;
        b2[2] = 116;
        char c2 = key2.charAt(0);
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 32);
        }
        b2[3] = c2;
        for (int i2 = 1; i2 < len2; ++i2) {
            b2[i2 + 3] = key2.charAt(i2);
        }
        return new String(b2);
    }

    public static String getIsName(String key2) {
        int len2 = key2.length();
        char[] b2 = new char[len2 + 2];
        b2[0] = 105;
        b2[1] = 115;
        char c2 = key2.charAt(0);
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 32);
        }
        b2[2] = c2;
        for (int i2 = 1; i2 < len2; ++i2) {
            b2[i2 + 2] = key2.charAt(i2);
        }
        return new String(b2);
    }
}

