/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import net.minidev.json.JSONValue;
import net.minidev.json.JStylerObj;

public class JSONStyle {
    public static final int FLAG_PROTECT_KEYS = 1;
    public static final int FLAG_PROTECT_4WEB = 2;
    public static final int FLAG_PROTECT_VALUES = 4;
    public static final int FLAG_AGRESSIVE = 8;
    public static final int FLAG_IGNORE_NULL = 16;
    public static final JSONStyle NO_COMPRESS = new JSONStyle(0);
    public static final JSONStyle MAX_COMPRESS = new JSONStyle(-1);
    public static final JSONStyle LT_COMPRESS = new JSONStyle(2);
    private boolean _protectKeys;
    private boolean _protect4Web;
    private boolean _protectValues;
    private boolean _ignore_null;
    private JStylerObj.MustProtect mpKey;
    private JStylerObj.MustProtect mpValue;
    private JStylerObj.StringProtector esc;

    public JSONStyle(int FLAG) {
        this._protectKeys = (FLAG & 1) == 0;
        this._protectValues = (FLAG & 4) == 0;
        this._protect4Web = (FLAG & 2) == 0;
        this._ignore_null = (FLAG & 0x10) > 0;
        JStylerObj.MustProtect mp = (FLAG & 8) > 0 ? JStylerObj.MP_AGGRESIVE : JStylerObj.MP_SIMPLE;
        this.mpValue = this._protectValues ? JStylerObj.MP_TRUE : mp;
        this.mpKey = this._protectKeys ? JStylerObj.MP_TRUE : mp;
        this.esc = this._protect4Web ? JStylerObj.ESCAPE4Web : JStylerObj.ESCAPE_LT;
    }

    public JSONStyle() {
        this(0);
    }

    public boolean protectKeys() {
        return this._protectKeys;
    }

    public boolean protectValues() {
        return this._protectValues;
    }

    public boolean protect4Web() {
        return this._protect4Web;
    }

    public boolean ignoreNull() {
        return this._ignore_null;
    }

    public boolean indent() {
        return false;
    }

    public boolean mustProtectKey(String s2) {
        return this.mpKey.mustBeProtect(s2);
    }

    public boolean mustProtectValue(String s2) {
        return this.mpValue.mustBeProtect(s2);
    }

    public void writeString(Appendable out2, String value2) throws IOException {
        if (!this.mustProtectValue(value2)) {
            out2.append(value2);
        } else {
            out2.append('\"');
            JSONValue.escape(value2, out2, this);
            out2.append('\"');
        }
    }

    public void escape(String s2, Appendable out2) {
        this.esc.escape(s2, out2);
    }

    public void objectStart(Appendable out2) throws IOException {
        out2.append('{');
    }

    public void objectStop(Appendable out2) throws IOException {
        out2.append('}');
    }

    public void objectFirstStart(Appendable out2) throws IOException {
    }

    public void objectNext(Appendable out2) throws IOException {
        out2.append(',');
    }

    public void objectElmStop(Appendable out2) throws IOException {
    }

    public void objectEndOfKey(Appendable out2) throws IOException {
        out2.append(':');
    }

    public void arrayStart(Appendable out2) throws IOException {
        out2.append('[');
    }

    public void arrayStop(Appendable out2) throws IOException {
        out2.append(']');
    }

    public void arrayfirstObject(Appendable out2) throws IOException {
    }

    public void arrayNextElm(Appendable out2) throws IOException {
        out2.append(',');
    }

    public void arrayObjectEnd(Appendable out2) throws IOException {
    }
}

