/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.nio.charset.StandardCharsets;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.JSONParserMemory;
import net.minidev.json.parser.ParseException;
import net.minidev.json.writer.JsonReaderI;

class JSONParserByteArray
extends JSONParserMemory {
    private byte[] in;

    public JSONParserByteArray(int permissiveMode) {
        super(permissiveMode);
    }

    public JSONParserByteArray(byte[] in, int permissiveMode) {
        super(permissiveMode);
        this.in = in;
        this.len = in.length;
    }

    public Object parse(byte[] in) throws ParseException {
        return this.parse(in, JSONValue.defaultReader.DEFAULT);
    }

    public <T> T parse(byte[] in, JsonReaderI<T> mapper) throws ParseException {
        this.base = mapper.base;
        this.in = in;
        this.len = in.length;
        return this.parse(mapper);
    }

    @Override
    protected void extractString(int beginIndex, int endIndex) {
        this.xs = new String(this.in, beginIndex, endIndex - beginIndex, StandardCharsets.UTF_8);
    }

    @Override
    protected void extractStringTrim(int start2, int stop) {
        byte[] val = this.in;
        while (start2 < stop && val[start2] <= 32) {
            ++start2;
        }
        while (start2 < stop && val[stop - 1] <= 32) {
            --stop;
        }
        this.xs = new String(this.in, start2, stop - start2, StandardCharsets.UTF_8);
    }

    @Override
    protected int indexOf(char c2, int pos) {
        for (int i2 = pos; i2 < this.len; ++i2) {
            if (this.in[i2] != (byte)c2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    protected void read() {
        this.c = ++this.pos >= this.len ? (char)26 : (char)this.in[this.pos];
    }

    @Override
    protected void readS() {
        this.c = ++this.pos >= this.len ? (char)26 : (char)this.in[this.pos];
    }

    @Override
    protected void readNoEnd() throws ParseException {
        if (++this.pos >= this.len) {
            this.c = (char)26;
            if (this.acceptIncomplete) {
                return;
            }
            throw new ParseException(this.pos - 1, 3, "EOF");
        }
        this.c = (char)this.in[this.pos];
    }
}

