/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.reader;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONUtil;
import net.minidev.json.reader.JsonWriter;
import net.minidev.json.reader.JsonWriterI;

public class BeansWriter
implements JsonWriterI<Object> {
    @Override
    public <E> void writeJSONString(E value2, Appendable out2, JSONStyle compression) throws IOException {
        try {
            boolean needSep = false;
            compression.objectStart(out2);
            for (Class<?> nextClass = value2.getClass(); nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
                Field[] fields2;
                for (Field field : fields2 = nextClass.getDeclaredFields()) {
                    int m4 = field.getModifiers();
                    if ((m4 & 0x98) > 0) continue;
                    Object v = null;
                    if ((m4 & 1) > 0) {
                        v = field.get(value2);
                    } else {
                        Class<?> c2;
                        String g2 = JSONUtil.getGetterName(field.getName());
                        Method mtd = null;
                        try {
                            mtd = nextClass.getDeclaredMethod(g2, new Class[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (mtd == null && ((c2 = field.getType()) == Boolean.TYPE || c2 == Boolean.class)) {
                            g2 = JSONUtil.getIsName(field.getName());
                            mtd = nextClass.getDeclaredMethod(g2, new Class[0]);
                        }
                        if (mtd == null) continue;
                        v = mtd.invoke(value2, new Object[0]);
                    }
                    if (v == null && compression.ignoreNull()) continue;
                    if (needSep) {
                        compression.objectNext(out2);
                    } else {
                        needSep = true;
                    }
                    String key2 = field.getName();
                    JsonWriter.writeJSONKV(key2, v, out2, compression);
                }
            }
            compression.objectStop(out2);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

