/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.reader;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONStreamAware;
import net.minidev.json.JSONStreamAwareEx;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;
import net.minidev.json.reader.ArrayWriter;
import net.minidev.json.reader.BeansWriter;
import net.minidev.json.reader.BeansWriterASM;
import net.minidev.json.reader.BeansWriterASMRemap;
import net.minidev.json.reader.JsonWriterI;

public class JsonWriter {
    private ConcurrentHashMap<Class<?>, JsonWriterI<?>> data = new ConcurrentHashMap();
    private LinkedList<WriterByInterface> writerInterfaces = new LinkedList();
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E value2, Appendable out2, JSONStyle compression) throws IOException {
            value2.writeJSONString(out2);
        }
    };
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareExWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E value2, Appendable out2, JSONStyle compression) throws IOException {
            value2.writeJSONString(out2, compression);
        }
    };
    public static final JsonWriterI<JSONAwareEx> JSONJSONAwareExWriter = new JsonWriterI<JSONAwareEx>(){

        @Override
        public <E extends JSONAwareEx> void writeJSONString(E value2, Appendable out2, JSONStyle compression) throws IOException {
            out2.append(value2.toJSONString(compression));
        }
    };
    public static final JsonWriterI<JSONAware> JSONJSONAwareWriter = new JsonWriterI<JSONAware>(){

        @Override
        public <E extends JSONAware> void writeJSONString(E value2, Appendable out2, JSONStyle compression) throws IOException {
            out2.append(value2.toJSONString());
        }
    };
    public static final JsonWriterI<Iterable<? extends Object>> JSONIterableWriter = new JsonWriterI<Iterable<? extends Object>>(){

        @Override
        public <E extends Iterable<? extends Object>> void writeJSONString(E list, Appendable out2, JSONStyle compression) throws IOException {
            boolean first2 = true;
            compression.arrayStart(out2);
            for (Object value2 : list) {
                if (first2) {
                    first2 = false;
                    compression.arrayfirstObject(out2);
                } else {
                    compression.arrayNextElm(out2);
                }
                if (value2 == null) {
                    out2.append("null");
                } else {
                    JSONValue.writeJSONString(value2, out2, compression);
                }
                compression.arrayObjectEnd(out2);
            }
            compression.arrayStop(out2);
        }
    };
    public static final JsonWriterI<Enum<?>> EnumWriter = new JsonWriterI<Enum<?>>(){

        @Override
        public <E extends Enum<?>> void writeJSONString(E value2, Appendable out2, JSONStyle compression) throws IOException {
            String s2 = value2.name();
            compression.writeString(out2, s2);
        }
    };
    public static final JsonWriterI<Map<String, ? extends Object>> JSONMapWriter = new JsonWriterI<Map<String, ? extends Object>>(){

        @Override
        public <E extends Map<String, ? extends Object>> void writeJSONString(E map2, Appendable out2, JSONStyle compression) throws IOException {
            boolean first2 = true;
            compression.objectStart(out2);
            for (Map.Entry<String, ? extends Object> entry : map2.entrySet()) {
                Object v = entry.getValue();
                if (v == null && compression.ignoreNull()) continue;
                if (first2) {
                    compression.objectFirstStart(out2);
                    first2 = false;
                } else {
                    compression.objectNext(out2);
                }
                JsonWriter.writeJSONKV(entry.getKey().toString(), v, out2, compression);
            }
            compression.objectStop(out2);
        }
    };
    public static final JsonWriterI<Object> beansWriterASM = new BeansWriterASM();
    public static final JsonWriterI<Object> beansWriter = new BeansWriter();
    public static final JsonWriterI<Object> arrayWriter = new ArrayWriter();
    public static final JsonWriterI<Object> toStringWriter = new JsonWriterI<Object>(){

        @Override
        public void writeJSONString(Object value2, Appendable out2, JSONStyle compression) throws IOException {
            out2.append(value2.toString());
        }
    };

    public JsonWriter() {
        this.init();
    }

    public <T> void remapField(Class<T> type2, String fromJava, String toJson) {
        JsonWriterI map2 = this.getWrite(type2);
        if (!(map2 instanceof BeansWriterASMRemap)) {
            map2 = new BeansWriterASMRemap();
            this.registerWriter(map2, type2);
        }
        ((BeansWriterASMRemap)map2).renameField(fromJava, toJson);
    }

    public JsonWriterI getWriterByInterface(Class<?> clazz) {
        for (WriterByInterface w : this.writerInterfaces) {
            if (!w._interface.isAssignableFrom(clazz)) continue;
            return w._writer;
        }
        return null;
    }

    public JsonWriterI getWrite(Class cls) {
        return this.data.get(cls);
    }

    public void init() {
        this.registerWriter(new JsonWriterI<String>(){

            @Override
            public void writeJSONString(String value2, Appendable out2, JSONStyle compression) throws IOException {
                compression.writeString(out2, value2);
            }
        }, String.class);
        this.registerWriter(new JsonWriterI<Double>(){

            @Override
            public void writeJSONString(Double value2, Appendable out2, JSONStyle compression) throws IOException {
                if (value2.isInfinite()) {
                    out2.append("null");
                } else {
                    out2.append(value2.toString());
                }
            }
        }, Double.class);
        this.registerWriter(new JsonWriterI<Date>(){

            @Override
            public void writeJSONString(Date value2, Appendable out2, JSONStyle compression) throws IOException {
                out2.append('\"');
                JSONValue.escape(value2.toString(), out2, compression);
                out2.append('\"');
            }
        }, Date.class);
        this.registerWriter(new JsonWriterI<Float>(){

            @Override
            public void writeJSONString(Float value2, Appendable out2, JSONStyle compression) throws IOException {
                if (value2.isInfinite()) {
                    out2.append("null");
                } else {
                    out2.append(value2.toString());
                }
            }
        }, Float.class);
        this.registerWriter(toStringWriter, Integer.class, Long.class, Byte.class, Short.class, BigInteger.class, BigDecimal.class);
        this.registerWriter(toStringWriter, Boolean.class);
        this.registerWriter(new JsonWriterI<int[]>(){

            @Override
            public void writeJSONString(int[] value2, Appendable out2, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out2);
                for (int b2 : value2) {
                    if (needSep) {
                        compression.objectNext(out2);
                    } else {
                        needSep = true;
                    }
                    out2.append(Integer.toString(b2));
                }
                compression.arrayStop(out2);
            }
        }, int[].class);
        this.registerWriter(new JsonWriterI<short[]>(){

            @Override
            public void writeJSONString(short[] value2, Appendable out2, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out2);
                for (short b2 : value2) {
                    if (needSep) {
                        compression.objectNext(out2);
                    } else {
                        needSep = true;
                    }
                    out2.append(Short.toString(b2));
                }
                compression.arrayStop(out2);
            }
        }, short[].class);
        this.registerWriter(new JsonWriterI<long[]>(){

            @Override
            public void writeJSONString(long[] value2, Appendable out2, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out2);
                for (long b2 : value2) {
                    if (needSep) {
                        compression.objectNext(out2);
                    } else {
                        needSep = true;
                    }
                    out2.append(Long.toString(b2));
                }
                compression.arrayStop(out2);
            }
        }, long[].class);
        this.registerWriter(new JsonWriterI<float[]>(){

            @Override
            public void writeJSONString(float[] value2, Appendable out2, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out2);
                for (float b2 : value2) {
                    if (needSep) {
                        compression.objectNext(out2);
                    } else {
                        needSep = true;
                    }
                    out2.append(Float.toString(b2));
                }
                compression.arrayStop(out2);
            }
        }, float[].class);
        this.registerWriter(new JsonWriterI<double[]>(){

            @Override
            public void writeJSONString(double[] value2, Appendable out2, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out2);
                for (double b2 : value2) {
                    if (needSep) {
                        compression.objectNext(out2);
                    } else {
                        needSep = true;
                    }
                    out2.append(Double.toString(b2));
                }
                compression.arrayStop(out2);
            }
        }, double[].class);
        this.registerWriter(new JsonWriterI<boolean[]>(){

            @Override
            public void writeJSONString(boolean[] value2, Appendable out2, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out2);
                for (boolean b2 : value2) {
                    if (needSep) {
                        compression.objectNext(out2);
                    } else {
                        needSep = true;
                    }
                    out2.append(Boolean.toString(b2));
                }
                compression.arrayStop(out2);
            }
        }, boolean[].class);
        this.registerWriterInterface(JSONStreamAwareEx.class, JSONStreamAwareExWriter);
        this.registerWriterInterface(JSONStreamAware.class, JSONStreamAwareWriter);
        this.registerWriterInterface(JSONAwareEx.class, JSONJSONAwareExWriter);
        this.registerWriterInterface(JSONAware.class, JSONJSONAwareWriter);
        this.registerWriterInterface(Map.class, JSONMapWriter);
        this.registerWriterInterface(Iterable.class, JSONIterableWriter);
        this.registerWriterInterface(Enum.class, EnumWriter);
        this.registerWriterInterface(Number.class, toStringWriter);
    }

    public void addInterfaceWriterFirst(Class<?> interFace, JsonWriterI<?> writer) {
        this.registerWriterInterfaceFirst(interFace, writer);
    }

    public void addInterfaceWriterLast(Class<?> interFace, JsonWriterI<?> writer) {
        this.registerWriterInterfaceLast(interFace, writer);
    }

    public void registerWriterInterfaceLast(Class<?> interFace, JsonWriterI<?> writer) {
        this.writerInterfaces.addLast(new WriterByInterface(interFace, writer));
    }

    public void registerWriterInterfaceFirst(Class<?> interFace, JsonWriterI<?> writer) {
        this.writerInterfaces.addFirst(new WriterByInterface(interFace, writer));
    }

    public void registerWriterInterface(Class<?> interFace, JsonWriterI<?> writer) {
        this.registerWriterInterfaceLast(interFace, writer);
    }

    public <T> void registerWriter(JsonWriterI<T> writer, Class<?> ... cls) {
        for (Class<?> c2 : cls) {
            this.data.put(c2, writer);
        }
    }

    public static void writeJSONKV(String key2, Object value2, Appendable out2, JSONStyle compression) throws IOException {
        if (key2 == null) {
            out2.append("null");
        } else if (!compression.mustProtectKey(key2)) {
            out2.append(key2);
        } else {
            out2.append('\"');
            JSONValue.escape(key2, out2, compression);
            out2.append('\"');
        }
        compression.objectEndOfKey(out2);
        if (value2 instanceof String) {
            compression.writeString(out2, (String)value2);
        } else {
            JSONValue.writeJSONString(value2, out2, compression);
        }
        compression.objectElmStop(out2);
    }

    static class WriterByInterface {
        public Class<?> _interface;
        public JsonWriterI<?> _writer;

        public WriterByInterface(Class<?> _interface, JsonWriterI<?> _writer) {
            this._interface = _interface;
            this._writer = _writer;
        }
    }
}

