/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Array;
import ognl.ASTAnd;
import ognl.ASTConst;
import ognl.ASTCtor;
import ognl.ASTOr;
import ognl.ASTProperty;
import ognl.ASTSequence;
import ognl.ASTStaticField;
import ognl.ASTVarRef;
import ognl.DynamicSubscript;
import ognl.NodeType;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.enhance.OrderedReturn;
import ognl.enhance.UnsupportedCompilationException;

public class ASTChain
extends SimpleNode
implements NodeType,
OrderedReturn {
    private Class _getterClass;
    private Class _setterClass;
    private String _lastExpression;
    private String _coreExpression;

    public ASTChain(int id) {
        super(id);
    }

    public ASTChain(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    public String getLastExpression() {
        return this._lastExpression;
    }

    @Override
    public String getCoreExpression() {
        return this._coreExpression;
    }

    @Override
    public void jjtClose() {
        this.flattenTree();
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source2) throws OgnlException {
        Object result2 = source2;
        int ilast = this._children.length - 1;
        for (int i2 = 0; i2 <= ilast; ++i2) {
            ASTProperty indexNode;
            ASTProperty propertyNode;
            int indexType;
            boolean handled = false;
            if (i2 < ilast && this._children[i2] instanceof ASTProperty && (indexType = (propertyNode = (ASTProperty)this._children[i2]).getIndexedPropertyType(context, result2)) != OgnlRuntime.INDEXED_PROPERTY_NONE && this._children[i2 + 1] instanceof ASTProperty && (indexNode = (ASTProperty)this._children[i2 + 1]).isIndexedAccess()) {
                Object index = indexNode.getProperty(context, result2);
                if (index instanceof DynamicSubscript) {
                    if (indexType == OgnlRuntime.INDEXED_PROPERTY_INT) {
                        Object array = propertyNode.getValue(context, result2);
                        int len2 = Array.getLength(array);
                        switch (((DynamicSubscript)index).getFlag()) {
                            case 3: {
                                result2 = Array.newInstance(array.getClass().getComponentType(), len2);
                                System.arraycopy(array, 0, result2, 0, len2);
                                handled = true;
                                ++i2;
                                break;
                            }
                            case 0: {
                                index = new Integer(len2 > 0 ? 0 : -1);
                                break;
                            }
                            case 1: {
                                index = new Integer(len2 > 0 ? len2 / 2 : -1);
                                break;
                            }
                            case 2: {
                                index = new Integer(len2 > 0 ? len2 - 1 : -1);
                            }
                        }
                    } else if (indexType == OgnlRuntime.INDEXED_PROPERTY_OBJECT) {
                        throw new OgnlException("DynamicSubscript '" + indexNode + "' not allowed for object indexed property '" + propertyNode + "'");
                    }
                }
                if (!handled) {
                    result2 = OgnlRuntime.getIndexedProperty(context, result2, propertyNode.getProperty(context, result2).toString(), index);
                    handled = true;
                    ++i2;
                }
            }
            if (handled) continue;
            result2 = this._children[i2].getValue(context, result2);
        }
        return result2;
    }

    @Override
    protected void setValueBody(OgnlContext context, Object target, Object value2) throws OgnlException {
        boolean handled = false;
        int ilast = this._children.length - 2;
        for (int i2 = 0; i2 <= ilast; ++i2) {
            ASTProperty indexNode;
            ASTProperty propertyNode;
            int indexType;
            if (i2 <= ilast && this._children[i2] instanceof ASTProperty && (indexType = (propertyNode = (ASTProperty)this._children[i2]).getIndexedPropertyType(context, target)) != OgnlRuntime.INDEXED_PROPERTY_NONE && this._children[i2 + 1] instanceof ASTProperty && (indexNode = (ASTProperty)this._children[i2 + 1]).isIndexedAccess()) {
                Object index = indexNode.getProperty(context, target);
                if (index instanceof DynamicSubscript) {
                    if (indexType == OgnlRuntime.INDEXED_PROPERTY_INT) {
                        Object array = propertyNode.getValue(context, target);
                        int len2 = Array.getLength(array);
                        switch (((DynamicSubscript)index).getFlag()) {
                            case 3: {
                                System.arraycopy(target, 0, value2, 0, len2);
                                handled = true;
                                ++i2;
                                break;
                            }
                            case 0: {
                                index = new Integer(len2 > 0 ? 0 : -1);
                                break;
                            }
                            case 1: {
                                index = new Integer(len2 > 0 ? len2 / 2 : -1);
                                break;
                            }
                            case 2: {
                                index = new Integer(len2 > 0 ? len2 - 1 : -1);
                            }
                        }
                    } else if (indexType == OgnlRuntime.INDEXED_PROPERTY_OBJECT) {
                        throw new OgnlException("DynamicSubscript '" + indexNode + "' not allowed for object indexed property '" + propertyNode + "'");
                    }
                }
                if (!handled && i2 == ilast) {
                    OgnlRuntime.setIndexedProperty(context, target, propertyNode.getProperty(context, target).toString(), index, value2);
                    handled = true;
                    ++i2;
                } else if (!handled) {
                    target = OgnlRuntime.getIndexedProperty(context, target, propertyNode.getProperty(context, target).toString(), index);
                    ++i2;
                    continue;
                }
            }
            if (handled) continue;
            target = this._children[i2].getValue(context, target);
        }
        if (!handled) {
            this._children[this._children.length - 1].setValue(context, target, value2);
        }
    }

    @Override
    public boolean isSimpleNavigationChain(OgnlContext context) throws OgnlException {
        boolean result2 = false;
        if (this._children != null && this._children.length > 0) {
            result2 = true;
            for (int i2 = 0; result2 && i2 < this._children.length; ++i2) {
                result2 = this._children[i2] instanceof SimpleNode ? ((SimpleNode)this._children[i2]).isSimpleProperty(context) : false;
            }
        }
        return result2;
    }

    @Override
    public Class getGetterClass() {
        return this._getterClass;
    }

    @Override
    public Class getSetterClass() {
        return this._setterClass;
    }

    @Override
    public String toString() {
        String result2 = "";
        if (this._children != null && this._children.length > 0) {
            for (int i2 = 0; i2 < this._children.length; ++i2) {
                if (!(i2 <= 0 || this._children[i2] instanceof ASTProperty && ((ASTProperty)this._children[i2]).isIndexedAccess())) {
                    result2 = result2 + ".";
                }
                result2 = result2 + this._children[i2].toString();
            }
        }
        return result2;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        String prevChain = (String)context.get("_currentChain");
        if (target != null) {
            context.setCurrentObject(target);
            context.setCurrentType(target.getClass());
        }
        String result2 = "";
        NodeType _lastType = null;
        boolean ordered = false;
        boolean constructor = false;
        try {
            if (this._children != null && this._children.length > 0) {
                for (int i2 = 0; i2 < this._children.length; ++i2) {
                    String value2 = this._children[i2].toGetSourceString(context, context.getCurrentObject());
                    if (ASTCtor.class.isInstance(this._children[i2])) {
                        constructor = true;
                    }
                    if (NodeType.class.isInstance(this._children[i2]) && ((NodeType)((Object)this._children[i2])).getGetterClass() != null) {
                        _lastType = (NodeType)((Object)this._children[i2]);
                    }
                    if (!(ASTVarRef.class.isInstance(this._children[i2]) || constructor || OrderedReturn.class.isInstance(this._children[i2]) && ((OrderedReturn)((Object)this._children[i2])).getLastExpression() != null || this._parent != null && ASTSequence.class.isInstance(this._parent))) {
                        value2 = OgnlRuntime.getCompiler().castExpression(context, this._children[i2], value2);
                    }
                    if (OrderedReturn.class.isInstance(this._children[i2]) && ((OrderedReturn)((Object)this._children[i2])).getLastExpression() != null) {
                        ordered = true;
                        OrderedReturn or = (OrderedReturn)((Object)this._children[i2]);
                        result2 = or.getCoreExpression() == null || or.getCoreExpression().trim().length() <= 0 ? "" : result2 + or.getCoreExpression();
                        this._lastExpression = or.getLastExpression();
                        if (context.get("_preCast") != null) {
                            this._lastExpression = context.remove("_preCast") + this._lastExpression;
                        }
                    } else if (ASTOr.class.isInstance(this._children[i2]) || ASTAnd.class.isInstance(this._children[i2]) || ASTCtor.class.isInstance(this._children[i2]) || ASTStaticField.class.isInstance(this._children[i2]) && this._parent == null) {
                        context.put("_noRoot", "true");
                        result2 = value2;
                    } else {
                        result2 = result2 + value2;
                    }
                    context.put("_currentChain", result2);
                }
            }
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        if (_lastType != null) {
            this._getterClass = _lastType.getGetterClass();
            this._setterClass = _lastType.getSetterClass();
        }
        if (ordered) {
            this._coreExpression = result2;
        }
        context.put("_currentChain", prevChain);
        return result2;
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        String prevChain = (String)context.get("_currentChain");
        String prevChild = (String)context.get("_lastChild");
        if (prevChain != null) {
            throw new UnsupportedCompilationException("Can't compile nested chain expressions.");
        }
        if (target != null) {
            context.setCurrentObject(target);
            context.setCurrentType(target.getClass());
        }
        String result2 = "";
        NodeType _lastType = null;
        boolean constructor = false;
        try {
            if (this._children != null && this._children.length > 0) {
                if (ASTConst.class.isInstance(this._children[0])) {
                    throw new UnsupportedCompilationException("Can't modify constant values.");
                }
                for (int i2 = 0; i2 < this._children.length; ++i2) {
                    if (i2 == this._children.length - 1) {
                        context.put("_lastChild", "true");
                    }
                    String value2 = this._children[i2].toSetSourceString(context, context.getCurrentObject());
                    if (ASTCtor.class.isInstance(this._children[i2])) {
                        constructor = true;
                    }
                    if (NodeType.class.isInstance(this._children[i2]) && ((NodeType)((Object)this._children[i2])).getGetterClass() != null) {
                        _lastType = (NodeType)((Object)this._children[i2]);
                    }
                    if (!(ASTVarRef.class.isInstance(this._children[i2]) || constructor || OrderedReturn.class.isInstance(this._children[i2]) && ((OrderedReturn)((Object)this._children[i2])).getLastExpression() != null || this._parent != null && ASTSequence.class.isInstance(this._parent))) {
                        value2 = OgnlRuntime.getCompiler().castExpression(context, this._children[i2], value2);
                    }
                    if (ASTOr.class.isInstance(this._children[i2]) || ASTAnd.class.isInstance(this._children[i2]) || ASTCtor.class.isInstance(this._children[i2]) || ASTStaticField.class.isInstance(this._children[i2])) {
                        context.put("_noRoot", "true");
                        result2 = value2;
                    } else {
                        result2 = result2 + value2;
                    }
                    context.put("_currentChain", result2);
                }
            }
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        context.put("_lastChild", prevChild);
        context.put("_currentChain", prevChain);
        if (_lastType != null) {
            this._setterClass = _lastType.getSetterClass();
        }
        return result2;
    }

    @Override
    public boolean isChain(OgnlContext context) {
        return true;
    }
}

