/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Method;
import ognl.ASTConst;
import ognl.NodeType;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.enhance.ExpressionCompiler;
import ognl.enhance.UnsupportedCompilationException;

public class ASTStaticMethod
extends SimpleNode
implements NodeType {
    private String _className;
    private String _methodName;
    private Class _getterClass;

    public ASTStaticMethod(int id) {
        super(id);
    }

    public ASTStaticMethod(OgnlParser p, int id) {
        super(p, id);
    }

    void init(String className, String methodName) {
        this._className = className;
        this._methodName = methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getValueBody(OgnlContext context, Object source2) throws OgnlException {
        Object[] args2 = OgnlRuntime.getObjectArrayPool().create(this.jjtGetNumChildren());
        Object root = context.getRoot();
        try {
            int icount = args2.length;
            for (int i2 = 0; i2 < icount; ++i2) {
                args2[i2] = this._children[i2].getValue(context, root);
            }
            Object object = OgnlRuntime.callStaticMethod(context, this._className, this._methodName, args2);
            return object;
        }
        finally {
            OgnlRuntime.getObjectArrayPool().recycle(args2);
        }
    }

    @Override
    public Class getGetterClass() {
        return this._getterClass;
    }

    @Override
    public Class getSetterClass() {
        return this._getterClass;
    }

    @Override
    public String toString() {
        String result2 = "@" + this._className + "@" + this._methodName;
        result2 = result2 + "(";
        if (this._children != null && this._children.length > 0) {
            for (int i2 = 0; i2 < this._children.length; ++i2) {
                if (i2 > 0) {
                    result2 = result2 + ", ";
                }
                result2 = result2 + this._children[i2];
            }
        }
        result2 = result2 + ")";
        return result2;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        String result2 = this._className + "#" + this._methodName + "(";
        try {
            Class clazz = OgnlRuntime.classForName(context, this._className);
            Method m4 = OgnlRuntime.getMethod(context, clazz, this._methodName, this._children, true);
            if (clazz == null || m4 == null) {
                throw new UnsupportedCompilationException("Unable to find class/method combo " + this._className + " / " + this._methodName);
            }
            if (!context.getMemberAccess().isAccessible(context, clazz, m4, this._methodName)) {
                throw new UnsupportedCompilationException("Method is not accessible, check your jvm runtime security settings. For static class method " + this._className + " / " + this._methodName);
            }
            if (this._children != null && this._children.length > 0) {
                Class<?>[] parms = m4.getParameterTypes();
                for (int i2 = 0; i2 < this._children.length; ++i2) {
                    Class valueClass;
                    if (i2 > 0) {
                        result2 = result2 + ", ";
                    }
                    Class prevType = context.getCurrentType();
                    Object value2 = this._children[i2].getValue(context, context.getRoot());
                    String parmString = this._children[i2].toGetSourceString(context, context.getRoot());
                    if (parmString == null || parmString.trim().length() < 1) {
                        parmString = "null";
                    }
                    if (ASTConst.class.isInstance(this._children[i2])) {
                        context.setCurrentType(prevType);
                    }
                    parmString = ExpressionCompiler.getRootExpression(this._children[i2], context.getRoot(), context) + parmString;
                    String cast = "";
                    if (ExpressionCompiler.shouldCast(this._children[i2])) {
                        cast = (String)context.remove("_preCast");
                    }
                    if (cast == null) {
                        cast = "";
                    }
                    if (!ASTConst.class.isInstance(this._children[i2])) {
                        parmString = cast + parmString;
                    }
                    Class clazz2 = valueClass = value2 != null ? value2.getClass() : null;
                    if (NodeType.class.isAssignableFrom(this._children[i2].getClass())) {
                        valueClass = ((NodeType)((Object)this._children[i2])).getGetterClass();
                    }
                    if (valueClass != parms[i2]) {
                        if (parms[i2].isArray()) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + ExpressionCompiler.getCastString(parms[i2]) + ")ognl.OgnlOps.toArray(" + parmString + ", " + parms[i2].getComponentType().getName() + ".class, true)", parms[i2]);
                        } else if (parms[i2].isPrimitive()) {
                            Class wrapClass = OgnlRuntime.getPrimitiveWrapperClass(parms[i2]);
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "((" + wrapClass.getName() + ")ognl.OgnlOps.convertValue(" + parmString + "," + wrapClass.getName() + ".class, true))." + OgnlRuntime.getNumericValueGetter(wrapClass), parms[i2]);
                        } else if (parms[i2] != Object.class) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + parms[i2].getName() + ")ognl.OgnlOps.convertValue(" + parmString + "," + parms[i2].getName() + ".class)", parms[i2]);
                        } else if (NodeType.class.isInstance(this._children[i2]) && ((NodeType)((Object)this._children[i2])).getGetterClass() != null && Number.class.isAssignableFrom(((NodeType)((Object)this._children[i2])).getGetterClass()) || valueClass.isPrimitive()) {
                            parmString = " ($w) " + parmString;
                        } else if (valueClass.isPrimitive()) {
                            parmString = "($w) " + parmString;
                        }
                    }
                    result2 = result2 + parmString;
                }
            }
            result2 = result2 + ")";
            try {
                Object contextObj = this.getValueBody(context, target);
                context.setCurrentObject(contextObj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (m4 != null) {
                this._getterClass = m4.getReturnType();
                context.setCurrentType(m4.getReturnType());
                context.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m4, m4.getDeclaringClass()));
            }
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        return result2;
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        return this.toGetSourceString(context, target);
    }
}

