/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntHashMap
implements Map {
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this(101, 0.75f);
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i2 = oldCapacity;
        while (i2-- > 0) {
            Entry old = oldTable[i2];
            while (old != null) {
                Entry e2 = old;
                int index = (e2.hash & Integer.MAX_VALUE) % newCapacity;
                old = old.next;
                e2.next = newTable[index];
                newTable[index] = e2;
            }
        }
    }

    public final boolean containsKey(int key2) {
        int index = (key2 & Integer.MAX_VALUE) % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == key2 && e2.key == key2) {
                return true;
            }
            e2 = e2.next;
        }
        return false;
    }

    public final Object get(int key2) {
        int index = (key2 & Integer.MAX_VALUE) % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == key2 && e2.key == key2) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    public final Object put(int key2, Object value2) {
        int index = (key2 & Integer.MAX_VALUE) % this.table.length;
        if (value2 == null) {
            throw new IllegalArgumentException();
        }
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == key2 && e2.key == key2) {
                Object old = e2.value;
                e2.value = value2;
                return old;
            }
            e2 = e2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key2, value2);
        }
        e2 = new Entry();
        e2.hash = key2;
        e2.key = key2;
        e2.value = value2;
        e2.next = this.table[index];
        this.table[index] = e2;
        ++this.count;
        return null;
    }

    public final Object remove(int key2) {
        int index = (key2 & Integer.MAX_VALUE) % this.table.length;
        Entry e2 = this.table[index];
        Entry prev = null;
        while (e2 != null) {
            if (e2.hash == key2 && e2.key == key2) {
                if (prev != null) {
                    prev.next = e2.next;
                } else {
                    this.table[index] = e2.next;
                }
                --this.count;
                return e2.value;
            }
            prev = e2;
            e2 = e2.next;
        }
        return null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object get(Object key2) {
        if (!(key2 instanceof Number)) {
            throw new IllegalArgumentException("key is not an Number subclass");
        }
        return this.get(((Number)key2).intValue());
    }

    public Object put(Object key2, Object value2) {
        if (!(key2 instanceof Number)) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.put(((Number)key2).intValue(), value2);
    }

    public void putAll(Map otherMap) {
        for (Object k2 : otherMap.keySet()) {
            this.put(k2, otherMap.get(k2));
        }
    }

    public Object remove(Object key2) {
        if (!(key2 instanceof Number)) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.remove(((Number)key2).intValue());
    }

    @Override
    public void clear() {
        Entry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        if (!(key2 instanceof Number)) {
            throw new InternalError("key is not an Number subclass");
        }
        return this.containsKey(((Number)key2).intValue());
    }

    @Override
    public boolean containsValue(Object value2) {
        Entry[] tab = this.table;
        if (value2 == null) {
            throw new IllegalArgumentException();
        }
        int i2 = tab.length;
        while (i2-- > 0) {
            Entry e2 = tab[i2];
            while (e2 != null) {
                if (e2.value.equals(value2)) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    public Set keySet() {
        HashSet result2 = new HashSet();
        IntHashMapIterator it = new IntHashMapIterator(this.table, true);
        while (it.hasNext()) {
            result2.add(it.next());
        }
        return result2;
    }

    public Collection values() {
        ArrayList result2 = new ArrayList();
        IntHashMapIterator it = new IntHashMapIterator(this.table, false);
        while (it.hasNext()) {
            result2.add(it.next());
        }
        return result2;
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("entrySet");
    }

    public static class Entry {
        int hash;
        int key;
        Object value;
        Entry next;
    }

    private static class IntHashMapIterator
    implements Iterator {
        boolean keys;
        int index;
        Entry[] table;
        Entry entry;

        IntHashMapIterator(Entry[] table, boolean keys2) {
            this.table = table;
            this.keys = keys2;
            this.index = table.length;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry e2 = this.entry;
                this.entry = e2.next;
                return this.keys ? new Integer(e2.key) : e2.value;
            }
            throw new NoSuchElementException("IntHashMapIterator");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

