/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import ognl.ASTConst;
import ognl.ExpressionNode;
import ognl.Node;
import ognl.NodeType;
import ognl.OgnlContext;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.enhance.ExpressionCompiler;

public abstract class NumericExpression
extends ExpressionNode
implements NodeType {
    protected Class _getterClass;

    public NumericExpression(int id) {
        super(id);
    }

    public NumericExpression(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    public Class getGetterClass() {
        if (this._getterClass != null) {
            return this._getterClass;
        }
        return Double.TYPE;
    }

    @Override
    public Class getSetterClass() {
        return null;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        Object value2 = null;
        String result2 = "";
        try {
            value2 = this.getValueBody(context, target);
            if (value2 != null) {
                this._getterClass = value2.getClass();
            }
            for (int i2 = 0; i2 < this._children.length; ++i2) {
                if (i2 > 0) {
                    result2 = result2 + " " + this.getExpressionOperator(i2) + " ";
                }
                String str = OgnlRuntime.getChildSource(context, target, this._children[i2]);
                result2 = result2 + this.coerceToNumeric(str, context, this._children[i2]);
            }
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        return result2;
    }

    public String coerceToNumeric(String source2, OgnlContext context, Node child) {
        String ret = source2;
        Object value2 = context.getCurrentObject();
        if (ASTConst.class.isInstance(child) && value2 != null) {
            return value2.toString();
        }
        if (context.getCurrentType() != null && !context.getCurrentType().isPrimitive() && context.getCurrentObject() != null && Number.class.isInstance(context.getCurrentObject())) {
            ret = "((" + ExpressionCompiler.getCastString(context.getCurrentObject().getClass()) + ")" + ret + ")";
            ret = ret + "." + OgnlRuntime.getNumericValueGetter(context.getCurrentObject().getClass());
        } else if (context.getCurrentType() != null && context.getCurrentType().isPrimitive() && (ASTConst.class.isInstance(child) || NumericExpression.class.isInstance(child))) {
            ret = ret + OgnlRuntime.getNumericLiteral(context.getCurrentType());
        } else if (context.getCurrentType() != null && String.class.isAssignableFrom(context.getCurrentType())) {
            ret = "Double.parseDouble(" + ret + ")";
            context.setCurrentType(Double.TYPE);
        }
        if (NumericExpression.class.isInstance(child)) {
            ret = "(" + ret + ")";
        }
        return ret;
    }
}

