/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ClassResolver;
import ognl.DefaultClassResolver;
import ognl.DefaultTypeConverter;
import ognl.Evaluation;
import ognl.MemberAccess;
import ognl.Node;
import ognl.OgnlOps;
import ognl.OgnlRuntime;
import ognl.TypeConverter;
import ognl.enhance.LocalReference;

public class OgnlContext
implements Map {
    public static final String ROOT_CONTEXT_KEY = "root";
    public static final String THIS_CONTEXT_KEY = "this";
    public static final String TRACE_EVALUATIONS_CONTEXT_KEY = "_traceEvaluations";
    public static final String LAST_EVALUATION_CONTEXT_KEY = "_lastEvaluation";
    public static final String KEEP_LAST_EVALUATION_CONTEXT_KEY = "_keepLastEvaluation";
    @Deprecated
    public static final String TYPE_CONVERTER_CONTEXT_KEY = "_typeConverter";
    private static final String PROPERTY_KEY_PREFIX = "ognl";
    private static boolean DEFAULT_TRACE_EVALUATIONS = false;
    private static boolean DEFAULT_KEEP_LAST_EVALUATION = false;
    private static final Map<Object, Object> RESERVED_KEYS = new HashMap<Object, Object>(6);
    private Object _root;
    private Object _currentObject;
    private Node _currentNode;
    private boolean _traceEvaluations = DEFAULT_TRACE_EVALUATIONS;
    private Evaluation _rootEvaluation;
    private Evaluation _currentEvaluation;
    private Evaluation _lastEvaluation;
    private boolean _keepLastEvaluation = DEFAULT_KEEP_LAST_EVALUATION;
    private final Map _values;
    private final ClassResolver _classResolver;
    private final TypeConverter _typeConverter;
    private final MemberAccess _memberAccess;
    private final List<Class<?>> _typeStack = new ArrayList(3);
    private final List<Class<?>> _accessorStack = new ArrayList(3);
    private int _localReferenceCounter = 0;
    private Map<String, LocalReference> _localReferenceMap = null;

    public OgnlContext(ClassResolver classResolver, TypeConverter typeConverter, MemberAccess memberAccess) {
        this(memberAccess, classResolver, typeConverter, new HashMap(23));
    }

    public OgnlContext(MemberAccess memberAccess, ClassResolver classResolver, TypeConverter typeConverter, Map values2) {
        this._values = values2 != null ? values2 : new HashMap(23);
        this._classResolver = classResolver != null ? classResolver : new DefaultClassResolver();
        this._typeConverter = typeConverter != null ? typeConverter : new DefaultTypeConverter();
        if (memberAccess == null) {
            throw new IllegalArgumentException("MemberAccess implementation must be provided - null not permitted!");
        }
        this._memberAccess = memberAccess;
    }

    public void setValues(Map value2) {
        for (Object k2 : value2.keySet()) {
            this._values.put(k2, value2.get(k2));
        }
    }

    public Map getValues() {
        return this._values;
    }

    @Deprecated
    public void setClassResolver(ClassResolver ignore) {
    }

    public ClassResolver getClassResolver() {
        return this._classResolver;
    }

    @Deprecated
    public void setTypeConverter(TypeConverter ignore) {
    }

    public TypeConverter getTypeConverter() {
        return this._typeConverter;
    }

    @Deprecated
    public void setMemberAccess(MemberAccess ignore) {
    }

    public MemberAccess getMemberAccess() {
        return this._memberAccess;
    }

    public void setRoot(Object value2) {
        this._root = value2;
        this._accessorStack.clear();
        this._typeStack.clear();
        this._currentObject = value2;
        if (this._currentObject != null) {
            this.setCurrentType(this._currentObject.getClass());
        }
    }

    public Object getRoot() {
        return this._root;
    }

    public boolean getTraceEvaluations() {
        return this._traceEvaluations;
    }

    public void setTraceEvaluations(boolean value2) {
        this._traceEvaluations = value2;
    }

    public Evaluation getLastEvaluation() {
        return this._lastEvaluation;
    }

    public void setLastEvaluation(Evaluation value2) {
        this._lastEvaluation = value2;
    }

    @Deprecated
    public void recycleLastEvaluation() {
        OgnlRuntime.getEvaluationPool().recycleAll(this._lastEvaluation);
        this._lastEvaluation = null;
    }

    public boolean getKeepLastEvaluation() {
        return this._keepLastEvaluation;
    }

    public void setKeepLastEvaluation(boolean value2) {
        this._keepLastEvaluation = value2;
    }

    public void setCurrentObject(Object value2) {
        this._currentObject = value2;
    }

    public Object getCurrentObject() {
        return this._currentObject;
    }

    public void setCurrentAccessor(Class type2) {
        this._accessorStack.add(type2);
    }

    public Class getCurrentAccessor() {
        if (this._accessorStack.isEmpty()) {
            return null;
        }
        return this._accessorStack.get(this._accessorStack.size() - 1);
    }

    public Class getPreviousAccessor() {
        if (this._accessorStack.isEmpty()) {
            return null;
        }
        if (this._accessorStack.size() > 1) {
            return this._accessorStack.get(this._accessorStack.size() - 2);
        }
        return null;
    }

    public Class getFirstAccessor() {
        if (this._accessorStack.isEmpty()) {
            return null;
        }
        return this._accessorStack.get(0);
    }

    public Class getCurrentType() {
        if (this._typeStack.isEmpty()) {
            return null;
        }
        return this._typeStack.get(this._typeStack.size() - 1);
    }

    public void setCurrentType(Class type2) {
        this._typeStack.add(type2);
    }

    public Class getPreviousType() {
        if (this._typeStack.isEmpty()) {
            return null;
        }
        if (this._typeStack.size() > 1) {
            return this._typeStack.get(this._typeStack.size() - 2);
        }
        return null;
    }

    public void setPreviousType(Class type2) {
        if (this._typeStack.isEmpty() || this._typeStack.size() < 2) {
            return;
        }
        this._typeStack.set(this._typeStack.size() - 2, type2);
    }

    public Class getFirstType() {
        if (this._typeStack.isEmpty()) {
            return null;
        }
        return this._typeStack.get(0);
    }

    public void setCurrentNode(Node value2) {
        this._currentNode = value2;
    }

    public Node getCurrentNode() {
        return this._currentNode;
    }

    public Evaluation getCurrentEvaluation() {
        return this._currentEvaluation;
    }

    public void setCurrentEvaluation(Evaluation value2) {
        this._currentEvaluation = value2;
    }

    public Evaluation getRootEvaluation() {
        return this._rootEvaluation;
    }

    public void setRootEvaluation(Evaluation value2) {
        this._rootEvaluation = value2;
    }

    public Evaluation getEvaluation(int relativeIndex) {
        Evaluation result2 = null;
        if (relativeIndex <= 0) {
            for (result2 = this._currentEvaluation; ++relativeIndex < 0 && result2 != null; result2 = result2.getParent()) {
            }
        }
        return result2;
    }

    public void pushEvaluation(Evaluation value2) {
        if (this._currentEvaluation != null) {
            this._currentEvaluation.addChild(value2);
        } else {
            this.setRootEvaluation(value2);
        }
        this.setCurrentEvaluation(value2);
    }

    public Evaluation popEvaluation() {
        Evaluation result2 = this._currentEvaluation;
        this.setCurrentEvaluation(result2.getParent());
        if (this._currentEvaluation == null) {
            this.setLastEvaluation(this.getKeepLastEvaluation() ? result2 : null);
            this.setRootEvaluation(null);
            this.setCurrentNode(null);
        }
        return result2;
    }

    public int incrementLocalReferenceCounter() {
        return ++this._localReferenceCounter;
    }

    public void addLocalReference(String key2, LocalReference reference) {
        if (this._localReferenceMap == null) {
            this._localReferenceMap = new LinkedHashMap<String, LocalReference>();
        }
        this._localReferenceMap.put(key2, reference);
    }

    public Map getLocalReferences() {
        return this._localReferenceMap;
    }

    @Override
    public int size() {
        return this._values.size();
    }

    @Override
    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this._values.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this._values.containsValue(value2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(Object key2) {
        void var2_8;
        if (RESERVED_KEYS.containsKey(key2)) {
            if (key2.equals(THIS_CONTEXT_KEY)) {
                Object object = this.getCurrentObject();
                return var2_8;
            } else if (key2.equals(ROOT_CONTEXT_KEY)) {
                Object object = this.getRoot();
                return var2_8;
            } else if (key2.equals(TRACE_EVALUATIONS_CONTEXT_KEY)) {
                Boolean bl = this.getTraceEvaluations() ? Boolean.TRUE : Boolean.FALSE;
                return var2_8;
            } else if (key2.equals(LAST_EVALUATION_CONTEXT_KEY)) {
                Evaluation evaluation = this.getLastEvaluation();
                return var2_8;
            } else {
                if (!key2.equals(KEEP_LAST_EVALUATION_CONTEXT_KEY)) throw new IllegalArgumentException("unknown reserved key '" + key2 + "'");
                Boolean bl = this.getKeepLastEvaluation() ? Boolean.TRUE : Boolean.FALSE;
            }
            return var2_8;
        } else {
            Object v = this._values.get(key2);
        }
        return var2_8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object key2, Object value2) {
        Object result2;
        if (!RESERVED_KEYS.containsKey(key2)) return this._values.put(key2, value2);
        if (key2.equals(THIS_CONTEXT_KEY)) {
            result2 = this.getCurrentObject();
            this.setCurrentObject(value2);
            return result2;
        } else if (key2.equals(ROOT_CONTEXT_KEY)) {
            result2 = this.getRoot();
            this.setRoot(value2);
            return result2;
        } else if (key2.equals(TRACE_EVALUATIONS_CONTEXT_KEY)) {
            result2 = this.getTraceEvaluations() ? Boolean.TRUE : Boolean.FALSE;
            this.setTraceEvaluations(OgnlOps.booleanValue(value2));
            return result2;
        } else if (key2.equals(LAST_EVALUATION_CONTEXT_KEY)) {
            result2 = this.getLastEvaluation();
            this._lastEvaluation = (Evaluation)value2;
            return result2;
        } else {
            if (!key2.equals(KEEP_LAST_EVALUATION_CONTEXT_KEY)) throw new IllegalArgumentException("unknown reserved key '" + key2 + "'");
            result2 = this.getKeepLastEvaluation() ? Boolean.TRUE : Boolean.FALSE;
            this.setKeepLastEvaluation(OgnlOps.booleanValue(value2));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object remove(Object key2) {
        void var2_6;
        if (!RESERVED_KEYS.containsKey(key2)) {
            Object v = this._values.remove(key2);
            return var2_6;
        }
        if (key2.equals(THIS_CONTEXT_KEY)) {
            Object object = this.getCurrentObject();
            this.setCurrentObject(null);
            return var2_6;
        }
        if (key2.equals(ROOT_CONTEXT_KEY)) {
            Object object = this.getRoot();
            this.setRoot(null);
            return var2_6;
        }
        if (key2.equals(TRACE_EVALUATIONS_CONTEXT_KEY)) {
            throw new IllegalArgumentException("can't remove _traceEvaluations from context");
        }
        if (key2.equals(LAST_EVALUATION_CONTEXT_KEY)) {
            Evaluation evaluation = this._lastEvaluation;
            this.setLastEvaluation(null);
            return var2_6;
        }
        if (!key2.equals(KEEP_LAST_EVALUATION_CONTEXT_KEY)) throw new IllegalArgumentException("unknown reserved key '" + key2 + "'");
        throw new IllegalArgumentException("can't remove _keepLastEvaluation from context");
    }

    public void putAll(Map t2) {
        for (Object k2 : t2.keySet()) {
            this.put(k2, t2.get(k2));
        }
    }

    @Override
    public void clear() {
        this._values.clear();
        this._typeStack.clear();
        this._accessorStack.clear();
        this._localReferenceCounter = 0;
        if (this._localReferenceMap != null) {
            this._localReferenceMap.clear();
        }
        this.setRoot(null);
        this.setCurrentObject(null);
        this.setRootEvaluation(null);
        this.setCurrentEvaluation(null);
        this.setLastEvaluation(null);
        this.setCurrentNode(null);
    }

    public Set keySet() {
        return this._values.keySet();
    }

    public Collection values() {
        return this._values.values();
    }

    public Set entrySet() {
        return this._values.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this._values.equals(o);
    }

    @Override
    public int hashCode() {
        return this._values.hashCode();
    }

    static {
        RESERVED_KEYS.put(ROOT_CONTEXT_KEY, null);
        RESERVED_KEYS.put(THIS_CONTEXT_KEY, null);
        RESERVED_KEYS.put(TRACE_EVALUATIONS_CONTEXT_KEY, null);
        RESERVED_KEYS.put(LAST_EVALUATION_CONTEXT_KEY, null);
        RESERVED_KEYS.put(KEEP_LAST_EVALUATION_CONTEXT_KEY, null);
        try {
            String s2 = System.getProperty("ognl.traceEvaluations");
            if (s2 != null) {
                DEFAULT_TRACE_EVALUATIONS = Boolean.valueOf(s2.trim());
            }
            if ((s2 = System.getProperty("ognl.keepLastEvaluation")) != null) {
                DEFAULT_KEEP_LAST_EVALUATION = Boolean.valueOf(s2.trim());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

