/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Enumeration;
import ognl.ElementsAccessor;
import ognl.NumericTypes;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.enhance.UnsupportedCompilationException;

public abstract class OgnlOps
implements NumericTypes {
    public static int compareWithConversion(Object v1, Object v2) {
        int result2;
        if (v1 == v2) {
            result2 = 0;
        } else {
            int t1 = OgnlOps.getNumericType(v1);
            int t2 = OgnlOps.getNumericType(v2);
            int type2 = OgnlOps.getNumericType(t1, t2, true);
            switch (type2) {
                case 6: {
                    result2 = OgnlOps.bigIntValue(v1).compareTo(OgnlOps.bigIntValue(v2));
                    break;
                }
                case 9: {
                    result2 = OgnlOps.bigDecValue(v1).compareTo(OgnlOps.bigDecValue(v2));
                    break;
                }
                case 10: {
                    if (t1 == 10 && t2 == 10) {
                        if (v1 instanceof Comparable && v1.getClass().isAssignableFrom(v2.getClass())) {
                            result2 = ((Comparable)v1).compareTo(v2);
                            break;
                        }
                        if (v1 instanceof Enum && v2 instanceof Enum && (v1.getClass() == v2.getClass() || ((Enum)v1).getDeclaringClass() == ((Enum)v2).getDeclaringClass())) {
                            result2 = ((Enum)v1).compareTo((Enum)v2);
                            break;
                        }
                        throw new IllegalArgumentException("invalid comparison: " + v1.getClass().getName() + " and " + v2.getClass().getName());
                    }
                }
                case 7: 
                case 8: {
                    double dv1 = OgnlOps.doubleValue(v1);
                    double dv2 = OgnlOps.doubleValue(v2);
                    return dv1 == dv2 ? 0 : (dv1 < dv2 ? -1 : 1);
                }
                default: {
                    long lv1 = OgnlOps.longValue(v1);
                    long lv2 = OgnlOps.longValue(v2);
                    return lv1 == lv2 ? 0 : (lv1 < lv2 ? -1 : 1);
                }
            }
        }
        return result2;
    }

    public static boolean isEqual(Object object1, Object object2) {
        boolean result2 = false;
        if (object1 == object2) {
            result2 = true;
        } else if (object1 != null && object2 != null) {
            if (object1.getClass().isArray()) {
                if (object2.getClass().isArray() && object2.getClass() == object1.getClass()) {
                    boolean bl = result2 = Array.getLength(object1) == Array.getLength(object2);
                    if (result2) {
                        int icount = Array.getLength(object1);
                        for (int i2 = 0; result2 && i2 < icount; ++i2) {
                            result2 = OgnlOps.isEqual(Array.get(object1, i2), Array.get(object2, i2));
                        }
                    }
                }
            } else {
                int t1 = OgnlOps.getNumericType(object1);
                int t2 = OgnlOps.getNumericType(object2);
                result2 = t1 == 10 && t2 == 10 && (!(object1 instanceof Comparable) || !(object2 instanceof Comparable)) ? object1.equals(object2) : OgnlOps.compareWithConversion(object1, object2) == 0;
            }
        }
        return result2;
    }

    public static boolean booleanValue(boolean value2) {
        return value2;
    }

    public static boolean booleanValue(int value2) {
        return value2 > 0;
    }

    public static boolean booleanValue(float value2) {
        return value2 > 0.0f;
    }

    public static boolean booleanValue(long value2) {
        return value2 > 0L;
    }

    public static boolean booleanValue(double value2) {
        return value2 > 0.0;
    }

    public static boolean booleanValue(Object value2) {
        if (value2 == null) {
            return false;
        }
        Class<?> c2 = value2.getClass();
        if (c2 == Boolean.class) {
            return (Boolean)value2;
        }
        if (c2 == String.class) {
            return Boolean.parseBoolean(String.valueOf(value2));
        }
        if (c2 == Character.class) {
            return ((Character)value2).charValue() != '\u0000';
        }
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue() != 0.0;
        }
        return true;
    }

    public static long longValue(Object value2) throws NumberFormatException {
        if (value2 == null) {
            return 0L;
        }
        Class<?> c2 = value2.getClass();
        if (c2.getSuperclass() == Number.class) {
            return ((Number)value2).longValue();
        }
        if (c2 == Boolean.class) {
            return (Boolean)value2 != false ? 1L : 0L;
        }
        if (c2 == Character.class) {
            return ((Character)value2).charValue();
        }
        return Long.parseLong(OgnlOps.stringValue(value2, true));
    }

    public static double doubleValue(Object value2) throws NumberFormatException {
        if (value2 == null) {
            return 0.0;
        }
        Class<?> c2 = value2.getClass();
        if (c2.getSuperclass() == Number.class) {
            return ((Number)value2).doubleValue();
        }
        if (c2 == Boolean.class) {
            return (Boolean)value2 != false ? 1.0 : 0.0;
        }
        if (c2 == Character.class) {
            return ((Character)value2).charValue();
        }
        String s2 = OgnlOps.stringValue(value2, true);
        return s2.length() == 0 ? 0.0 : Double.parseDouble(s2);
    }

    public static BigInteger bigIntValue(Object value2) throws NumberFormatException {
        if (value2 == null) {
            return BigInteger.valueOf(0L);
        }
        Class<?> c2 = value2.getClass();
        if (c2 == BigInteger.class) {
            return (BigInteger)value2;
        }
        if (c2 == BigDecimal.class) {
            return ((BigDecimal)value2).toBigInteger();
        }
        if (c2.getSuperclass() == Number.class) {
            return BigInteger.valueOf(((Number)value2).longValue());
        }
        if (c2 == Boolean.class) {
            return BigInteger.valueOf((Boolean)value2 != false ? 1L : 0L);
        }
        if (c2 == Character.class) {
            return BigInteger.valueOf(((Character)value2).charValue());
        }
        return new BigInteger(OgnlOps.stringValue(value2, true));
    }

    public static BigDecimal bigDecValue(Object value2) throws NumberFormatException {
        if (value2 == null) {
            return BigDecimal.valueOf(0L);
        }
        Class<?> c2 = value2.getClass();
        if (c2 == BigDecimal.class) {
            return (BigDecimal)value2;
        }
        if (c2 == BigInteger.class) {
            return new BigDecimal((BigInteger)value2);
        }
        if (c2 == Boolean.class) {
            return BigDecimal.valueOf((Boolean)value2 != false ? 1L : 0L);
        }
        if (c2 == Character.class) {
            return BigDecimal.valueOf(((Character)value2).charValue());
        }
        return new BigDecimal(OgnlOps.stringValue(value2, true));
    }

    public static String stringValue(Object value2, boolean trim) {
        String result2;
        if (value2 == null) {
            result2 = OgnlRuntime.NULL_STRING;
        } else {
            result2 = value2.toString();
            if (trim) {
                result2 = result2.trim();
            }
        }
        return result2;
    }

    public static String stringValue(Object value2) {
        return OgnlOps.stringValue(value2, false);
    }

    public static int getNumericType(Object value2) {
        if (value2 != null) {
            Class<?> c2 = value2.getClass();
            if (c2 == Integer.class) {
                return 4;
            }
            if (c2 == Double.class) {
                return 8;
            }
            if (c2 == Boolean.class) {
                return 0;
            }
            if (c2 == Byte.class) {
                return 1;
            }
            if (c2 == Character.class) {
                return 2;
            }
            if (c2 == Short.class) {
                return 3;
            }
            if (c2 == Long.class) {
                return 5;
            }
            if (c2 == Float.class) {
                return 7;
            }
            if (c2 == BigInteger.class) {
                return 6;
            }
            if (c2 == BigDecimal.class) {
                return 9;
            }
        }
        return 10;
    }

    public static Object toArray(char value2, Class toType) {
        return OgnlOps.toArray(new Character(value2), toType);
    }

    public static Object toArray(byte value2, Class toType) {
        return OgnlOps.toArray(new Byte(value2), toType);
    }

    public static Object toArray(int value2, Class toType) {
        return OgnlOps.toArray(new Integer(value2), toType);
    }

    public static Object toArray(long value2, Class toType) {
        return OgnlOps.toArray(new Long(value2), toType);
    }

    public static Object toArray(float value2, Class toType) {
        return OgnlOps.toArray(new Float(value2), toType);
    }

    public static Object toArray(double value2, Class toType) {
        return OgnlOps.toArray(new Double(value2), toType);
    }

    public static Object toArray(boolean value2, Class toType) {
        return OgnlOps.toArray(new Boolean(value2), toType);
    }

    public static Object convertValue(char value2, Class toType) {
        return OgnlOps.convertValue(new Character(value2), toType);
    }

    public static Object convertValue(byte value2, Class toType) {
        return OgnlOps.convertValue(new Byte(value2), toType);
    }

    public static Object convertValue(int value2, Class toType) {
        return OgnlOps.convertValue(new Integer(value2), toType);
    }

    public static Object convertValue(long value2, Class toType) {
        return OgnlOps.convertValue(new Long(value2), toType);
    }

    public static Object convertValue(float value2, Class toType) {
        return OgnlOps.convertValue(new Float(value2), toType);
    }

    public static Object convertValue(double value2, Class toType) {
        return OgnlOps.convertValue(new Double(value2), toType);
    }

    public static Object convertValue(boolean value2, Class toType) {
        return OgnlOps.convertValue(new Boolean(value2), toType);
    }

    public static Object convertValue(char value2, Class toType, boolean preventNull) {
        return OgnlOps.convertValue(new Character(value2), toType, preventNull);
    }

    public static Object convertValue(byte value2, Class toType, boolean preventNull) {
        return OgnlOps.convertValue(new Byte(value2), toType, preventNull);
    }

    public static Object convertValue(int value2, Class toType, boolean preventNull) {
        return OgnlOps.convertValue(new Integer(value2), toType, preventNull);
    }

    public static Object convertValue(long value2, Class toType, boolean preventNull) {
        return OgnlOps.convertValue(new Long(value2), toType, preventNull);
    }

    public static Object convertValue(float value2, Class toType, boolean preventNull) {
        return OgnlOps.convertValue(new Float(value2), toType, preventNull);
    }

    public static Object convertValue(double value2, Class toType, boolean preventNull) {
        return OgnlOps.convertValue(new Double(value2), toType, preventNull);
    }

    public static Object convertValue(boolean value2, Class toType, boolean preventNull) {
        return OgnlOps.convertValue(new Boolean(value2), toType, preventNull);
    }

    public static Object toArray(char value2, Class toType, boolean preventNull) {
        return OgnlOps.toArray(new Character(value2), toType, preventNull);
    }

    public static Object toArray(byte value2, Class toType, boolean preventNull) {
        return OgnlOps.toArray(new Byte(value2), toType, preventNull);
    }

    public static Object toArray(int value2, Class toType, boolean preventNull) {
        return OgnlOps.toArray(new Integer(value2), toType, preventNull);
    }

    public static Object toArray(long value2, Class toType, boolean preventNull) {
        return OgnlOps.toArray(new Long(value2), toType, preventNull);
    }

    public static Object toArray(float value2, Class toType, boolean preventNull) {
        return OgnlOps.toArray(new Float(value2), toType, preventNull);
    }

    public static Object toArray(double value2, Class toType, boolean preventNull) {
        return OgnlOps.toArray(new Double(value2), toType, preventNull);
    }

    public static Object toArray(boolean value2, Class toType, boolean preventNull) {
        return OgnlOps.toArray(new Boolean(value2), toType, preventNull);
    }

    public static Object convertValue(Object value2, Class toType) {
        return OgnlOps.convertValue(value2, toType, false);
    }

    public static Object toArray(Object value2, Class toType) {
        return OgnlOps.toArray(value2, toType, false);
    }

    public static Object toArray(Object value2, Class toType, boolean preventNulls) {
        if (value2 == null) {
            return null;
        }
        Object result2 = null;
        if (value2.getClass().isArray() && toType.isAssignableFrom(value2.getClass().getComponentType())) {
            return value2;
        }
        if (!value2.getClass().isArray()) {
            if (toType == Character.TYPE) {
                return OgnlOps.stringValue(value2).toCharArray();
            }
            if (value2 instanceof Collection) {
                return ((Collection)value2).toArray((Object[])Array.newInstance(toType, 0));
            }
            Object arr = Array.newInstance(toType, 1);
            Array.set(arr, 0, OgnlOps.convertValue(value2, toType, preventNulls));
            return arr;
        }
        result2 = Array.newInstance(toType, Array.getLength(value2));
        int icount = Array.getLength(value2);
        for (int i2 = 0; i2 < icount; ++i2) {
            Array.set(result2, i2, OgnlOps.convertValue(Array.get(value2, i2), toType));
        }
        if (result2 == null && preventNulls) {
            return value2;
        }
        return result2;
    }

    public static Object convertValue(Object value2, Class toType, boolean preventNulls) {
        Object result2 = null;
        if (value2 != null && toType.isAssignableFrom(value2.getClass())) {
            return value2;
        }
        if (value2 != null) {
            if (value2.getClass().isArray() && toType.isArray()) {
                Class<?> componentType = toType.getComponentType();
                result2 = Array.newInstance(componentType, Array.getLength(value2));
                int icount = Array.getLength(value2);
                for (int i2 = 0; i2 < icount; ++i2) {
                    Array.set(result2, i2, OgnlOps.convertValue(Array.get(value2, i2), componentType));
                }
            } else {
                if (value2.getClass().isArray() && !toType.isArray()) {
                    return OgnlOps.convertValue(Array.get(value2, 0), toType);
                }
                if (!value2.getClass().isArray() && toType.isArray()) {
                    if (toType.getComponentType() == Character.TYPE) {
                        result2 = OgnlOps.stringValue(value2).toCharArray();
                    } else if (toType.getComponentType() == Object.class) {
                        if (value2 instanceof Collection) {
                            Collection vc = (Collection)value2;
                            return vc.toArray(new Object[0]);
                        }
                        return new Object[]{value2};
                    }
                } else {
                    if (toType == Integer.class || toType == Integer.TYPE) {
                        result2 = new Integer((int)OgnlOps.longValue(value2));
                    }
                    if (toType == Double.class || toType == Double.TYPE) {
                        result2 = new Double(OgnlOps.doubleValue(value2));
                    }
                    if (toType == Boolean.class || toType == Boolean.TYPE) {
                        Object object = result2 = OgnlOps.booleanValue(value2) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    if (toType == Byte.class || toType == Byte.TYPE) {
                        result2 = new Byte((byte)OgnlOps.longValue(value2));
                    }
                    if (toType == Character.class || toType == Character.TYPE) {
                        result2 = new Character((char)OgnlOps.longValue(value2));
                    }
                    if (toType == Short.class || toType == Short.TYPE) {
                        result2 = new Short((short)OgnlOps.longValue(value2));
                    }
                    if (toType == Long.class || toType == Long.TYPE) {
                        result2 = new Long(OgnlOps.longValue(value2));
                    }
                    if (toType == Float.class || toType == Float.TYPE) {
                        result2 = new Float(OgnlOps.doubleValue(value2));
                    }
                    if (toType == BigInteger.class) {
                        result2 = OgnlOps.bigIntValue(value2);
                    }
                    if (toType == BigDecimal.class) {
                        result2 = OgnlOps.bigDecValue(value2);
                    }
                    if (toType == String.class) {
                        result2 = OgnlOps.stringValue(value2);
                    }
                }
            }
        } else if (toType.isPrimitive()) {
            result2 = OgnlRuntime.getPrimitiveDefaultValue(toType);
        } else if (preventNulls && toType == Boolean.class) {
            result2 = Boolean.FALSE;
        } else if (preventNulls && Number.class.isAssignableFrom(toType)) {
            result2 = OgnlRuntime.getNumericDefaultValue(toType);
        }
        if (result2 == null && preventNulls) {
            return value2;
        }
        if (value2 != null && result2 == null) {
            throw new IllegalArgumentException("Unable to convert type " + value2.getClass().getName() + " of " + value2 + " to type of " + toType.getName());
        }
        return result2;
    }

    public static int getIntValue(Object value2) {
        try {
            if (value2 == null) {
                return -1;
            }
            if (Number.class.isInstance(value2)) {
                return ((Number)value2).intValue();
            }
            String str = String.class.isInstance(value2) ? (String)value2 : value2.toString();
            return Integer.parseInt(str);
        }
        catch (Throwable t2) {
            throw new RuntimeException("Error converting " + value2 + " to integer:", t2);
        }
    }

    public static int getNumericType(Object v1, Object v2) {
        return OgnlOps.getNumericType(v1, v2, false);
    }

    public static int getNumericType(int t1, int t2, boolean canBeNonNumeric) {
        if (t1 == t2) {
            return t1;
        }
        if (canBeNonNumeric && (t1 == 10 || t2 == 10 || t1 == 2 || t2 == 2)) {
            return 10;
        }
        if (t1 == 10) {
            t1 = 8;
        }
        if (t2 == 10) {
            t2 = 8;
        }
        if (t1 >= 7) {
            if (t2 >= 7) {
                return Math.max(t1, t2);
            }
            if (t2 < 4) {
                return t1;
            }
            if (t2 == 6) {
                return 9;
            }
            return Math.max(8, t1);
        }
        if (t2 >= 7) {
            if (t1 < 4) {
                return t2;
            }
            if (t1 == 6) {
                return 9;
            }
            return Math.max(8, t2);
        }
        return Math.max(t1, t2);
    }

    public static int getNumericType(Object v1, Object v2, boolean canBeNonNumeric) {
        return OgnlOps.getNumericType(OgnlOps.getNumericType(v1), OgnlOps.getNumericType(v2), canBeNonNumeric);
    }

    public static Number newInteger(int type2, long value2) {
        switch (type2) {
            case 0: 
            case 2: 
            case 4: {
                return new Integer((int)value2);
            }
            case 7: {
                if ((long)((float)value2) == value2) {
                    return new Float(value2);
                }
            }
            case 8: {
                if ((long)((double)value2) == value2) {
                    return new Double(value2);
                }
            }
            case 5: {
                return new Long(value2);
            }
            case 1: {
                return new Byte((byte)value2);
            }
            case 3: {
                return new Short((short)value2);
            }
        }
        return BigInteger.valueOf(value2);
    }

    public static Number newReal(int type2, double value2) {
        if (type2 == 7) {
            return new Float((float)value2);
        }
        return new Double(value2);
    }

    public static Object binaryOr(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1, v2);
        if (type2 == 6 || type2 == 9) {
            return OgnlOps.bigIntValue(v1).or(OgnlOps.bigIntValue(v2));
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) | OgnlOps.longValue(v2));
    }

    public static Object binaryXor(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1, v2);
        if (type2 == 6 || type2 == 9) {
            return OgnlOps.bigIntValue(v1).xor(OgnlOps.bigIntValue(v2));
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) ^ OgnlOps.longValue(v2));
    }

    public static Object binaryAnd(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1, v2);
        if (type2 == 6 || type2 == 9) {
            return OgnlOps.bigIntValue(v1).and(OgnlOps.bigIntValue(v2));
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) & OgnlOps.longValue(v2));
    }

    public static boolean equal(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        return v1 == v2 || OgnlOps.isEqual(v1, v2);
    }

    public static boolean less(Object v1, Object v2) {
        return OgnlOps.compareWithConversion(v1, v2) < 0;
    }

    public static boolean greater(Object v1, Object v2) {
        return OgnlOps.compareWithConversion(v1, v2) > 0;
    }

    public static boolean in(Object v1, Object v2) throws OgnlException {
        if (v2 == null) {
            return false;
        }
        ElementsAccessor elementsAccessor = OgnlRuntime.getElementsAccessor(OgnlRuntime.getTargetClass(v2));
        Enumeration e2 = elementsAccessor.getElements(v2);
        while (e2.hasMoreElements()) {
            Object o = e2.nextElement();
            if (!OgnlOps.equal(v1, o)) continue;
            return true;
        }
        return false;
    }

    public static Object shiftLeft(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1);
        if (type2 == 6 || type2 == 9) {
            return OgnlOps.bigIntValue(v1).shiftLeft((int)OgnlOps.longValue(v2));
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) << (int)OgnlOps.longValue(v2));
    }

    public static Object shiftRight(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1);
        if (type2 == 6 || type2 == 9) {
            return OgnlOps.bigIntValue(v1).shiftRight((int)OgnlOps.longValue(v2));
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) >> (int)OgnlOps.longValue(v2));
    }

    public static Object unsignedShiftRight(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1);
        if (type2 == 6 || type2 == 9) {
            return OgnlOps.bigIntValue(v1).shiftRight((int)OgnlOps.longValue(v2));
        }
        if (type2 <= 4) {
            return OgnlOps.newInteger(4, (int)OgnlOps.longValue(v1) >>> (int)OgnlOps.longValue(v2));
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) >>> (int)OgnlOps.longValue(v2));
    }

    public static Object add(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1, v2, true);
        switch (type2) {
            case 6: {
                return OgnlOps.bigIntValue(v1).add(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).add(OgnlOps.bigDecValue(v2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type2, OgnlOps.doubleValue(v1) + OgnlOps.doubleValue(v2));
            }
            case 10: {
                int t1 = OgnlOps.getNumericType(v1);
                int t2 = OgnlOps.getNumericType(v2);
                if (t1 != 10 && v2 == null || t2 != 10 && v1 == null) {
                    throw new NullPointerException("Can't add values " + v1 + " , " + v2);
                }
                return OgnlOps.stringValue(v1) + OgnlOps.stringValue(v2);
            }
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) + OgnlOps.longValue(v2));
    }

    public static Object subtract(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1, v2);
        switch (type2) {
            case 6: {
                return OgnlOps.bigIntValue(v1).subtract(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).subtract(OgnlOps.bigDecValue(v2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type2, OgnlOps.doubleValue(v1) - OgnlOps.doubleValue(v2));
            }
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) - OgnlOps.longValue(v2));
    }

    public static Object multiply(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1, v2);
        switch (type2) {
            case 6: {
                return OgnlOps.bigIntValue(v1).multiply(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).multiply(OgnlOps.bigDecValue(v2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type2, OgnlOps.doubleValue(v1) * OgnlOps.doubleValue(v2));
            }
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) * OgnlOps.longValue(v2));
    }

    public static Object divide(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1, v2);
        switch (type2) {
            case 6: {
                return OgnlOps.bigIntValue(v1).divide(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).divide(OgnlOps.bigDecValue(v2), 6);
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type2, OgnlOps.doubleValue(v1) / OgnlOps.doubleValue(v2));
            }
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) / OgnlOps.longValue(v2));
    }

    public static Object remainder(Object v1, Object v2) {
        int type2 = OgnlOps.getNumericType(v1, v2);
        switch (type2) {
            case 6: 
            case 9: {
                return OgnlOps.bigIntValue(v1).remainder(OgnlOps.bigIntValue(v2));
            }
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(v1) % OgnlOps.longValue(v2));
    }

    public static Object negate(Object value2) {
        int type2 = OgnlOps.getNumericType(value2);
        switch (type2) {
            case 6: {
                return OgnlOps.bigIntValue(value2).negate();
            }
            case 9: {
                return OgnlOps.bigDecValue(value2).negate();
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type2, -OgnlOps.doubleValue(value2));
            }
        }
        return OgnlOps.newInteger(type2, -OgnlOps.longValue(value2));
    }

    public static Object bitNegate(Object value2) {
        int type2 = OgnlOps.getNumericType(value2);
        switch (type2) {
            case 6: 
            case 9: {
                return OgnlOps.bigIntValue(value2).not();
            }
        }
        return OgnlOps.newInteger(type2, OgnlOps.longValue(value2) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static String getEscapeString(String value2) {
        StringBuffer result2 = new StringBuffer();
        int icount = value2.length();
        for (int i2 = 0; i2 < icount; ++i2) {
            result2.append(OgnlOps.getEscapedChar(value2.charAt(i2)));
        }
        return new String(result2);
    }

    public static String getEscapedChar(char ch) {
        String result2;
        switch (ch) {
            case '\b': {
                result2 = "\b";
                break;
            }
            case '\t': {
                result2 = "\\t";
                break;
            }
            case '\n': {
                result2 = "\\n";
                break;
            }
            case '\f': {
                result2 = "\\f";
                break;
            }
            case '\r': {
                result2 = "\\r";
                break;
            }
            case '\"': {
                result2 = "\\\"";
                break;
            }
            case '\'': {
                result2 = "\\'";
                break;
            }
            case '\\': {
                result2 = "\\\\";
                break;
            }
            default: {
                if (Character.isISOControl(ch)) {
                    String hc = Integer.toString(ch, 16);
                    int hcl = hc.length();
                    result2 = "\\u";
                    if (hcl < 4) {
                        result2 = hcl == 3 ? result2 + "0" : (hcl == 2 ? result2 + "00" : result2 + "000");
                    }
                    result2 = result2 + hc;
                    break;
                }
                result2 = new String(ch + "");
            }
        }
        return result2;
    }

    public static Object returnValue(Object ignore, Object returnValue2) {
        return returnValue2;
    }

    public static RuntimeException castToRuntime(Throwable t2) {
        if (RuntimeException.class.isInstance(t2)) {
            return (RuntimeException)t2;
        }
        if (OgnlException.class.isInstance(t2)) {
            throw new UnsupportedCompilationException("Error evluating expression: " + t2.getMessage(), t2);
        }
        return new RuntimeException(t2);
    }
}

