/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ognl.ASTChain;
import ognl.ASTConst;
import ognl.AccessibleObjectHandler;
import ognl.AccessibleObjectHandlerJDK9Plus;
import ognl.AccessibleObjectHandlerPreJDK9;
import ognl.ArrayElementsAccessor;
import ognl.ArrayPropertyAccessor;
import ognl.ClassCacheInspector;
import ognl.ClassResolver;
import ognl.CollectionElementsAccessor;
import ognl.DefaultClassResolver;
import ognl.ElementsAccessor;
import ognl.EnumerationElementsAccessor;
import ognl.EnumerationPropertyAccessor;
import ognl.EvaluationPool;
import ognl.IteratorElementsAccessor;
import ognl.IteratorPropertyAccessor;
import ognl.ListPropertyAccessor;
import ognl.MapElementsAccessor;
import ognl.MapPropertyAccessor;
import ognl.MemberAccess;
import ognl.MethodAccessor;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.Node;
import ognl.NullHandler;
import ognl.NumberElementsAccessor;
import ognl.ObjectArrayPool;
import ognl.ObjectElementsAccessor;
import ognl.ObjectIndexedPropertyDescriptor;
import ognl.ObjectMethodAccessor;
import ognl.ObjectNullHandler;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlInvokePermission;
import ognl.OgnlOps;
import ognl.PropertyAccessor;
import ognl.SetPropertyAccessor;
import ognl.TypeConverter;
import ognl.enhance.ExpressionCompiler;
import ognl.enhance.OgnlExpressionCompiler;
import ognl.internal.ClassCache;
import ognl.internal.ClassCacheImpl;
import ognl.security.OgnlSecurityManagerFactory;
import ognl.security.UserMethod;

public class OgnlRuntime {
    public static final Object NotFound;
    public static final List NotFoundList;
    public static final Map NotFoundMap;
    public static final Object[] NoArguments;
    public static final Class[] NoArgumentTypes;
    public static final Object NoConversionPossible;
    public static int INDEXED_PROPERTY_NONE;
    public static int INDEXED_PROPERTY_INT;
    public static int INDEXED_PROPERTY_OBJECT;
    public static final String NULL_STRING;
    private static final String SET_PREFIX = "set";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final Map HEX_PADDING;
    private static final int HEX_LENGTH = 8;
    private static final String NULL_OBJECT_STRING = "<null>";
    private static boolean _jdk15;
    private static boolean _jdkChecked;
    static final String USE_JDK9PLUS_ACESS_HANDLER = "ognl.UseJDK9PlusAccessHandler";
    static final String USE_STRICTER_INVOCATION = "ognl.UseStricterInvocation";
    private static final boolean _useJDK9PlusAccessHandler;
    private static final boolean _useStricterInvocation;
    private static final int _majorJavaVersion;
    private static final boolean _jdk9Plus;
    private static final AccessibleObjectHandler _accessibleObjectHandler;
    private static final Method SYS_CONSOLE_REF;
    private static final Method SYS_EXIT_REF;
    private static final Method AO_SETACCESSIBLE_REF;
    private static final Method AO_SETACCESSIBLE_ARR_REF;
    static final String OGNL_SECURITY_MANAGER = "ognl.security.manager";
    static final String OGNL_SM_FORCE_DISABLE_ON_INIT = "forceDisableOnInit";
    private static final boolean _disableOgnlSecurityManagerOnInit;
    static final String USE_FIRSTMATCH_GETSET_LOOKUP = "ognl.UseFirstMatchGetSetLookup";
    private static final boolean _useFirstMatchGetSetLookup;
    static final ClassCache _methodAccessors;
    static final ClassCache _propertyAccessors;
    static final ClassCache _elementsAccessors;
    static final ClassCache _nullHandlers;
    static final ClassCache _propertyDescriptorCache;
    static final ClassCache _constructorCache;
    static final ClassCache _staticMethodCache;
    static final ClassCache _instanceMethodCache;
    static final ClassCache _invokePermissionCache;
    static final ClassCache _fieldCache;
    static final List _superclasses;
    static final ClassCache[] _declaredMethods;
    static final Map _primitiveTypes;
    static final ClassCache _primitiveDefaults;
    static final Map _methodParameterTypesCache;
    static final Map _genericMethodParameterTypesCache;
    static final Map _ctorParameterTypesCache;
    static SecurityManager _securityManager;
    static final EvaluationPool _evaluationPool;
    static final ObjectArrayPool _objectArrayPool;
    static final Map<Method, Boolean> _methodAccessCache;
    static final Map<Method, Boolean> _methodPermCache;
    static final ClassPropertyMethodCache cacheSetMethod;
    static final ClassPropertyMethodCache cacheGetMethod;
    static ClassCacheInspector _cacheInspector;
    private static OgnlExpressionCompiler _compiler;
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static IdentityHashMap PRIMITIVE_WRAPPER_CLASSES;
    private static final Map NUMERIC_CASTS;
    private static final Map NUMERIC_VALUES;
    private static final Map NUMERIC_LITERALS;
    private static final Map NUMERIC_DEFAULTS;
    public static final ArgsCompatbilityReport NoArgsReport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Object object = _methodParameterTypesCache;
        synchronized (object) {
            _methodParameterTypesCache.clear();
        }
        object = _ctorParameterTypesCache;
        synchronized (object) {
            _ctorParameterTypesCache.clear();
        }
        object = _propertyDescriptorCache;
        synchronized (object) {
            _propertyDescriptorCache.clear();
        }
        object = _constructorCache;
        synchronized (object) {
            _constructorCache.clear();
        }
        object = _staticMethodCache;
        synchronized (object) {
            _staticMethodCache.clear();
        }
        object = _instanceMethodCache;
        synchronized (object) {
            _instanceMethodCache.clear();
        }
        object = _invokePermissionCache;
        synchronized (object) {
            _invokePermissionCache.clear();
        }
        object = _fieldCache;
        synchronized (object) {
            _fieldCache.clear();
            _superclasses.clear();
        }
        object = _declaredMethods[0];
        synchronized (object) {
            _declaredMethods[0].clear();
        }
        object = _declaredMethods[1];
        synchronized (object) {
            _declaredMethods[1].clear();
        }
        _methodAccessCache.clear();
        _methodPermCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAdditionalCache() {
        cacheSetMethod.clear();
        cacheGetMethod.clear();
        Map map2 = _genericMethodParameterTypesCache;
        synchronized (map2) {
            _genericMethodParameterTypesCache.clear();
        }
    }

    public static int getMajorJavaVersion() {
        return _majorJavaVersion;
    }

    public static boolean isJdk9Plus() {
        return _jdk9Plus;
    }

    public static String getNumericValueGetter(Class type2) {
        return (String)NUMERIC_VALUES.get(type2);
    }

    public static Class getPrimitiveWrapperClass(Class primitiveClass) {
        return (Class)PRIMITIVE_WRAPPER_CLASSES.get(primitiveClass);
    }

    public static String getNumericCast(Class type2) {
        return (String)NUMERIC_CASTS.get(type2);
    }

    public static String getNumericLiteral(Class type2) {
        return (String)NUMERIC_LITERALS.get(type2);
    }

    public static void setCompiler(OgnlExpressionCompiler compiler) {
        _compiler = compiler;
    }

    public static OgnlExpressionCompiler getCompiler() {
        return _compiler;
    }

    public static void compileExpression(OgnlContext context, Node expression, Object root) throws Exception {
        _compiler.compileExpression(context, expression, root);
    }

    public static Class getTargetClass(Object o) {
        return o == null ? null : (o instanceof Class ? (Class<?>)o : o.getClass());
    }

    public static String getBaseName(Object o) {
        return o == null ? null : OgnlRuntime.getClassBaseName(o.getClass());
    }

    public static String getClassBaseName(Class c2) {
        String s2 = c2.getName();
        return s2.substring(s2.lastIndexOf(46) + 1);
    }

    public static String getClassName(Object o, boolean fullyQualified) {
        if (!(o instanceof Class)) {
            o = o.getClass();
        }
        return OgnlRuntime.getClassName(o, fullyQualified);
    }

    public static String getClassName(Class c2, boolean fullyQualified) {
        return fullyQualified ? c2.getName() : OgnlRuntime.getClassBaseName(c2);
    }

    public static String getPackageName(Object o) {
        return o == null ? null : OgnlRuntime.getClassPackageName(o.getClass());
    }

    public static String getClassPackageName(Class c2) {
        String s2 = c2.getName();
        int i2 = s2.lastIndexOf(46);
        return i2 < 0 ? null : s2.substring(0, i2);
    }

    public static String getPointerString(int num) {
        StringBuffer result2 = new StringBuffer();
        String hex = Integer.toHexString(num);
        Integer l = new Integer(hex.length());
        String pad = (String)HEX_PADDING.get(l);
        if (pad == null) {
            StringBuffer pb = new StringBuffer();
            for (int i2 = hex.length(); i2 < 8; ++i2) {
                pb.append('0');
            }
            pad = new String(pb);
            HEX_PADDING.put(l, pad);
        }
        result2.append(pad);
        result2.append(hex);
        return new String(result2);
    }

    public static String getPointerString(Object o) {
        return OgnlRuntime.getPointerString(o == null ? 0 : System.identityHashCode(o));
    }

    public static String getUniqueDescriptor(Object object, boolean fullyQualified) {
        StringBuffer result2 = new StringBuffer();
        if (object != null) {
            if (object instanceof Proxy) {
                Class<?> interfaceClass = object.getClass().getInterfaces()[0];
                result2.append(OgnlRuntime.getClassName(interfaceClass, fullyQualified));
                result2.append('^');
                object = Proxy.getInvocationHandler(object);
            }
            result2.append(OgnlRuntime.getClassName(object, fullyQualified));
            result2.append('@');
            result2.append(OgnlRuntime.getPointerString(object));
        } else {
            result2.append(NULL_OBJECT_STRING);
        }
        return new String(result2);
    }

    public static String getUniqueDescriptor(Object object) {
        return OgnlRuntime.getUniqueDescriptor(object, false);
    }

    public static Object[] toArray(List list) {
        Object[] result2;
        int size2 = list.size();
        if (size2 == 0) {
            result2 = NoArguments;
        } else {
            result2 = OgnlRuntime.getObjectArrayPool().create(list.size());
            for (int i2 = 0; i2 < size2; ++i2) {
                result2[i2] = list.get(i2);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class[] getParameterTypes(Method m4) {
        Map map2 = _methodParameterTypesCache;
        synchronized (map2) {
            Class[] result2 = (Class[])_methodParameterTypesCache.get(m4);
            if (result2 == null) {
                result2 = m4.getParameterTypes();
                _methodParameterTypesCache.put(m4, result2);
            }
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class[] findParameterTypes(Class type2, Method m4) {
        ParameterizedType genericSuperclass;
        Type[] genTypes = m4.getGenericParameterTypes();
        Object[] types = new Class[genTypes.length];
        boolean noGenericParameter = true;
        for (int i2 = 0; i2 < genTypes.length; ++i2) {
            if (!Class.class.isInstance(genTypes[i2])) {
                noGenericParameter = false;
                break;
            }
            types[i2] = (Class)genTypes[i2];
        }
        if (noGenericParameter) {
            return types;
        }
        if (type2 == null) {
            return OgnlRuntime.getParameterTypes(m4);
        }
        Type typeGenericSuperclass = type2.getGenericSuperclass();
        if (typeGenericSuperclass == null || !ParameterizedType.class.isInstance(typeGenericSuperclass) || m4.getDeclaringClass().getTypeParameters() == null) {
            return OgnlRuntime.getParameterTypes(m4);
        }
        types = (Class[])_genericMethodParameterTypesCache.get(m4);
        if (types != null && Arrays.equals(types, (genericSuperclass = (ParameterizedType)typeGenericSuperclass).getActualTypeArguments())) {
            return types;
        }
        ParameterizedType param = (ParameterizedType)typeGenericSuperclass;
        TypeVariable[] declaredTypes = m4.getDeclaringClass().getTypeParameters();
        types = new Class[genTypes.length];
        for (int i3 = 0; i3 < genTypes.length; ++i3) {
            TypeVariable paramType = null;
            if (TypeVariable.class.isInstance(genTypes[i3])) {
                paramType = (TypeVariable)genTypes[i3];
            } else if (GenericArrayType.class.isInstance(genTypes[i3])) {
                paramType = (TypeVariable)((GenericArrayType)genTypes[i3]).getGenericComponentType();
            } else {
                if (ParameterizedType.class.isInstance(genTypes[i3])) {
                    types[i3] = (Class)((ParameterizedType)genTypes[i3]).getRawType();
                    continue;
                }
                if (Class.class.isInstance(genTypes[i3])) {
                    types[i3] = (Class)genTypes[i3];
                    continue;
                }
            }
            Class<?> resolved2 = OgnlRuntime.resolveType(param, paramType, declaredTypes);
            if (resolved2 != null) {
                if (GenericArrayType.class.isInstance(genTypes[i3])) {
                    resolved2 = Array.newInstance(resolved2, 0).getClass();
                }
                types[i3] = resolved2;
                continue;
            }
            types[i3] = m4.getParameterTypes()[i3];
        }
        Map map2 = _genericMethodParameterTypesCache;
        synchronized (map2) {
            _genericMethodParameterTypesCache.put(m4, types);
        }
        return types;
    }

    static Class resolveType(ParameterizedType param, TypeVariable var, TypeVariable[] declaredTypes) {
        if (param.getActualTypeArguments().length < 1) {
            return null;
        }
        for (int i2 = 0; i2 < declaredTypes.length; ++i2) {
            if (TypeVariable.class.isInstance(param.getActualTypeArguments()[i2]) || !declaredTypes[i2].getName().equals(var.getName())) continue;
            return (Class)param.getActualTypeArguments()[i2];
        }
        return null;
    }

    static Class findType(Type[] types, Class type2) {
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (!Class.class.isInstance(types[i2]) || !type2.isAssignableFrom((Class)types[i2])) continue;
            return (Class)types[i2];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class[] getParameterTypes(Constructor c2) {
        Class[] result2 = (Class[])_ctorParameterTypesCache.get(c2);
        if (result2 == null) {
            Map map2 = _ctorParameterTypesCache;
            synchronized (map2) {
                result2 = (Class[])_ctorParameterTypesCache.get(c2);
                if (result2 == null) {
                    result2 = c2.getParameterTypes();
                    _ctorParameterTypesCache.put(c2, result2);
                }
            }
        }
        return result2;
    }

    public static SecurityManager getSecurityManager() {
        return _securityManager;
    }

    public static void setSecurityManager(SecurityManager value2) {
        _securityManager = value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Permission getPermission(Method method2) {
        Permission result2;
        Class<?> mc = method2.getDeclaringClass();
        ClassCache classCache = _invokePermissionCache;
        synchronized (classCache) {
            HashMap<String, Permission> permissions = (HashMap<String, Permission>)_invokePermissionCache.get(mc);
            if (permissions == null) {
                permissions = new HashMap<String, Permission>(101);
                _invokePermissionCache.put(mc, permissions);
            }
            if ((result2 = (Permission)permissions.get(method2.getName())) == null) {
                result2 = new OgnlInvokePermission("invoke." + mc.getName() + "." + method2.getName());
                permissions.put(method2.getName(), result2);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeMethod(Object target, Method method2, Object[] argsArray) throws InvocationTargetException, IllegalAccessException {
        Object result2;
        boolean checkPermission;
        boolean syncInvoke;
        GenericDeclaration methodDeclaringClass;
        if (_useStricterInvocation) {
            methodDeclaringClass = method2.getDeclaringClass();
            if (AO_SETACCESSIBLE_REF != null && AO_SETACCESSIBLE_REF.equals(method2) || AO_SETACCESSIBLE_ARR_REF != null && AO_SETACCESSIBLE_ARR_REF.equals(method2) || SYS_EXIT_REF != null && SYS_EXIT_REF.equals(method2) || SYS_CONSOLE_REF != null && SYS_CONSOLE_REF.equals(method2) || AccessibleObjectHandler.class.isAssignableFrom((Class<?>)methodDeclaringClass) || ClassResolver.class.isAssignableFrom((Class<?>)methodDeclaringClass) || MethodAccessor.class.isAssignableFrom((Class<?>)methodDeclaringClass) || MemberAccess.class.isAssignableFrom((Class<?>)methodDeclaringClass) || OgnlContext.class.isAssignableFrom((Class<?>)methodDeclaringClass) || Runtime.class.isAssignableFrom((Class<?>)methodDeclaringClass) || ClassLoader.class.isAssignableFrom((Class<?>)methodDeclaringClass) || ProcessBuilder.class.isAssignableFrom((Class<?>)methodDeclaringClass) || AccessibleObjectHandlerJDK9Plus.unsafeOrDescendant(methodDeclaringClass)) {
                throw new IllegalAccessException("Method [" + method2 + "] cannot be called from within OGNL invokeMethod() under stricter invocation mode.");
            }
        }
        methodDeclaringClass = method2;
        synchronized (methodDeclaringClass) {
            Boolean methodAccessCacheValue = _methodAccessCache.get(method2);
            if (methodAccessCacheValue == null) {
                if (!Modifier.isPublic(method2.getModifiers()) || !Modifier.isPublic(method2.getDeclaringClass().getModifiers())) {
                    if (!method2.isAccessible()) {
                        methodAccessCacheValue = Boolean.TRUE;
                        _methodAccessCache.put(method2, methodAccessCacheValue);
                    } else {
                        methodAccessCacheValue = Boolean.FALSE;
                        _methodAccessCache.put(method2, methodAccessCacheValue);
                    }
                } else {
                    methodAccessCacheValue = Boolean.FALSE;
                    _methodAccessCache.put(method2, methodAccessCacheValue);
                }
            }
            syncInvoke = Boolean.TRUE.equals(methodAccessCacheValue);
            Boolean methodPermCacheValue = _methodPermCache.get(method2);
            if (methodPermCacheValue == null) {
                if (_securityManager != null) {
                    try {
                        _securityManager.checkPermission(OgnlRuntime.getPermission(method2));
                        methodPermCacheValue = Boolean.TRUE;
                        _methodPermCache.put(method2, methodPermCacheValue);
                    }
                    catch (SecurityException ex) {
                        methodPermCacheValue = Boolean.FALSE;
                        _methodPermCache.put(method2, methodPermCacheValue);
                        throw new IllegalAccessException("Method [" + method2 + "] cannot be accessed.");
                    }
                } else {
                    methodPermCacheValue = Boolean.TRUE;
                    _methodPermCache.put(method2, methodPermCacheValue);
                }
            }
            checkPermission = Boolean.FALSE.equals(methodPermCacheValue);
        }
        if (syncInvoke) {
            Method ex = method2;
            synchronized (ex) {
                if (checkPermission) {
                    try {
                        _securityManager.checkPermission(OgnlRuntime.getPermission(method2));
                    }
                    catch (SecurityException ex2) {
                        throw new IllegalAccessException("Method [" + method2 + "] cannot be accessed.");
                    }
                }
                _accessibleObjectHandler.setAccessible(method2, true);
                try {
                    result2 = OgnlRuntime.invokeMethodInsideSandbox(target, method2, argsArray);
                }
                finally {
                    _accessibleObjectHandler.setAccessible(method2, false);
                }
            }
        }
        if (checkPermission) {
            try {
                _securityManager.checkPermission(OgnlRuntime.getPermission(method2));
            }
            catch (SecurityException ex) {
                throw new IllegalAccessException("Method [" + method2 + "] cannot be accessed.");
            }
        }
        result2 = OgnlRuntime.invokeMethodInsideSandbox(target, method2, argsArray);
        return result2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object invokeMethodInsideSandbox(Object target, Method method2, Object[] argsArray) throws InvocationTargetException, IllegalAccessException {
        Object e22;
        void token2;
        if (_disableOgnlSecurityManagerOnInit) {
            return method2.invoke(target, argsArray);
        }
        try {
            if (System.getProperty(OGNL_SECURITY_MANAGER) == null) {
                return method2.invoke(target, argsArray);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (ClassLoader.class.isAssignableFrom(method2.getDeclaringClass())) {
            throw new IllegalAccessException("OGNL direct access to class loader denied!");
        }
        UserMethod userMethod = new UserMethod(target, method2, argsArray);
        Permissions p = new Permissions();
        ProtectionDomain pd = new ProtectionDomain(null, p);
        AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{pd});
        Object ognlSecurityManager = OgnlSecurityManagerFactory.getOgnlSecurityManager();
        try {
            Long token22 = (Long)ognlSecurityManager.getClass().getMethod("enter", new Class[0]).invoke(ognlSecurityManager, new Object[0]);
        }
        catch (NoSuchMethodException e22) {
            throw new InvocationTargetException(e22);
        }
        if (token2 == null) {
            return method2.invoke(target, argsArray);
        }
        try {
            e22 = AccessController.doPrivileged(userMethod, acc);
        }
        catch (PrivilegedActionException e22) {
            try {
                if (!(e22.getException() instanceof InvocationTargetException)) throw new InvocationTargetException(e22);
                throw (InvocationTargetException)e22.getException();
            }
            catch (Throwable throwable) {
                try {
                    ognlSecurityManager.getClass().getMethod("leave", Long.TYPE).invoke(ognlSecurityManager, token2);
                    throw throwable;
                }
                catch (NoSuchMethodException e4) {
                    throw new InvocationTargetException(e4);
                }
            }
        }
        try {
            ognlSecurityManager.getClass().getMethod("leave", Long.TYPE).invoke(ognlSecurityManager, token2);
            return e22;
        }
        catch (NoSuchMethodException e3) {
            throw new InvocationTargetException(e3);
        }
    }

    public static final Class getArgClass(Object arg) {
        if (arg == null) {
            return null;
        }
        Class<?> c2 = arg.getClass();
        if (c2 == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c2.getSuperclass() == Number.class) {
            if (c2 == Integer.class) {
                return Integer.TYPE;
            }
            if (c2 == Double.class) {
                return Double.TYPE;
            }
            if (c2 == Byte.class) {
                return Byte.TYPE;
            }
            if (c2 == Long.class) {
                return Long.TYPE;
            }
            if (c2 == Float.class) {
                return Float.TYPE;
            }
            if (c2 == Short.class) {
                return Short.TYPE;
            }
        } else if (c2 == Character.class) {
            return Character.TYPE;
        }
        return c2;
    }

    public static Class[] getArgClasses(Object[] args2) {
        if (args2 == null) {
            return null;
        }
        Class[] argClasses = new Class[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            argClasses[i2] = OgnlRuntime.getArgClass(args2[i2]);
        }
        return argClasses;
    }

    public static final boolean isTypeCompatible(Object object, Class c2) {
        if (object == null) {
            return true;
        }
        ArgsCompatbilityReport report = new ArgsCompatbilityReport(0, new boolean[1]);
        if (!OgnlRuntime.isTypeCompatible(OgnlRuntime.getArgClass(object), c2, 0, report)) {
            return false;
        }
        return !report.conversionNeeded[0];
    }

    public static final boolean isTypeCompatible(Class parameterClass, Class methodArgumentClass, int index, ArgsCompatbilityReport report) {
        if (parameterClass == null) {
            report.score += 500;
            return true;
        }
        if (parameterClass == methodArgumentClass) {
            return true;
        }
        if (methodArgumentClass.isArray()) {
            if (parameterClass.isArray()) {
                Class<?> pct = parameterClass.getComponentType();
                Class<?> mct = methodArgumentClass.getComponentType();
                if (mct.isAssignableFrom(pct)) {
                    report.score += 25;
                    return true;
                }
            }
            if (Collection.class.isAssignableFrom(parameterClass)) {
                Class<?> mct = methodArgumentClass.getComponentType();
                if (mct == Object.class) {
                    report.conversionNeeded[index] = true;
                    report.score += 30;
                    return true;
                }
                return false;
            }
        } else if (Collection.class.isAssignableFrom(methodArgumentClass)) {
            if (parameterClass.isArray()) {
                report.conversionNeeded[index] = true;
                report.score += 50;
                return true;
            }
            if (Collection.class.isAssignableFrom(parameterClass)) {
                if (methodArgumentClass.isAssignableFrom(parameterClass)) {
                    report.score += 2;
                    return true;
                }
                report.conversionNeeded[index] = true;
                report.score += 50;
                return true;
            }
        }
        if (methodArgumentClass.isAssignableFrom(parameterClass)) {
            report.score += 40;
            return true;
        }
        if (parameterClass.isPrimitive()) {
            Class ptc = (Class)PRIMITIVE_WRAPPER_CLASSES.get(parameterClass);
            if (methodArgumentClass == ptc) {
                report.score += 2;
                return true;
            }
            if (methodArgumentClass.isAssignableFrom(ptc)) {
                report.score += 10;
                return true;
            }
        }
        return false;
    }

    public static boolean areArgsCompatible(Object[] args2, Class[] classes) {
        ArgsCompatbilityReport report = OgnlRuntime.areArgsCompatible(OgnlRuntime.getArgClasses(args2), classes, null);
        if (report == null) {
            return false;
        }
        for (boolean conversionNeeded : report.conversionNeeded) {
            if (!conversionNeeded) continue;
            return false;
        }
        return true;
    }

    public static ArgsCompatbilityReport areArgsCompatible(Class[] args2, Class[] classes, Method m4) {
        boolean varArgs;
        boolean bl = varArgs = m4 != null && m4.isVarArgs();
        if (args2 == null || args2.length == 0) {
            if (classes == null || classes.length == 0) {
                return NoArgsReport;
            }
            if (varArgs) {
                return NoArgsReport;
            }
            return null;
        }
        if (args2.length != classes.length && !varArgs) {
            return null;
        }
        if (varArgs) {
            ArgsCompatbilityReport report = new ArgsCompatbilityReport(1000, new boolean[args2.length]);
            if (classes.length - 1 > args2.length) {
                return null;
            }
            int count2 = classes.length - 1;
            for (int index = 0; index < count2; ++index) {
                if (OgnlRuntime.isTypeCompatible(args2[index], classes[index], index, report)) continue;
                return null;
            }
            Class<?> varArgsType = classes[classes.length - 1].getComponentType();
            int count3 = args2.length;
            for (int index = classes.length - 1; index < count3; ++index) {
                if (OgnlRuntime.isTypeCompatible(args2[index], varArgsType, index, report)) continue;
                return null;
            }
            return report;
        }
        ArgsCompatbilityReport report = new ArgsCompatbilityReport(0, new boolean[args2.length]);
        int count4 = args2.length;
        for (int index = 0; index < count4; ++index) {
            if (OgnlRuntime.isTypeCompatible(args2[index], classes[index], index, report)) continue;
            return null;
        }
        return report;
    }

    public static final boolean isMoreSpecific(Class[] classes1, Class[] classes2) {
        int count2 = classes1.length;
        for (int index = 0; index < count2; ++index) {
            Class c1 = classes1[index];
            Class c2 = classes2[index];
            if (c1 == c2) continue;
            if (c1.isPrimitive()) {
                return true;
            }
            if (c1.isAssignableFrom(c2)) {
                return false;
            }
            if (!c2.isAssignableFrom(c1)) continue;
            return true;
        }
        return false;
    }

    public static String getModifierString(int modifiers) {
        String result2 = Modifier.isPublic(modifiers) ? "public" : (Modifier.isProtected(modifiers) ? "protected" : (Modifier.isPrivate(modifiers) ? "private" : ""));
        if (Modifier.isStatic(modifiers)) {
            result2 = "static " + result2;
        }
        if (Modifier.isFinal(modifiers)) {
            result2 = "final " + result2;
        }
        if (Modifier.isNative(modifiers)) {
            result2 = "native " + result2;
        }
        if (Modifier.isSynchronized(modifiers)) {
            result2 = "synchronized " + result2;
        }
        if (Modifier.isTransient(modifiers)) {
            result2 = "transient " + result2;
        }
        return result2;
    }

    public static Class classForName(OgnlContext context, String className) throws ClassNotFoundException {
        Class result2 = (Class)_primitiveTypes.get(className);
        if (result2 == null) {
            ClassResolver resolver;
            if (context == null || (resolver = context.getClassResolver()) == null) {
                resolver = new DefaultClassResolver();
            }
            result2 = resolver.classForName(className, context);
        }
        if (result2 == null) {
            throw new ClassNotFoundException("Unable to resolve class: " + className);
        }
        return result2;
    }

    public static boolean isInstance(OgnlContext context, Object value2, String className) throws OgnlException {
        try {
            Class c2 = OgnlRuntime.classForName(context, className);
            return c2.isInstance(value2);
        }
        catch (ClassNotFoundException e2) {
            throw new OgnlException("No such class: " + className, e2);
        }
    }

    public static Object getPrimitiveDefaultValue(Class forClass) {
        return _primitiveDefaults.get(forClass);
    }

    public static Object getNumericDefaultValue(Class forClass) {
        return NUMERIC_DEFAULTS.get(forClass);
    }

    public static Object getConvertedType(OgnlContext context, Object target, Member member, String propertyName, Object value2, Class type2) {
        return context.getTypeConverter().convertValue(context, target, member, propertyName, value2, type2);
    }

    public static boolean getConvertedTypes(OgnlContext context, Object target, Member member, String propertyName, Class[] parameterTypes, Object[] args2, Object[] newArgs) {
        boolean result2 = false;
        if (parameterTypes.length == args2.length) {
            result2 = true;
            int ilast = parameterTypes.length - 1;
            for (int i2 = 0; result2 && i2 <= ilast; ++i2) {
                Object arg = args2[i2];
                Class type2 = parameterTypes[i2];
                if (OgnlRuntime.isTypeCompatible(arg, type2)) {
                    newArgs[i2] = arg;
                    continue;
                }
                Object v = OgnlRuntime.getConvertedType(context, target, member, propertyName, arg, type2);
                if (v == NoConversionPossible) {
                    result2 = false;
                    continue;
                }
                newArgs[i2] = v;
            }
        }
        return result2;
    }

    public static Constructor getConvertedConstructorAndArgs(OgnlContext context, Object target, List constructors2, Object[] args2, Object[] newArgs) {
        Constructor result2 = null;
        TypeConverter converter = context.getTypeConverter();
        if (converter != null && constructors2 != null) {
            int icount = constructors2.size();
            for (int i2 = 0; result2 == null && i2 < icount; ++i2) {
                Class[] parameterTypes;
                Constructor ctor = (Constructor)constructors2.get(i2);
                if (!OgnlRuntime.getConvertedTypes(context, target, ctor, null, parameterTypes = OgnlRuntime.getParameterTypes(ctor), args2, newArgs)) continue;
                result2 = ctor;
            }
        }
        return result2;
    }

    public static Method getAppropriateMethod(OgnlContext context, Object source2, Object target, String propertyName, String methodName, List methods2, Object[] args2, Object[] actualArgs) {
        Method result2 = null;
        if (methods2 != null) {
            Class[] argClasses;
            MatchingMethod mm4;
            Class typeClass;
            Class clazz = typeClass = target != null ? target.getClass() : null;
            if (typeClass == null && source2 != null && Class.class.isInstance(source2)) {
                typeClass = (Class)source2;
            }
            if ((mm4 = OgnlRuntime.findBestMethod(methods2, typeClass, methodName, argClasses = OgnlRuntime.getArgClasses(args2))) != null) {
                result2 = mm4.mMethod;
                Class[] mParameterTypes = mm4.mParameterTypes;
                System.arraycopy(args2, 0, actualArgs, 0, args2.length);
                if (actualArgs.length > 0) {
                    for (int j2 = 0; j2 < mParameterTypes.length; ++j2) {
                        Class type2 = mParameterTypes[j2];
                        if (!mm4.report.conversionNeeded[j2] && (!type2.isPrimitive() || actualArgs[j2] != null)) continue;
                        actualArgs[j2] = OgnlRuntime.getConvertedType(context, source2, result2, propertyName, args2[j2], type2);
                    }
                }
            }
        }
        if (result2 == null) {
            result2 = OgnlRuntime.getConvertedMethodAndArgs(context, target, propertyName, methods2, args2, actualArgs);
        }
        return result2;
    }

    public static Method getConvertedMethodAndArgs(OgnlContext context, Object target, String propertyName, List methods2, Object[] args2, Object[] newArgs) {
        Method result2 = null;
        TypeConverter converter = context.getTypeConverter();
        if (converter != null && methods2 != null) {
            int icount = methods2.size();
            for (int i2 = 0; result2 == null && i2 < icount; ++i2) {
                Class[] parameterTypes;
                Method m4 = (Method)methods2.get(i2);
                if (!OgnlRuntime.getConvertedTypes(context, target, m4, propertyName, parameterTypes = OgnlRuntime.findParameterTypes(target != null ? target.getClass() : null, m4), args2, newArgs)) continue;
                result2 = m4;
            }
        }
        return result2;
    }

    private static MatchingMethod findBestMethod(List methods2, Class typeClass, String name, Class[] argClasses) {
        MatchingMethod mm4 = null;
        IllegalArgumentException failure = null;
        int icount = methods2.size();
        for (int i2 = 0; i2 < icount; ++i2) {
            Method m4 = (Method)methods2.get(i2);
            Class[] mParameterTypes = OgnlRuntime.findParameterTypes(typeClass, m4);
            ArgsCompatbilityReport report = OgnlRuntime.areArgsCompatible(argClasses, mParameterTypes, m4);
            if (report == null) continue;
            String methodName = m4.getName();
            int score = report.score;
            if (!name.equals(methodName)) {
                score = name.equalsIgnoreCase(methodName) ? (score += 200) : (methodName.toLowerCase().endsWith(name.toLowerCase()) ? (score += 500) : (score += 5000));
            }
            if (mm4 == null || mm4.score > score) {
                mm4 = new MatchingMethod(m4, score, report, mParameterTypes);
                failure = null;
                continue;
            }
            if (mm4.score != score) continue;
            if (Arrays.equals(mm4.mMethod.getParameterTypes(), m4.getParameterTypes()) && mm4.mMethod.getName().equals(m4.getName())) {
                if (Modifier.isPublic(mm4.mMethod.getDeclaringClass().getModifiers()) || !Modifier.isPublic(m4.getDeclaringClass().getModifiers())) continue;
                mm4 = new MatchingMethod(m4, score, report, mParameterTypes);
                failure = null;
                continue;
            }
            if (m4.isVarArgs() || mm4.mMethod.isVarArgs()) {
                if (m4.isVarArgs() && !mm4.mMethod.isVarArgs()) continue;
                if (!m4.isVarArgs() && mm4.mMethod.isVarArgs()) {
                    mm4 = new MatchingMethod(m4, score, report, mParameterTypes);
                    failure = null;
                    continue;
                }
                System.err.println("Two vararg methods with same score(" + score + "): \"" + mm4.mMethod + "\" and \"" + m4 + "\" please report!");
                continue;
            }
            int scoreCurr = 0;
            int scoreOther = 0;
            for (int j2 = 0; j2 < argClasses.length; ++j2) {
                Class argClass = argClasses[j2];
                Class mcClass = mm4.mParameterTypes[j2];
                Class moClass = mParameterTypes[j2];
                if (argClass == null) {
                    if (mcClass == moClass) continue;
                    if (mcClass.isAssignableFrom(moClass)) {
                        scoreOther += 1000;
                        continue;
                    }
                    if (moClass.isAssignableFrom(moClass)) {
                        scoreCurr += 1000;
                        continue;
                    }
                    failure = new IllegalArgumentException("Can't decide wich method to use: \"" + mm4.mMethod + "\" or \"" + m4 + "\"");
                    continue;
                }
                if (mcClass == moClass) continue;
                if (mcClass == argClass) {
                    scoreOther += 100;
                    continue;
                }
                if (moClass == argClass) {
                    scoreCurr += 100;
                    continue;
                }
                if (mcClass.isAssignableFrom(moClass)) {
                    scoreOther += 50;
                    continue;
                }
                if (moClass.isAssignableFrom(moClass)) {
                    scoreCurr += 50;
                    continue;
                }
                failure = new IllegalArgumentException("Can't decide wich method to use: \"" + mm4.mMethod + "\" or \"" + m4 + "\"");
            }
            if (scoreCurr == scoreOther) {
                boolean otherIsAbstract;
                boolean currentIsAbstract;
                if (failure != null || (currentIsAbstract = Modifier.isAbstract(mm4.mMethod.getModifiers())) ^ (otherIsAbstract = Modifier.isAbstract(m4.getModifiers()))) continue;
                System.err.println("Two methods with same score(" + score + "): \"" + mm4.mMethod + "\" and \"" + m4 + "\" please report!");
                continue;
            }
            if (scoreCurr <= scoreOther) continue;
            mm4 = new MatchingMethod(m4, score, report, mParameterTypes);
            failure = null;
        }
        if (failure != null) {
            throw failure;
        }
        return mm4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callAppropriateMethod(OgnlContext context, Object source2, Object target, String methodName, String propertyName, List methods2, Object[] args2) throws MethodFailedException {
        Throwable reason = null;
        Object[] actualArgs = _objectArrayPool.create(args2.length);
        try {
            Method method2 = OgnlRuntime.getAppropriateMethod(context, source2, target, propertyName, methodName, methods2, args2, actualArgs);
            if (method2 == null || !OgnlRuntime.isMethodAccessible(context, source2, method2, propertyName)) {
                StringBuffer buffer = new StringBuffer();
                String className = "";
                if (target != null) {
                    className = target.getClass().getName() + ".";
                }
                int ilast = args2.length - 1;
                for (int i2 = 0; i2 <= ilast; ++i2) {
                    Object arg = args2[i2];
                    buffer.append(arg == null ? NULL_STRING : arg.getClass().getName());
                    if (i2 >= ilast) continue;
                    buffer.append(", ");
                }
                throw new NoSuchMethodException(className + methodName + "(" + buffer + ")");
            }
            Object[] convertedArgs = actualArgs;
            if (method2.isVarArgs()) {
                Class<?>[] parmTypes = method2.getParameterTypes();
                for (int i3 = 0; i3 < parmTypes.length; ++i3) {
                    Object[] varArgs;
                    if (!parmTypes[i3].isArray()) continue;
                    convertedArgs = new Object[i3 + 1];
                    if (actualArgs.length > 0) {
                        System.arraycopy(actualArgs, 0, convertedArgs, 0, convertedArgs.length);
                    }
                    if (actualArgs.length > i3) {
                        ArrayList<Object> varArgsList = new ArrayList<Object>();
                        for (int j2 = i3; j2 < actualArgs.length; ++j2) {
                            if (actualArgs[j2] == null) continue;
                            varArgsList.add(actualArgs[j2]);
                        }
                        varArgs = actualArgs.length == 1 ? (Object[])Array.newInstance(args2[0].getClass(), 1) : (Object[])Array.newInstance(parmTypes[i3].getComponentType(), varArgsList.size());
                        System.arraycopy(varArgsList.toArray(), 0, varArgs, 0, varArgs.length);
                    } else {
                        varArgs = new Object[]{};
                    }
                    if (actualArgs.length == 1 && args2[0].getClass().isArray()) {
                        convertedArgs = varArgs;
                        break;
                    }
                    convertedArgs[i3] = varArgs;
                    break;
                }
            }
            Object object = OgnlRuntime.invokeMethod(target, method2, convertedArgs);
            return object;
        }
        catch (NoSuchMethodException e2) {
            reason = e2;
        }
        catch (IllegalAccessException e3) {
            reason = e3;
        }
        catch (InvocationTargetException e4) {
            reason = e4.getTargetException();
        }
        finally {
            _objectArrayPool.recycle(actualArgs);
        }
        throw new MethodFailedException(source2, methodName, reason);
    }

    public static Object callStaticMethod(OgnlContext context, String className, String methodName, Object[] args2) throws OgnlException {
        try {
            Class targetClass = OgnlRuntime.classForName(context, className);
            if (targetClass == null) {
                throw new ClassNotFoundException("Unable to resolve class with name " + className);
            }
            MethodAccessor ma = OgnlRuntime.getMethodAccessor(targetClass);
            return ma.callStaticMethod(context, targetClass, methodName, args2);
        }
        catch (ClassNotFoundException ex) {
            throw new MethodFailedException(className, methodName, ex);
        }
    }

    public static Object callMethod(OgnlContext context, Object target, String methodName, String propertyName, Object[] args2) throws OgnlException {
        return OgnlRuntime.callMethod(context, target, methodName == null ? propertyName : methodName, args2);
    }

    public static Object callMethod(OgnlContext context, Object target, String methodName, Object[] args2) throws OgnlException {
        if (target == null) {
            throw new NullPointerException("target is null for method " + methodName);
        }
        return OgnlRuntime.getMethodAccessor(target.getClass()).callMethod(context, target, methodName, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callConstructor(OgnlContext context, String className, Object[] args2) throws OgnlException {
        Throwable reason = null;
        Object[] actualArgs = args2;
        try {
            Constructor ctor = null;
            Class[] ctorParameterTypes = null;
            Class target = OgnlRuntime.classForName(context, className);
            List constructors2 = OgnlRuntime.getConstructors(target);
            int icount = constructors2.size();
            for (int i2 = 0; i2 < icount; ++i2) {
                Constructor c2 = (Constructor)constructors2.get(i2);
                Class[] cParameterTypes = OgnlRuntime.getParameterTypes(c2);
                if (!OgnlRuntime.areArgsCompatible(args2, cParameterTypes) || ctor != null && !OgnlRuntime.isMoreSpecific(cParameterTypes, ctorParameterTypes)) continue;
                ctor = c2;
                ctorParameterTypes = cParameterTypes;
            }
            if (ctor == null && (ctor = OgnlRuntime.getConvertedConstructorAndArgs(context, target, constructors2, args2, actualArgs = _objectArrayPool.create(args2.length))) == null) {
                throw new NoSuchMethodException();
            }
            if (!context.getMemberAccess().isAccessible(context, target, ctor, null)) {
                throw new IllegalAccessException("access denied to " + target.getName() + "()");
            }
            Object t2 = ctor.newInstance(actualArgs);
            return t2;
        }
        catch (ClassNotFoundException e2) {
            reason = e2;
        }
        catch (NoSuchMethodException e3) {
            reason = e3;
        }
        catch (IllegalAccessException e4) {
            reason = e4;
        }
        catch (InvocationTargetException e5) {
            reason = e5.getTargetException();
        }
        catch (InstantiationException e6) {
            reason = e6;
        }
        finally {
            if (actualArgs != args2) {
                _objectArrayPool.recycle(actualArgs);
            }
        }
        throw new MethodFailedException(className, "new", reason);
    }

    @Deprecated
    public static final Object getMethodValue(OgnlContext context, Object target, String propertyName) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        return OgnlRuntime.getMethodValue(context, target, propertyName, false);
    }

    public static final Object getMethodValue(OgnlContext context, Object target, String propertyName, boolean checkAccessAndExistence) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        Object result2 = null;
        Method m4 = OgnlRuntime.getGetMethod(context, target == null ? null : target.getClass(), propertyName);
        if (m4 == null) {
            m4 = OgnlRuntime.getReadMethod(target == null ? null : target.getClass(), propertyName, null);
        }
        if (checkAccessAndExistence && (m4 == null || !context.getMemberAccess().isAccessible(context, target, m4, propertyName))) {
            result2 = NotFound;
        }
        if (result2 == null) {
            if (m4 != null) {
                try {
                    result2 = OgnlRuntime.invokeMethod(target, m4, NoArguments);
                }
                catch (InvocationTargetException ex) {
                    throw new OgnlException(propertyName, ex.getTargetException());
                }
            } else {
                throw new NoSuchMethodException(propertyName);
            }
        }
        return result2;
    }

    @Deprecated
    public static boolean setMethodValue(OgnlContext context, Object target, String propertyName, Object value2) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        return OgnlRuntime.setMethodValue(context, target, propertyName, value2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMethodValue(OgnlContext context, Object target, String propertyName, Object value2, boolean checkAccessAndExistence) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        boolean result2 = true;
        Method m4 = OgnlRuntime.getSetMethod(context, target == null ? null : target.getClass(), propertyName);
        if (checkAccessAndExistence && (m4 == null || !context.getMemberAccess().isAccessible(context, target, m4, propertyName))) {
            result2 = false;
        }
        if (result2) {
            if (m4 != null) {
                Object[] args2 = _objectArrayPool.create(value2);
                try {
                    OgnlRuntime.callAppropriateMethod(context, target, target, m4.getName(), propertyName, Collections.nCopies(1, m4), args2);
                }
                finally {
                    _objectArrayPool.recycle(args2);
                }
            } else {
                result2 = false;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getConstructors(Class targetClass) {
        List<Constructor<?>> result2 = (List<Constructor<?>>)_constructorCache.get(targetClass);
        if (result2 == null) {
            ClassCache classCache = _constructorCache;
            synchronized (classCache) {
                result2 = (List)_constructorCache.get(targetClass);
                if (result2 == null) {
                    result2 = Arrays.asList(targetClass.getConstructors());
                    _constructorCache.put(targetClass, result2);
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getMethods(Class targetClass, boolean staticMethods) {
        ClassCache cache2 = staticMethods ? _staticMethodCache : _instanceMethodCache;
        HashMap result2 = (HashMap)cache2.get(targetClass);
        if (result2 == null) {
            ClassCache classCache = cache2;
            synchronized (classCache) {
                result2 = (Map)cache2.get(targetClass);
                if (result2 == null) {
                    result2 = new HashMap(23);
                    OgnlRuntime.collectMethods(targetClass, result2, staticMethods);
                    cache2.put(targetClass, result2);
                }
            }
        }
        return result2;
    }

    private static void collectMethods(Class c2, Map result2, boolean staticMethods) {
        Method[] ma;
        try {
            ma = c2.getDeclaredMethods();
        }
        catch (SecurityException ignored) {
            ma = c2.getMethods();
        }
        int icount = ma.length;
        for (int i2 = 0; i2 < icount; ++i2) {
            if (!OgnlRuntime.isMethodCallable_BridgeOrNonSynthetic(ma[i2]) || Modifier.isStatic(ma[i2].getModifiers()) != staticMethods) continue;
            OgnlRuntime.addMethodToResult(result2, ma[i2]);
        }
        Class superclass = c2.getSuperclass();
        if (superclass != null) {
            OgnlRuntime.collectMethods(superclass, result2, staticMethods);
        }
        for (Class<?> iface : c2.getInterfaces()) {
            OgnlRuntime.collectMethods(iface, result2, staticMethods);
        }
    }

    private static void addMethodToResult(Map result2, Method method2) {
        ArrayList<Method> ml = (ArrayList<Method>)result2.get(method2.getName());
        if (ml == null) {
            ml = new ArrayList<Method>();
            result2.put(method2.getName(), ml);
        }
        ml.add(method2);
    }

    private static boolean isDefaultMethod(Method method2) {
        return (method2.getModifiers() & 0x409) == 1 && method2.getDeclaringClass().isInterface();
    }

    private static boolean isNonDefaultPublicInterfaceMethod(Method method2) {
        return (method2.getModifiers() & 0x409) == 1025 && method2.getDeclaringClass().isInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getAllMethods(Class targetClass, boolean staticMethods) {
        ClassCache cache2 = staticMethods ? _staticMethodCache : _instanceMethodCache;
        HashMap<String, ArrayList<Method>> result2 = (HashMap<String, ArrayList<Method>>)cache2.get(targetClass);
        if (result2 == null) {
            ClassCache classCache = cache2;
            synchronized (classCache) {
                result2 = (Map)cache2.get(targetClass);
                if (result2 == null) {
                    result2 = new HashMap<String, ArrayList<Method>>(23);
                    for (Class c2 = targetClass; c2 != null; c2 = c2.getSuperclass()) {
                        Method[] ma = c2.getMethods();
                        int icount = ma.length;
                        for (int i2 = 0; i2 < icount; ++i2) {
                            if (!OgnlRuntime.isMethodCallable(ma[i2]) || Modifier.isStatic(ma[i2].getModifiers()) != staticMethods) continue;
                            ArrayList<Method> ml = (ArrayList<Method>)result2.get(ma[i2].getName());
                            if (ml == null) {
                                ml = new ArrayList<Method>();
                                result2.put(ma[i2].getName(), ml);
                            }
                            ml.add(ma[i2]);
                        }
                    }
                    cache2.put(targetClass, result2);
                }
            }
        }
        return result2;
    }

    public static List getMethods(Class targetClass, String name, boolean staticMethods) {
        return (List)OgnlRuntime.getMethods(targetClass, staticMethods).get(name);
    }

    public static List getAllMethods(Class targetClass, String name, boolean staticMethods) {
        return (List)OgnlRuntime.getAllMethods(targetClass, staticMethods).get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getFields(Class targetClass) {
        HashMap<String, Field> result2 = (HashMap<String, Field>)_fieldCache.get(targetClass);
        if (result2 == null) {
            ClassCache classCache = _fieldCache;
            synchronized (classCache) {
                result2 = (Map)_fieldCache.get(targetClass);
                if (result2 == null) {
                    Field[] fa;
                    result2 = new HashMap<String, Field>(23);
                    try {
                        fa = targetClass.getDeclaredFields();
                    }
                    catch (SecurityException ignored) {
                        fa = targetClass.getFields();
                    }
                    for (int i2 = 0; i2 < fa.length; ++i2) {
                        result2.put(fa[i2].getName(), fa[i2]);
                    }
                    _fieldCache.put(targetClass, result2);
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field getField(Class inClass, String name) {
        Field result2 = null;
        Object o = OgnlRuntime.getFields(inClass).get(name);
        if (o == null) {
            ClassCache classCache = _fieldCache;
            synchronized (classCache) {
                o = OgnlRuntime.getFields(inClass).get(name);
                if (o == null) {
                    _superclasses.clear();
                    for (Class sc = inClass; sc != null && (o = OgnlRuntime.getFields(sc).get(name)) != NotFound; sc = sc.getSuperclass()) {
                        _superclasses.add(sc);
                        result2 = (Field)o;
                        if (result2 != null) break;
                    }
                    int icount = _superclasses.size();
                    for (int i2 = 0; i2 < icount; ++i2) {
                        OgnlRuntime.getFields((Class)_superclasses.get(i2)).put(name, result2 == null ? NotFound : result2);
                    }
                } else if (o instanceof Field) {
                    result2 = (Field)o;
                } else if (result2 == NotFound) {
                    result2 = null;
                }
            }
        } else if (o instanceof Field) {
            result2 = (Field)o;
        } else if (result2 == NotFound) {
            result2 = null;
        }
        return result2;
    }

    @Deprecated
    public static Object getFieldValue(OgnlContext context, Object target, String propertyName) throws NoSuchFieldException {
        return OgnlRuntime.getFieldValue(context, target, propertyName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFieldValue(OgnlContext context, Object target, String propertyName, boolean checkAccessAndExistence) throws NoSuchFieldException {
        Object result2;
        block9: {
            result2 = null;
            Field f2 = OgnlRuntime.getField(target == null ? null : target.getClass(), propertyName);
            if (checkAccessAndExistence && (f2 == null || !context.getMemberAccess().isAccessible(context, target, f2, propertyName))) {
                result2 = NotFound;
            }
            if (result2 == null) {
                if (f2 == null) {
                    throw new NoSuchFieldException(propertyName);
                }
                try {
                    if (!Modifier.isStatic(f2.getModifiers())) {
                        Object state = context.getMemberAccess().setup(context, target, f2, propertyName);
                        try {
                            result2 = f2.get(target);
                            break block9;
                        }
                        finally {
                            context.getMemberAccess().restore(context, target, f2, propertyName, state);
                        }
                    }
                    throw new NoSuchFieldException(propertyName);
                }
                catch (IllegalAccessException ex) {
                    throw new NoSuchFieldException(propertyName);
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setFieldValue(OgnlContext context, Object target, String propertyName, Object value2) throws OgnlException {
        boolean result2;
        block6: {
            result2 = false;
            try {
                int fModifiers;
                Field f2 = OgnlRuntime.getField(target == null ? null : target.getClass(), propertyName);
                if (f2 == null || Modifier.isStatic(fModifiers = f2.getModifiers()) || Modifier.isFinal(fModifiers)) break block6;
                Object state = context.getMemberAccess().setup(context, target, f2, propertyName);
                try {
                    if (OgnlRuntime.isTypeCompatible(value2, f2.getType()) || (value2 = OgnlRuntime.getConvertedType(context, target, f2, propertyName, value2, f2.getType())) != null) {
                        f2.set(target, value2);
                        result2 = true;
                    }
                }
                finally {
                    context.getMemberAccess().restore(context, target, f2, propertyName, state);
                }
            }
            catch (IllegalAccessException ex) {
                throw new NoSuchPropertyException(target, propertyName, ex);
            }
        }
        return result2;
    }

    public static boolean isFieldAccessible(OgnlContext context, Object target, Class inClass, String propertyName) {
        return OgnlRuntime.isFieldAccessible(context, target, OgnlRuntime.getField(inClass, propertyName), propertyName);
    }

    public static boolean isFieldAccessible(OgnlContext context, Object target, Field field, String propertyName) {
        return context.getMemberAccess().isAccessible(context, target, field, propertyName);
    }

    public static boolean hasField(OgnlContext context, Object target, Class inClass, String propertyName) {
        Field f2 = OgnlRuntime.getField(inClass, propertyName);
        return f2 != null && OgnlRuntime.isFieldAccessible(context, target, f2, propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getStaticField(OgnlContext context, String className, String fieldName) throws OgnlException {
        Exception reason = null;
        try {
            Field f2;
            Class c2 = OgnlRuntime.classForName(context, className);
            if (c2 == null) {
                throw new OgnlException("Unable to find class " + className + " when resolving field name of " + fieldName);
            }
            if (fieldName.equals("class")) {
                return c2;
            }
            if (c2.isEnum()) {
                try {
                    return Enum.valueOf(c2, fieldName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((f2 = OgnlRuntime.getField(c2, fieldName)) == null) {
                throw new NoSuchFieldException(fieldName);
            }
            if (!Modifier.isStatic(f2.getModifiers())) {
                throw new OgnlException("Field " + fieldName + " of class " + className + " is not static");
            }
            Object result2 = null;
            if (context.getMemberAccess().isAccessible(context, null, f2, null)) {
                Object state = context.getMemberAccess().setup(context, null, f2, null);
                try {
                    result2 = f2.get(null);
                }
                finally {
                    context.getMemberAccess().restore(context, null, f2, null, state);
                }
            } else {
                throw new IllegalAccessException("Access to " + fieldName + " of class " + className + " is forbidden");
            }
            return result2;
        }
        catch (ClassNotFoundException e2) {
            reason = e2;
        }
        catch (NoSuchFieldException e3) {
            reason = e3;
        }
        catch (SecurityException e4) {
            reason = e4;
        }
        catch (IllegalAccessException e5) {
            reason = e5;
        }
        throw new OgnlException("Could not get static field " + fieldName + " from class " + className, reason);
    }

    private static String capitalizeBeanPropertyName(String propertyName) {
        if (propertyName.length() == 1) {
            return propertyName.toUpperCase();
        }
        if (propertyName.startsWith(GET_PREFIX) && propertyName.endsWith("()") && Character.isUpperCase(propertyName.substring(3, 4).charAt(0))) {
            return propertyName;
        }
        if (propertyName.startsWith(SET_PREFIX) && propertyName.endsWith(")") && Character.isUpperCase(propertyName.substring(3, 4).charAt(0))) {
            return propertyName;
        }
        if (propertyName.startsWith(IS_PREFIX) && propertyName.endsWith("()") && Character.isUpperCase(propertyName.substring(2, 3).charAt(0))) {
            return propertyName;
        }
        char first2 = propertyName.charAt(0);
        char second2 = propertyName.charAt(1);
        if (Character.isLowerCase(first2) && Character.isUpperCase(second2)) {
            return propertyName;
        }
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDeclaredMethods(Class targetClass, String propertyName, boolean findSets) {
        ArrayList result2 = null;
        ClassCache cache2 = _declaredMethods[findSets ? 0 : 1];
        HashMap propertyCache = (HashMap)cache2.get(targetClass);
        if (propertyCache == null || (result2 = (ArrayList)propertyCache.get(propertyName)) == null) {
            ClassCache classCache = cache2;
            synchronized (classCache) {
                propertyCache = (Map)cache2.get(targetClass);
                if (propertyCache == null || (result2 = (List)propertyCache.get(propertyName)) == null) {
                    String baseName = OgnlRuntime.capitalizeBeanPropertyName(propertyName);
                    result2 = new ArrayList();
                    OgnlRuntime.collectAccessors(targetClass, baseName, result2, findSets);
                    if (propertyCache == null) {
                        propertyCache = new HashMap(101);
                        cache2.put(targetClass, propertyCache);
                    }
                    propertyCache.put(propertyName, result2.isEmpty() ? NotFoundList : result2);
                    return result2.isEmpty() ? null : result2;
                }
            }
        }
        return result2 == NotFoundList ? null : result2;
    }

    private static void collectAccessors(Class c2, String baseName, List result2, boolean findSets) {
        Method[] methods2;
        try {
            methods2 = c2.getDeclaredMethods();
        }
        catch (SecurityException ignored) {
            methods2 = c2.getMethods();
        }
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            if (c2.isInterface()) {
                if (!OgnlRuntime.isDefaultMethod(methods2[i2]) && !OgnlRuntime.isNonDefaultPublicInterfaceMethod(methods2[i2])) continue;
                OgnlRuntime.addIfAccessor(result2, methods2[i2], baseName, findSets);
                continue;
            }
            if (!OgnlRuntime.isMethodCallable(methods2[i2])) continue;
            OgnlRuntime.addIfAccessor(result2, methods2[i2], baseName, findSets);
        }
        Class superclass = c2.getSuperclass();
        if (superclass != null) {
            OgnlRuntime.collectAccessors(superclass, baseName, result2, findSets);
        }
        for (Class<?> iface : c2.getInterfaces()) {
            OgnlRuntime.collectAccessors(iface, baseName, result2, findSets);
        }
    }

    private static void addIfAccessor(List result2, Method method2, String baseName, boolean findSets) {
        String ms = method2.getName();
        if (ms.endsWith(baseName)) {
            boolean isSet = false;
            boolean isIs = false;
            isSet = ms.startsWith(SET_PREFIX);
            if (isSet || ms.startsWith(GET_PREFIX) || (isIs = ms.startsWith(IS_PREFIX))) {
                int prefixLength;
                int n = prefixLength = isIs ? 2 : 3;
                if (isSet == findSets && baseName.length() == ms.length() - prefixLength) {
                    result2.add(method2);
                }
            }
        }
    }

    static boolean isMethodCallable(Method m4) {
        return !m4.isSynthetic() && !m4.isBridge();
    }

    static boolean isMethodCallable_BridgeOrNonSynthetic(Method m4) {
        return !m4.isSynthetic() || m4.isBridge();
    }

    public static Method getGetMethod(OgnlContext context, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        Method method2 = cacheGetMethod.get(targetClass, propertyName);
        if (method2 == ClassPropertyMethodCache.NULL_REPLACEMENT) {
            return null;
        }
        if (method2 != null) {
            return method2;
        }
        method2 = OgnlRuntime._getGetMethod(context, targetClass, propertyName);
        cacheGetMethod.put(targetClass, propertyName, method2);
        return method2;
    }

    private static Method _getGetMethod(OgnlContext context, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        Method result2 = null;
        List methods2 = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, false);
        if (methods2 != null) {
            Method firstGetter = null;
            Method firstPublicGetter = null;
            Method firstNonDefaultPublicInterfaceGetter = null;
            int icount = methods2.size();
            for (int i2 = 0; i2 < icount; ++i2) {
                Method m4 = (Method)methods2.get(i2);
                Class[] mParameterTypes = OgnlRuntime.findParameterTypes(targetClass, m4);
                if (mParameterTypes.length != 0) continue;
                boolean declaringClassIsPublic = Modifier.isPublic(m4.getDeclaringClass().getModifiers());
                if (firstGetter == null) {
                    firstGetter = m4;
                    if (_useFirstMatchGetSetLookup) break;
                }
                if (firstPublicGetter == null && Modifier.isPublic(m4.getModifiers()) && declaringClassIsPublic) {
                    firstPublicGetter = m4;
                    break;
                }
                if (firstNonDefaultPublicInterfaceGetter != null || !OgnlRuntime.isNonDefaultPublicInterfaceMethod(m4) || !declaringClassIsPublic) continue;
                firstNonDefaultPublicInterfaceGetter = m4;
            }
            result2 = firstPublicGetter != null ? firstPublicGetter : (firstNonDefaultPublicInterfaceGetter != null ? firstNonDefaultPublicInterfaceGetter : firstGetter);
        }
        return result2;
    }

    public static boolean isMethodAccessible(OgnlContext context, Object target, Method method2, String propertyName) {
        return method2 != null && context.getMemberAccess().isAccessible(context, target, method2, propertyName);
    }

    public static boolean hasGetMethod(OgnlContext context, Object target, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        return OgnlRuntime.isMethodAccessible(context, target, OgnlRuntime.getGetMethod(context, targetClass, propertyName), propertyName);
    }

    public static Method getSetMethod(OgnlContext context, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        Method method2 = cacheSetMethod.get(targetClass, propertyName);
        if (method2 == ClassPropertyMethodCache.NULL_REPLACEMENT) {
            return null;
        }
        if (method2 != null) {
            return method2;
        }
        method2 = OgnlRuntime._getSetMethod(context, targetClass, propertyName);
        cacheSetMethod.put(targetClass, propertyName, method2);
        return method2;
    }

    private static Method _getSetMethod(OgnlContext context, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        Method result2 = null;
        List methods2 = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, true);
        if (methods2 != null) {
            Method firstSetter = null;
            Method firstPublicSetter = null;
            Method firstNonDefaultPublicInterfaceSetter = null;
            int icount = methods2.size();
            for (int i2 = 0; i2 < icount; ++i2) {
                Method m4 = (Method)methods2.get(i2);
                Class[] mParameterTypes = OgnlRuntime.findParameterTypes(targetClass, m4);
                if (mParameterTypes.length != 1) continue;
                boolean declaringClassIsPublic = Modifier.isPublic(m4.getDeclaringClass().getModifiers());
                if (firstSetter == null) {
                    firstSetter = m4;
                    if (_useFirstMatchGetSetLookup) break;
                }
                if (firstPublicSetter == null && Modifier.isPublic(m4.getModifiers()) && declaringClassIsPublic) {
                    firstPublicSetter = m4;
                    break;
                }
                if (firstNonDefaultPublicInterfaceSetter != null || !OgnlRuntime.isNonDefaultPublicInterfaceMethod(m4) || !declaringClassIsPublic) continue;
                firstNonDefaultPublicInterfaceSetter = m4;
            }
            result2 = firstPublicSetter != null ? firstPublicSetter : (firstNonDefaultPublicInterfaceSetter != null ? firstNonDefaultPublicInterfaceSetter : firstSetter);
        }
        return result2;
    }

    public static final boolean hasSetMethod(OgnlContext context, Object target, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        return OgnlRuntime.isMethodAccessible(context, target, OgnlRuntime.getSetMethod(context, targetClass, propertyName), propertyName);
    }

    public static final boolean hasGetProperty(OgnlContext context, Object target, Object oname) throws IntrospectionException, OgnlException {
        Class<?> targetClass = target == null ? null : target.getClass();
        String name = oname.toString();
        return OgnlRuntime.hasGetMethod(context, target, targetClass, name) || OgnlRuntime.hasField(context, target, targetClass, name);
    }

    public static final boolean hasSetProperty(OgnlContext context, Object target, Object oname) throws IntrospectionException, OgnlException {
        Class<?> targetClass = target == null ? null : target.getClass();
        String name = oname.toString();
        return OgnlRuntime.hasSetMethod(context, target, targetClass, name) || OgnlRuntime.hasField(context, target, targetClass, name);
    }

    private static final boolean indexMethodCheck(List methods2) {
        boolean result2 = false;
        if (methods2.size() > 0) {
            Method fm = (Method)methods2.get(0);
            Class[] fmpt = OgnlRuntime.getParameterTypes(fm);
            int fmpc = fmpt.length;
            Class<?> lastMethodClass = fm.getDeclaringClass();
            result2 = true;
            for (int i2 = 1; result2 && i2 < methods2.size(); ++i2) {
                Method m4 = (Method)methods2.get(i2);
                Class<?> c2 = m4.getDeclaringClass();
                if (lastMethodClass == c2) {
                    result2 = false;
                } else {
                    Class[] mpt = OgnlRuntime.getParameterTypes(fm);
                    int mpc = fmpt.length;
                    if (fmpc != mpc) {
                        result2 = false;
                    }
                    for (int j2 = 0; j2 < fmpc; ++j2) {
                        if (fmpt[j2] == mpt[j2]) continue;
                        result2 = false;
                        break;
                    }
                }
                lastMethodClass = c2;
            }
        }
        return result2;
    }

    static void findObjectIndexedPropertyDescriptors(Class targetClass, Map intoMap) throws OgnlException {
        List methods2;
        Map allMethods = OgnlRuntime.getMethods(targetClass, false);
        HashMap pairs2 = new HashMap(101);
        for (String methodName : allMethods.keySet()) {
            List<Method> pair;
            methods2 = (List)allMethods.get(methodName);
            if (!OgnlRuntime.indexMethodCheck(methods2)) continue;
            boolean isGet = false;
            boolean isSet = false;
            Method m4 = (Method)methods2.get(0);
            isSet = methodName.startsWith(SET_PREFIX);
            if (!isSet && !(isGet = methodName.startsWith(GET_PREFIX)) || methodName.length() <= 3) continue;
            String propertyName = Introspector.decapitalize(methodName.substring(3));
            Class[] parameterTypes = OgnlRuntime.getParameterTypes(m4);
            int parameterCount = parameterTypes.length;
            if (isGet && parameterCount == 1 && m4.getReturnType() != Void.TYPE) {
                pair = (ArrayList<Method>)pairs2.get(propertyName);
                if (pair == null) {
                    pair = new ArrayList<Method>();
                    pairs2.put(propertyName, pair);
                }
                pair.add(m4);
            }
            if (!isSet || parameterCount != 2 || m4.getReturnType() != Void.TYPE) continue;
            pair = (List)pairs2.get(propertyName);
            if (pair == null) {
                pair = new ArrayList();
                pairs2.put(propertyName, pair);
            }
            pair.add(m4);
        }
        for (String propertyName : pairs2.keySet()) {
            ObjectIndexedPropertyDescriptor propertyDescriptor;
            methods2 = (List)pairs2.get(propertyName);
            if (methods2.size() != 2) continue;
            Method method1 = (Method)methods2.get(0);
            Method method2 = (Method)methods2.get(1);
            Method setMethod = method1.getParameterTypes().length == 2 ? method1 : method2;
            Method getMethod = setMethod == method1 ? method2 : method1;
            Class<?> keyType = getMethod.getParameterTypes()[0];
            Class<?> propertyType = getMethod.getReturnType();
            if (keyType != setMethod.getParameterTypes()[0] || propertyType != setMethod.getParameterTypes()[1]) continue;
            try {
                propertyDescriptor = new ObjectIndexedPropertyDescriptor(propertyName, propertyType, getMethod, setMethod);
            }
            catch (Exception ex) {
                throw new OgnlException("creating object indexed property descriptor for '" + propertyName + "' in " + targetClass, ex);
            }
            intoMap.put(propertyName, propertyDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getPropertyDescriptors(Class targetClass) throws IntrospectionException, OgnlException {
        HashMap<String, PropertyDescriptor> result2 = (HashMap<String, PropertyDescriptor>)_propertyDescriptorCache.get(targetClass);
        if (result2 == null) {
            ClassCache classCache = _propertyDescriptorCache;
            synchronized (classCache) {
                result2 = (Map)_propertyDescriptorCache.get(targetClass);
                if (result2 == null) {
                    PropertyDescriptor[] pda = Introspector.getBeanInfo(targetClass).getPropertyDescriptors();
                    result2 = new HashMap<String, PropertyDescriptor>(101);
                    int icount = pda.length;
                    for (int i2 = 0; i2 < icount; ++i2) {
                        if (pda[i2].getReadMethod() != null && !OgnlRuntime.isMethodCallable(pda[i2].getReadMethod())) {
                            pda[i2].setReadMethod(OgnlRuntime.findClosestMatchingMethod(targetClass, pda[i2].getReadMethod(), pda[i2].getName(), pda[i2].getPropertyType(), true));
                        }
                        if (pda[i2].getWriteMethod() != null && !OgnlRuntime.isMethodCallable(pda[i2].getWriteMethod())) {
                            pda[i2].setWriteMethod(OgnlRuntime.findClosestMatchingMethod(targetClass, pda[i2].getWriteMethod(), pda[i2].getName(), pda[i2].getPropertyType(), false));
                        }
                        result2.put(pda[i2].getName(), pda[i2]);
                    }
                    OgnlRuntime.findObjectIndexedPropertyDescriptors(targetClass, result2);
                    _propertyDescriptorCache.put(targetClass, result2);
                }
            }
        }
        return result2;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        if (targetClass == null) {
            return null;
        }
        return (PropertyDescriptor)OgnlRuntime.getPropertyDescriptors(targetClass).get(propertyName);
    }

    static Method findClosestMatchingMethod(Class targetClass, Method m4, String propertyName, Class propertyType, boolean isReadMethod) {
        List methods2 = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, !isReadMethod);
        if (methods2 != null) {
            for (Object method1 : methods2) {
                Method method2 = (Method)method1;
                if (!method2.getName().equals(m4.getName()) || !m4.getReturnType().isAssignableFrom(m4.getReturnType()) || method2.getReturnType() != propertyType || method2.getParameterTypes().length != m4.getParameterTypes().length) continue;
                return method2;
            }
        }
        return m4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyDescriptor[] getPropertyDescriptorsArray(Class targetClass) throws IntrospectionException {
        PropertyDescriptor[] result2 = null;
        if (targetClass != null && (result2 = (PropertyDescriptor[])_propertyDescriptorCache.get(targetClass)) == null) {
            ClassCache classCache = _propertyDescriptorCache;
            synchronized (classCache) {
                result2 = (PropertyDescriptor[])_propertyDescriptorCache.get(targetClass);
                if (result2 == null) {
                    result2 = Introspector.getBeanInfo(targetClass).getPropertyDescriptors();
                    _propertyDescriptorCache.put(targetClass, result2);
                }
            }
        }
        return result2;
    }

    public static PropertyDescriptor getPropertyDescriptorFromArray(Class targetClass, String name) throws IntrospectionException {
        PropertyDescriptor result2 = null;
        PropertyDescriptor[] pda = OgnlRuntime.getPropertyDescriptorsArray(targetClass);
        int icount = pda.length;
        for (int i2 = 0; result2 == null && i2 < icount; ++i2) {
            if (pda[i2].getName().compareTo(name) != 0) continue;
            result2 = pda[i2];
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMethodAccessor(Class cls, MethodAccessor accessor) {
        ClassCache classCache = _methodAccessors;
        synchronized (classCache) {
            _methodAccessors.put(cls, accessor);
        }
    }

    public static MethodAccessor getMethodAccessor(Class cls) throws OgnlException {
        MethodAccessor answer = (MethodAccessor)OgnlRuntime.getHandler(cls, _methodAccessors);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No method accessor for " + cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPropertyAccessor(Class cls, PropertyAccessor accessor) {
        ClassCache classCache = _propertyAccessors;
        synchronized (classCache) {
            _propertyAccessors.put(cls, accessor);
        }
    }

    public static PropertyAccessor getPropertyAccessor(Class cls) throws OgnlException {
        PropertyAccessor answer = (PropertyAccessor)OgnlRuntime.getHandler(cls, _propertyAccessors);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No property accessor for class " + cls);
    }

    public static ElementsAccessor getElementsAccessor(Class cls) throws OgnlException {
        ElementsAccessor answer = (ElementsAccessor)OgnlRuntime.getHandler(cls, _elementsAccessors);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No elements accessor for class " + cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setElementsAccessor(Class cls, ElementsAccessor accessor) {
        ClassCache classCache = _elementsAccessors;
        synchronized (classCache) {
            _elementsAccessors.put(cls, accessor);
        }
    }

    public static NullHandler getNullHandler(Class cls) throws OgnlException {
        NullHandler answer = (NullHandler)OgnlRuntime.getHandler(cls, _nullHandlers);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No null handler for class " + cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNullHandler(Class cls, NullHandler handler2) {
        ClassCache classCache = _nullHandlers;
        synchronized (classCache) {
            _nullHandlers.put(cls, handler2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getHandler(Class forClass, ClassCache handlers) {
        Object answer = null;
        answer = handlers.get(forClass);
        if (answer == null) {
            ClassCache classCache = handlers;
            synchronized (classCache) {
                answer = handlers.get(forClass);
                if (answer == null) {
                    Class<Object> keyFound;
                    if (forClass.isArray()) {
                        answer = handlers.get(Object[].class);
                        keyFound = null;
                    } else {
                        keyFound = forClass;
                        block3: for (Class c2 = forClass; c2 != null; c2 = c2.getSuperclass()) {
                            answer = handlers.get(c2);
                            if (answer == null) {
                                for (Class<?> iface : c2.getInterfaces()) {
                                    answer = handlers.get(iface);
                                    if (answer == null) {
                                        answer = OgnlRuntime.getHandler(iface, handlers);
                                    }
                                    if (answer == null) continue;
                                    keyFound = iface;
                                    break block3;
                                }
                                continue;
                            }
                            keyFound = c2;
                            break;
                        }
                    }
                    if (answer != null && keyFound != forClass) {
                        handlers.put(forClass, answer);
                    }
                }
            }
        }
        return answer;
    }

    public static Object getProperty(OgnlContext context, Object source2, Object name) throws OgnlException {
        if (source2 == null) {
            throw new OgnlException("source is null for getProperty(null, \"" + name + "\")");
        }
        PropertyAccessor accessor = OgnlRuntime.getPropertyAccessor(OgnlRuntime.getTargetClass(source2));
        if (accessor == null) {
            throw new OgnlException("No property accessor for " + OgnlRuntime.getTargetClass(source2).getName());
        }
        return accessor.getProperty(context, source2, name);
    }

    public static void setProperty(OgnlContext context, Object target, Object name, Object value2) throws OgnlException {
        if (target == null) {
            throw new OgnlException("target is null for setProperty(null, \"" + name + "\", " + value2 + ")");
        }
        PropertyAccessor accessor = OgnlRuntime.getPropertyAccessor(OgnlRuntime.getTargetClass(target));
        if (accessor == null) {
            throw new OgnlException("No property accessor for " + OgnlRuntime.getTargetClass(target).getName());
        }
        accessor.setProperty(context, target, name, value2);
    }

    public static int getIndexedPropertyType(OgnlContext context, Class sourceClass, String name) throws OgnlException {
        int result2 = INDEXED_PROPERTY_NONE;
        try {
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(sourceClass, name);
            if (pd != null) {
                if (pd instanceof IndexedPropertyDescriptor) {
                    result2 = INDEXED_PROPERTY_INT;
                } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                    result2 = INDEXED_PROPERTY_OBJECT;
                }
            }
        }
        catch (Exception ex) {
            throw new OgnlException("problem determining if '" + name + "' is an indexed property", ex);
        }
        return result2;
    }

    public static Object getIndexedProperty(OgnlContext context, Object source2, String name, Object index) throws OgnlException {
        Object[] args2 = _objectArrayPool.create(index);
        try {
            Method m4;
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(source2 == null ? null : source2.getClass(), name);
            if (pd instanceof IndexedPropertyDescriptor) {
                m4 = ((IndexedPropertyDescriptor)pd).getIndexedReadMethod();
            } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                m4 = ((ObjectIndexedPropertyDescriptor)pd).getIndexedReadMethod();
            } else {
                throw new OgnlException("property '" + name + "' is not an indexed property");
            }
            Object object = OgnlRuntime.callMethod(context, source2, m4.getName(), args2);
            return object;
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException("getting indexed property descriptor for '" + name + "'", ex);
        }
        finally {
            _objectArrayPool.recycle(args2);
        }
    }

    public static void setIndexedProperty(OgnlContext context, Object source2, String name, Object index, Object value2) throws OgnlException {
        Object[] args2 = _objectArrayPool.create(index, value2);
        try {
            Method m4;
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(source2 == null ? null : source2.getClass(), name);
            if (pd instanceof IndexedPropertyDescriptor) {
                m4 = ((IndexedPropertyDescriptor)pd).getIndexedWriteMethod();
            } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                m4 = ((ObjectIndexedPropertyDescriptor)pd).getIndexedWriteMethod();
            } else {
                throw new OgnlException("property '" + name + "' is not an indexed property");
            }
            OgnlRuntime.callMethod(context, source2, m4.getName(), args2);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException("getting indexed property descriptor for '" + name + "'", ex);
        }
        finally {
            _objectArrayPool.recycle(args2);
        }
    }

    public static EvaluationPool getEvaluationPool() {
        return _evaluationPool;
    }

    public static ObjectArrayPool getObjectArrayPool() {
        return _objectArrayPool;
    }

    public static void setClassCacheInspector(ClassCacheInspector inspector) {
        _cacheInspector = inspector;
        _propertyDescriptorCache.setClassInspector(_cacheInspector);
        _constructorCache.setClassInspector(_cacheInspector);
        _staticMethodCache.setClassInspector(_cacheInspector);
        _instanceMethodCache.setClassInspector(_cacheInspector);
        _invokePermissionCache.setClassInspector(_cacheInspector);
        _fieldCache.setClassInspector(_cacheInspector);
        _declaredMethods[0].setClassInspector(_cacheInspector);
        _declaredMethods[1].setClassInspector(_cacheInspector);
    }

    public static Method getMethod(OgnlContext context, Class target, String name, Node[] children2, boolean includeStatic) throws Exception {
        Class[] parms;
        if (children2 != null && children2.length > 0) {
            parms = new Class[children2.length];
            Class currType = context.getCurrentType();
            Class currAccessor = context.getCurrentAccessor();
            Object cast = context.get("_preCast");
            context.setCurrentObject(context.getRoot());
            context.setCurrentType(context.getRoot() != null ? context.getRoot().getClass() : null);
            context.setCurrentAccessor(null);
            context.setPreviousType(null);
            for (int i2 = 0; i2 < children2.length; ++i2) {
                children2[i2].toGetSourceString(context, context.getRoot());
                parms[i2] = context.getCurrentType();
            }
            context.put("_preCast", cast);
            context.setCurrentType(currType);
            context.setCurrentAccessor(currAccessor);
            context.setCurrentObject(target);
        } else {
            parms = EMPTY_CLASS_ARRAY;
        }
        List methods2 = OgnlRuntime.getMethods(target, name, includeStatic);
        if (methods2 == null) {
            return null;
        }
        for (int i3 = 0; i3 < methods2.size(); ++i3) {
            Method m4 = (Method)methods2.get(i3);
            boolean varArgs = m4.isVarArgs();
            if (parms.length != m4.getParameterTypes().length && !varArgs) continue;
            Class<?>[] mparms = m4.getParameterTypes();
            boolean matched = true;
            for (int p = 0; p < mparms.length; ++p) {
                if (varArgs && mparms[p].isArray()) continue;
                if (parms[p] == null) {
                    matched = false;
                    break;
                }
                if (parms[p] == mparms[p] || mparms[p].isPrimitive() && Character.TYPE != mparms[p] && Byte.TYPE != mparms[p] && Number.class.isAssignableFrom(parms[p]) && OgnlRuntime.getPrimitiveWrapperClass(parms[p]) == mparms[p]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return m4;
        }
        return null;
    }

    public static Method getReadMethod(Class target, String name) {
        return OgnlRuntime.getReadMethod(target, name, null);
    }

    public static Method getReadMethod(Class target, String name, Class[] argClasses) {
        try {
            Method ret;
            MatchingMethod mm4;
            int i2;
            if (name.indexOf(34) >= 0) {
                name = name.replaceAll("\"", "");
            }
            name = name.toLowerCase();
            Method[] methods2 = target.getMethods();
            ArrayList<Method> candidates = new ArrayList<Method>();
            for (i2 = 0; i2 < methods2.length; ++i2) {
                if (!OgnlRuntime.isMethodCallable_BridgeOrNonSynthetic(methods2[i2]) || !methods2[i2].getName().equalsIgnoreCase(name) && !methods2[i2].getName().toLowerCase().equals(GET_PREFIX + name) && !methods2[i2].getName().toLowerCase().equals("has" + name) && !methods2[i2].getName().toLowerCase().equals(IS_PREFIX + name) || methods2[i2].getName().startsWith(SET_PREFIX)) continue;
                candidates.add(methods2[i2]);
            }
            if (!candidates.isEmpty() && (mm4 = OgnlRuntime.findBestMethod(candidates, target, name, argClasses)) != null) {
                return mm4.mMethod;
            }
            for (i2 = 0; i2 < methods2.length; ++i2) {
                Method m4;
                if (!OgnlRuntime.isMethodCallable_BridgeOrNonSynthetic(methods2[i2]) || !methods2[i2].getName().equalsIgnoreCase(name) || methods2[i2].getName().startsWith(SET_PREFIX) || methods2[i2].getName().startsWith(GET_PREFIX) || methods2[i2].getName().startsWith(IS_PREFIX) || methods2[i2].getName().startsWith("has") || methods2[i2].getReturnType() == Void.TYPE || candidates.contains(m4 = methods2[i2])) continue;
                candidates.add(m4);
            }
            if (!candidates.isEmpty() && (mm = OgnlRuntime.findBestMethod(candidates, target, name, argClasses)) != null) {
                return mm.mMethod;
            }
            if (!name.startsWith(GET_PREFIX) && (ret = OgnlRuntime.getReadMethod(target, GET_PREFIX + name, argClasses)) != null) {
                return ret;
            }
            if (!candidates.isEmpty()) {
                int reqArgCount = argClasses == null ? 0 : argClasses.length;
                for (Method m5 : candidates) {
                    if (m5.getParameterTypes().length != reqArgCount) continue;
                    return m5;
                }
            }
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        return null;
    }

    public static Method getWriteMethod(Class target, String name) {
        return OgnlRuntime.getWriteMethod(target, name, null);
    }

    public static Method getWriteMethod(Class target, String name, Class[] argClasses) {
        try {
            Method ret;
            MatchingMethod mm4;
            MatchingMethod mm5;
            if (name.indexOf(34) >= 0) {
                name = name.replaceAll("\"", "");
            }
            BeanInfo info = Introspector.getBeanInfo(target);
            MethodDescriptor[] methods2 = info.getMethodDescriptors();
            ArrayList<Method> candidates = new ArrayList<Method>();
            for (int i2 = 0; i2 < methods2.length; ++i2) {
                if (!OgnlRuntime.isMethodCallable_BridgeOrNonSynthetic(methods2[i2].getMethod()) || !methods2[i2].getName().equalsIgnoreCase(name) && !methods2[i2].getName().toLowerCase().equals(name.toLowerCase()) && !methods2[i2].getName().toLowerCase().equals(SET_PREFIX + name.toLowerCase()) || methods2[i2].getName().startsWith(GET_PREFIX)) continue;
                candidates.add(methods2[i2].getMethod());
            }
            if (!candidates.isEmpty() && (mm5 = OgnlRuntime.findBestMethod(candidates, target, name, argClasses)) != null) {
                return mm5.mMethod;
            }
            Method[] cmethods = target.getClass().getMethods();
            for (int i3 = 0; i3 < cmethods.length; ++i3) {
                Method m4;
                if (!OgnlRuntime.isMethodCallable_BridgeOrNonSynthetic(cmethods[i3]) || !cmethods[i3].getName().equalsIgnoreCase(name) && !cmethods[i3].getName().toLowerCase().equals(name.toLowerCase()) && !cmethods[i3].getName().toLowerCase().equals(SET_PREFIX + name.toLowerCase()) || cmethods[i3].getName().startsWith(GET_PREFIX) || candidates.contains(m4 = methods2[i3].getMethod())) continue;
                candidates.add(m4);
            }
            if (!candidates.isEmpty() && (mm4 = OgnlRuntime.findBestMethod(candidates, target, name, argClasses)) != null) {
                return mm4.mMethod;
            }
            if (!name.startsWith(SET_PREFIX) && (ret = OgnlRuntime.getReadMethod(target, SET_PREFIX + name, argClasses)) != null) {
                return ret;
            }
            if (!candidates.isEmpty()) {
                int reqArgCount = argClasses == null ? 0 : argClasses.length;
                for (Method m5 : candidates) {
                    if (m5.getParameterTypes().length != reqArgCount) continue;
                    return m5;
                }
                if (argClasses == null && candidates.size() == 1) {
                    return (Method)candidates.get(0);
                }
            }
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        return null;
    }

    public static PropertyDescriptor getProperty(Class target, String name) {
        try {
            BeanInfo info = Introspector.getBeanInfo(target);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (int i2 = 0; i2 < pds.length; ++i2) {
                if (!pds[i2].getName().equalsIgnoreCase(name) && !pds[i2].getName().toLowerCase().equals(name.toLowerCase()) && !pds[i2].getName().toLowerCase().endsWith(name.toLowerCase())) continue;
                return pds[i2];
            }
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        return null;
    }

    public static boolean isBoolean(String expression) {
        if (expression == null) {
            return false;
        }
        return "true".equals(expression) || "false".equals(expression) || "!true".equals(expression) || "!false".equals(expression) || "(true)".equals(expression) || "!(true)".equals(expression) || "(false)".equals(expression) || "!(false)".equals(expression) || expression.startsWith("ognl.OgnlOps");
    }

    public static boolean shouldConvertNumericTypes(OgnlContext context) {
        if (context.getCurrentType() == null || context.getPreviousType() == null) {
            return true;
        }
        if (context.getCurrentType() == context.getPreviousType() && context.getCurrentType().isPrimitive() && context.getPreviousType().isPrimitive()) {
            return false;
        }
        return context.getCurrentType() != null && !context.getCurrentType().isArray() && context.getPreviousType() != null && !context.getPreviousType().isArray();
    }

    public static String getChildSource(OgnlContext context, Object target, Node child) throws OgnlException {
        return OgnlRuntime.getChildSource(context, target, child, false);
    }

    public static String getChildSource(OgnlContext context, Object target, Node child, boolean forceConversion) throws OgnlException {
        String pre = (String)context.get("_currentChain");
        if (pre == null) {
            pre = "";
        }
        try {
            child.getValue(context, target);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArithmeticException e2) {
            context.setCurrentType(Integer.TYPE);
            return "0";
        }
        catch (Throwable t2) {
            throw OgnlOps.castToRuntime(t2);
        }
        String source2 = null;
        try {
            source2 = child.toGetSourceString(context, target);
        }
        catch (Throwable t3) {
            throw OgnlOps.castToRuntime(t3);
        }
        if (!(ASTConst.class.isInstance(child) || target != null && context.getRoot() == target)) {
            source2 = pre + source2;
        }
        if (context.getRoot() != null) {
            source2 = ExpressionCompiler.getRootExpression(child, context.getRoot(), context) + source2;
            context.setCurrentAccessor(context.getRoot().getClass());
        }
        if (ASTChain.class.isInstance(child)) {
            String cast = (String)context.remove("_preCast");
            if (cast == null) {
                cast = "";
            }
            source2 = cast + source2;
        }
        if (source2 == null || source2.trim().length() < 1) {
            source2 = "null";
        }
        return source2;
    }

    static int detectMajorJavaVersion() {
        int majorVersion = -1;
        try {
            majorVersion = OgnlRuntime.parseMajorJavaVersion(System.getProperty("java.version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (majorVersion == -1) {
            majorVersion = 5;
        }
        return majorVersion;
    }

    static int parseMajorJavaVersion(String versionString) {
        int majorVersion = -1;
        try {
            String[] sections;
            if (versionString != null && versionString.length() > 0 && (sections = versionString.split("[\\.\\-\\+]")).length > 0 && sections[0].length() > 0) {
                int secondSection;
                int firstSection;
                if (sections.length > 1 && sections[1].length() > 0) {
                    firstSection = Integer.parseInt(sections[0]);
                    secondSection = sections[1].matches("\\d+") ? Integer.parseInt(sections[1]) : -1;
                } else {
                    firstSection = Integer.parseInt(sections[0]);
                    secondSection = -1;
                }
                majorVersion = firstSection == 1 && secondSection != -1 ? secondSection : firstSection;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (majorVersion == -1) {
            majorVersion = 5;
        }
        return majorVersion;
    }

    public static boolean getUseJDK9PlusAccessHandlerValue() {
        return _useJDK9PlusAccessHandler;
    }

    public static boolean getUseStricterInvocationValue() {
        return _useStricterInvocation;
    }

    public static boolean getDisableOgnlSecurityManagerOnInitValue() {
        return _disableOgnlSecurityManagerOnInit;
    }

    public static boolean usingJDK9PlusAccessHandler() {
        return _jdk9Plus && _useJDK9PlusAccessHandler;
    }

    public static boolean getUseFirstMatchGetSetLookupValue() {
        return _useFirstMatchGetSetLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String propertyString2;
        NotFound = new Object();
        NotFoundList = new ArrayList();
        NotFoundMap = new HashMap();
        NoArguments = new Object[0];
        NoArgumentTypes = new Class[0];
        NoConversionPossible = "ognl.NoConversionPossible";
        INDEXED_PROPERTY_NONE = 0;
        INDEXED_PROPERTY_INT = 1;
        INDEXED_PROPERTY_OBJECT = 2;
        NULL_STRING = "" + null;
        HEX_PADDING = new HashMap();
        _jdk15 = false;
        _jdkChecked = false;
        boolean initialFlagState = false;
        try {
            propertyString2 = System.getProperty(USE_JDK9PLUS_ACESS_HANDLER);
            if (propertyString2 != null && propertyString2.length() > 0) {
                initialFlagState = Boolean.parseBoolean(propertyString2);
            }
        }
        catch (Exception propertyString2) {
            // empty catch block
        }
        _useJDK9PlusAccessHandler = initialFlagState;
        initialFlagState = true;
        try {
            propertyString2 = System.getProperty(USE_STRICTER_INVOCATION);
            if (propertyString2 != null && propertyString2.length() > 0) {
                initialFlagState = Boolean.parseBoolean(propertyString2);
            }
        }
        catch (Exception propertyString3) {
            // empty catch block
        }
        _useStricterInvocation = initialFlagState;
        _majorJavaVersion = OgnlRuntime.detectMajorJavaVersion();
        _jdk9Plus = _majorJavaVersion >= 9;
        _accessibleObjectHandler = OgnlRuntime.usingJDK9PlusAccessHandler() ? AccessibleObjectHandlerJDK9Plus.createHandler() : AccessibleObjectHandlerPreJDK9.createHandler();
        Method setAccessibleMethod = null;
        Method setAccessibleMethodArray = null;
        Method systemExitMethod = null;
        Method systemConsoleMethod = null;
        try {
            setAccessibleMethod = AccessibleObject.class.getMethod("setAccessible", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            AO_SETACCESSIBLE_REF = setAccessibleMethod;
        }
        try {
            setAccessibleMethodArray = AccessibleObject.class.getMethod("setAccessible", AccessibleObject[].class, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            AO_SETACCESSIBLE_ARR_REF = setAccessibleMethodArray;
        }
        try {
            systemExitMethod = System.class.getMethod("exit", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            SYS_EXIT_REF = systemExitMethod;
        }
        try {
            systemConsoleMethod = System.class.getMethod("console", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            SYS_CONSOLE_REF = systemConsoleMethod;
        }
        initialFlagState = false;
        try {
            propertyString2 = System.getProperty(OGNL_SECURITY_MANAGER);
            if (propertyString2 != null && propertyString2.length() > 0) {
                initialFlagState = OGNL_SM_FORCE_DISABLE_ON_INIT.equalsIgnoreCase(propertyString2);
            }
        }
        catch (Exception propertyString4) {
            // empty catch block
        }
        _disableOgnlSecurityManagerOnInit = initialFlagState;
        initialFlagState = false;
        try {
            propertyString2 = System.getProperty(USE_FIRSTMATCH_GETSET_LOOKUP);
            if (propertyString2 != null && propertyString2.length() > 0) {
                initialFlagState = Boolean.parseBoolean(propertyString2);
            }
        }
        catch (Exception propertyString5) {
            // empty catch block
        }
        _useFirstMatchGetSetLookup = initialFlagState;
        _methodAccessors = new ClassCacheImpl();
        _propertyAccessors = new ClassCacheImpl();
        _elementsAccessors = new ClassCacheImpl();
        _nullHandlers = new ClassCacheImpl();
        _propertyDescriptorCache = new ClassCacheImpl();
        _constructorCache = new ClassCacheImpl();
        _staticMethodCache = new ClassCacheImpl();
        _instanceMethodCache = new ClassCacheImpl();
        _invokePermissionCache = new ClassCacheImpl();
        _fieldCache = new ClassCacheImpl();
        _superclasses = new ArrayList();
        _declaredMethods = new ClassCache[]{new ClassCacheImpl(), new ClassCacheImpl()};
        _primitiveTypes = new HashMap(101);
        _primitiveDefaults = new ClassCacheImpl();
        _methodParameterTypesCache = new HashMap(101);
        _genericMethodParameterTypesCache = new HashMap(101);
        _ctorParameterTypesCache = new HashMap(101);
        _securityManager = System.getSecurityManager();
        _evaluationPool = new EvaluationPool();
        _objectArrayPool = new ObjectArrayPool();
        _methodAccessCache = new ConcurrentHashMap<Method, Boolean>();
        _methodPermCache = new ConcurrentHashMap<Method, Boolean>();
        cacheSetMethod = new ClassPropertyMethodCache();
        cacheGetMethod = new ClassPropertyMethodCache();
        try {
            Class.forName("javassist.ClassPool");
            _compiler = new ExpressionCompiler();
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException("Javassist library is missing in classpath! Please add missed dependency!", e2);
        }
        catch (RuntimeException rt) {
            throw new IllegalStateException("Javassist library cannot be loaded, is it restricted by runtime environment?");
        }
        EMPTY_CLASS_ARRAY = new Class[0];
        PRIMITIVE_WRAPPER_CLASSES = new IdentityHashMap();
        PRIMITIVE_WRAPPER_CLASSES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER_CLASSES.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_CLASSES.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_CLASSES.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_CLASSES.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER_CLASSES.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_CLASSES.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_CLASSES.put(Short.class, Short.TYPE);
        PRIMITIVE_WRAPPER_CLASSES.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_CLASSES.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_CLASSES.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_CLASSES.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_CLASSES.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_CLASSES.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_CLASSES.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_CLASSES.put(Double.class, Double.TYPE);
        NUMERIC_CASTS = new HashMap();
        NUMERIC_CASTS.put(Double.class, "(double)");
        NUMERIC_CASTS.put(Float.class, "(float)");
        NUMERIC_CASTS.put(Integer.class, "(int)");
        NUMERIC_CASTS.put(Long.class, "(long)");
        NUMERIC_CASTS.put(BigDecimal.class, "(double)");
        NUMERIC_CASTS.put(BigInteger.class, "");
        NUMERIC_VALUES = new HashMap();
        NUMERIC_VALUES.put(Double.class, "doubleValue()");
        NUMERIC_VALUES.put(Float.class, "floatValue()");
        NUMERIC_VALUES.put(Integer.class, "intValue()");
        NUMERIC_VALUES.put(Long.class, "longValue()");
        NUMERIC_VALUES.put(Short.class, "shortValue()");
        NUMERIC_VALUES.put(Byte.class, "byteValue()");
        NUMERIC_VALUES.put(BigDecimal.class, "doubleValue()");
        NUMERIC_VALUES.put(BigInteger.class, "doubleValue()");
        NUMERIC_VALUES.put(Boolean.class, "booleanValue()");
        NUMERIC_LITERALS = new HashMap();
        NUMERIC_LITERALS.put(Integer.class, "");
        NUMERIC_LITERALS.put(Integer.TYPE, "");
        NUMERIC_LITERALS.put(Long.class, "l");
        NUMERIC_LITERALS.put(Long.TYPE, "l");
        NUMERIC_LITERALS.put(BigInteger.class, "d");
        NUMERIC_LITERALS.put(Float.class, "f");
        NUMERIC_LITERALS.put(Float.TYPE, "f");
        NUMERIC_LITERALS.put(Double.class, "d");
        NUMERIC_LITERALS.put(Double.TYPE, "d");
        NUMERIC_LITERALS.put(BigInteger.class, "d");
        NUMERIC_LITERALS.put(BigDecimal.class, "d");
        NUMERIC_DEFAULTS = new HashMap();
        NUMERIC_DEFAULTS.put(Boolean.class, Boolean.FALSE);
        NUMERIC_DEFAULTS.put(Byte.class, new Byte(0));
        NUMERIC_DEFAULTS.put(Short.class, new Short(0));
        NUMERIC_DEFAULTS.put(Character.class, new Character('\u0000'));
        NUMERIC_DEFAULTS.put(Integer.class, new Integer(0));
        NUMERIC_DEFAULTS.put(Long.class, new Long(0L));
        NUMERIC_DEFAULTS.put(Float.class, new Float(0.0f));
        NUMERIC_DEFAULTS.put(Double.class, new Double(0.0));
        NUMERIC_DEFAULTS.put(BigInteger.class, new BigInteger("0"));
        NUMERIC_DEFAULTS.put(BigDecimal.class, new BigDecimal(0.0));
        ArrayPropertyAccessor p = new ArrayPropertyAccessor();
        OgnlRuntime.setPropertyAccessor(Object.class, new ObjectPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(byte[].class, p);
        OgnlRuntime.setPropertyAccessor(short[].class, p);
        OgnlRuntime.setPropertyAccessor(char[].class, p);
        OgnlRuntime.setPropertyAccessor(int[].class, p);
        OgnlRuntime.setPropertyAccessor(long[].class, p);
        OgnlRuntime.setPropertyAccessor(float[].class, p);
        OgnlRuntime.setPropertyAccessor(double[].class, p);
        OgnlRuntime.setPropertyAccessor(Object[].class, p);
        OgnlRuntime.setPropertyAccessor(List.class, new ListPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Map.class, new MapPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Set.class, new SetPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Iterator.class, new IteratorPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Enumeration.class, new EnumerationPropertyAccessor());
        ArrayElementsAccessor e3 = new ArrayElementsAccessor();
        OgnlRuntime.setElementsAccessor(Object.class, new ObjectElementsAccessor());
        OgnlRuntime.setElementsAccessor(byte[].class, e3);
        OgnlRuntime.setElementsAccessor(short[].class, e3);
        OgnlRuntime.setElementsAccessor(char[].class, e3);
        OgnlRuntime.setElementsAccessor(int[].class, e3);
        OgnlRuntime.setElementsAccessor(long[].class, e3);
        OgnlRuntime.setElementsAccessor(float[].class, e3);
        OgnlRuntime.setElementsAccessor(double[].class, e3);
        OgnlRuntime.setElementsAccessor(Object[].class, e3);
        OgnlRuntime.setElementsAccessor(Collection.class, new CollectionElementsAccessor());
        OgnlRuntime.setElementsAccessor(Map.class, new MapElementsAccessor());
        OgnlRuntime.setElementsAccessor(Iterator.class, new IteratorElementsAccessor());
        OgnlRuntime.setElementsAccessor(Enumeration.class, new EnumerationElementsAccessor());
        OgnlRuntime.setElementsAccessor(Number.class, new NumberElementsAccessor());
        ObjectNullHandler nh = new ObjectNullHandler();
        OgnlRuntime.setNullHandler(Object.class, nh);
        OgnlRuntime.setNullHandler(byte[].class, nh);
        OgnlRuntime.setNullHandler(short[].class, nh);
        OgnlRuntime.setNullHandler(char[].class, nh);
        OgnlRuntime.setNullHandler(int[].class, nh);
        OgnlRuntime.setNullHandler(long[].class, nh);
        OgnlRuntime.setNullHandler(float[].class, nh);
        OgnlRuntime.setNullHandler(double[].class, nh);
        OgnlRuntime.setNullHandler(Object[].class, nh);
        ObjectMethodAccessor ma = new ObjectMethodAccessor();
        OgnlRuntime.setMethodAccessor(Object.class, ma);
        OgnlRuntime.setMethodAccessor(byte[].class, ma);
        OgnlRuntime.setMethodAccessor(short[].class, ma);
        OgnlRuntime.setMethodAccessor(char[].class, ma);
        OgnlRuntime.setMethodAccessor(int[].class, ma);
        OgnlRuntime.setMethodAccessor(long[].class, ma);
        OgnlRuntime.setMethodAccessor(float[].class, ma);
        OgnlRuntime.setMethodAccessor(double[].class, ma);
        OgnlRuntime.setMethodAccessor(Object[].class, ma);
        _primitiveTypes.put("boolean", Boolean.TYPE);
        _primitiveTypes.put("byte", Byte.TYPE);
        _primitiveTypes.put("short", Short.TYPE);
        _primitiveTypes.put("char", Character.TYPE);
        _primitiveTypes.put("int", Integer.TYPE);
        _primitiveTypes.put("long", Long.TYPE);
        _primitiveTypes.put("float", Float.TYPE);
        _primitiveTypes.put("double", Double.TYPE);
        _primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        _primitiveDefaults.put(Boolean.class, Boolean.FALSE);
        _primitiveDefaults.put(Byte.TYPE, new Byte(0));
        _primitiveDefaults.put(Byte.class, new Byte(0));
        _primitiveDefaults.put(Short.TYPE, new Short(0));
        _primitiveDefaults.put(Short.class, new Short(0));
        _primitiveDefaults.put(Character.TYPE, new Character('\u0000'));
        _primitiveDefaults.put(Integer.TYPE, new Integer(0));
        _primitiveDefaults.put(Long.TYPE, new Long(0L));
        _primitiveDefaults.put(Float.TYPE, new Float(0.0f));
        _primitiveDefaults.put(Double.TYPE, new Double(0.0));
        _primitiveDefaults.put(BigInteger.class, new BigInteger("0"));
        _primitiveDefaults.put(BigDecimal.class, new BigDecimal(0.0));
        NoArgsReport = new ArgsCompatbilityReport(0, new boolean[0]);
    }

    private static final class ClassPropertyMethodCache {
        private static final Method NULL_REPLACEMENT;
        private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Method>> cache = new ConcurrentHashMap();

        ClassPropertyMethodCache() {
        }

        Method get(Class clazz, String propertyName) {
            ConcurrentHashMap<String, Method> methodsByPropertyName = this.cache.get(clazz);
            if (methodsByPropertyName == null) {
                return null;
            }
            Method method2 = methodsByPropertyName.get(propertyName);
            return method2;
        }

        void put(Class clazz, String propertyName, Method method2) {
            ConcurrentHashMap<String, Method> old;
            ConcurrentHashMap<String, Method> methodsByPropertyName = this.cache.get(clazz);
            if (methodsByPropertyName == null && null != (old = this.cache.putIfAbsent(clazz, methodsByPropertyName = new ConcurrentHashMap()))) {
                methodsByPropertyName = old;
            }
            methodsByPropertyName.putIfAbsent(propertyName, method2 == null ? NULL_REPLACEMENT : method2);
        }

        void clear() {
            this.cache.clear();
        }

        static {
            try {
                NULL_REPLACEMENT = ClassPropertyMethodCache.class.getDeclaredMethod(OgnlRuntime.GET_PREFIX, Class.class, String.class);
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static class MatchingMethod {
        Method mMethod;
        int score;
        ArgsCompatbilityReport report;
        Class[] mParameterTypes;

        private MatchingMethod(Method method2, int score, ArgsCompatbilityReport report, Class[] mParameterTypes) {
            this.mMethod = method2;
            this.score = score;
            this.report = report;
            this.mParameterTypes = mParameterTypes;
        }
    }

    public static class ArgsCompatbilityReport {
        int score;
        boolean[] conversionNeeded;

        public ArgsCompatbilityReport(int score, boolean[] conversionNeeded) {
            this.score = score;
            this.conversionNeeded = conversionNeeded;
        }
    }
}

