/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.io.PrintWriter;
import java.io.Serializable;
import ognl.Evaluation;
import ognl.EvaluationPool;
import ognl.InappropriateExpressionException;
import ognl.Node;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlParser;
import ognl.OgnlParserTreeConstants;
import ognl.OgnlRuntime;
import ognl.enhance.ExpressionAccessor;

public abstract class SimpleNode
implements Node,
Serializable {
    protected Node _parent;
    protected Node[] _children;
    protected int _id;
    protected OgnlParser _parser;
    private boolean _constantValueCalculated;
    private volatile boolean _hasConstantValue;
    private Object _constantValue;
    private ExpressionAccessor _accessor;

    public SimpleNode(int i2) {
        this._id = i2;
    }

    public SimpleNode(OgnlParser p, int i2) {
        this(i2);
        this._parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this._parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this._parent;
    }

    @Override
    public void jjtAddChild(Node n, int i2) {
        if (this._children == null) {
            this._children = new Node[i2 + 1];
        } else if (i2 >= this._children.length) {
            Node[] c2 = new Node[i2 + 1];
            System.arraycopy(this._children, 0, c2, 0, this._children.length);
            this._children = c2;
        }
        this._children[i2] = n;
    }

    @Override
    public Node jjtGetChild(int i2) {
        return this._children[i2];
    }

    @Override
    public int jjtGetNumChildren() {
        return this._children == null ? 0 : this._children.length;
    }

    public String toString() {
        return OgnlParserTreeConstants.jjtNodeName[this._id];
    }

    public String toString(String prefix2) {
        return prefix2 + OgnlParserTreeConstants.jjtNodeName[this._id] + " " + this.toString();
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        return this.toString();
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        return this.toString();
    }

    public void dump(PrintWriter writer, String prefix2) {
        writer.println(this.toString(prefix2));
        if (this._children != null) {
            for (int i2 = 0; i2 < this._children.length; ++i2) {
                SimpleNode n = (SimpleNode)this._children[i2];
                if (n == null) continue;
                n.dump(writer, prefix2 + "  ");
            }
        }
    }

    public int getIndexInParent() {
        int result2 = -1;
        if (this._parent != null) {
            int icount = this._parent.jjtGetNumChildren();
            for (int i2 = 0; i2 < icount; ++i2) {
                if (this._parent.jjtGetChild(i2) != this) continue;
                result2 = i2;
                break;
            }
        }
        return result2;
    }

    public Node getNextSibling() {
        int icount;
        Node result2 = null;
        int i2 = this.getIndexInParent();
        if (i2 >= 0 && i2 < (icount = this._parent.jjtGetNumChildren())) {
            result2 = this._parent.jjtGetChild(i2 + 1);
        }
        return result2;
    }

    protected Object evaluateGetValueBody(OgnlContext context, Object source2) throws OgnlException {
        context.setCurrentObject(source2);
        context.setCurrentNode(this);
        if (!this._constantValueCalculated) {
            this._constantValueCalculated = true;
            boolean constant = this.isConstant(context);
            if (constant) {
                this._constantValue = this.getValueBody(context, source2);
            }
            this._hasConstantValue = constant;
        }
        return this._hasConstantValue ? this._constantValue : this.getValueBody(context, source2);
    }

    protected void evaluateSetValueBody(OgnlContext context, Object target, Object value2) throws OgnlException {
        context.setCurrentObject(target);
        context.setCurrentNode(this);
        this.setValueBody(context, target, value2);
    }

    @Override
    public final Object getValue(OgnlContext context, Object source2) throws OgnlException {
        Object result2 = null;
        if (context.getTraceEvaluations()) {
            EvaluationPool pool = OgnlRuntime.getEvaluationPool();
            Exception evalException = null;
            Evaluation evaluation = pool.create(this, source2);
            context.pushEvaluation(evaluation);
            try {
                result2 = this.evaluateGetValueBody(context, source2);
            }
            catch (OgnlException ex) {
                evalException = ex;
                throw ex;
            }
            catch (RuntimeException ex) {
                evalException = ex;
                throw ex;
            }
            finally {
                Evaluation eval = context.popEvaluation();
                eval.setResult(result2);
                if (evalException != null) {
                    eval.setException(evalException);
                }
                if (evalException == null && context.getRootEvaluation() == null && !context.getKeepLastEvaluation()) {
                    pool.recycleAll(eval);
                }
            }
        } else {
            result2 = this.evaluateGetValueBody(context, source2);
        }
        return result2;
    }

    protected abstract Object getValueBody(OgnlContext var1, Object var2) throws OgnlException;

    @Override
    public final void setValue(OgnlContext context, Object target, Object value2) throws OgnlException {
        if (context.getTraceEvaluations()) {
            EvaluationPool pool = OgnlRuntime.getEvaluationPool();
            Exception evalException = null;
            Evaluation evaluation = pool.create(this, target, true);
            context.pushEvaluation(evaluation);
            try {
                this.evaluateSetValueBody(context, target, value2);
            }
            catch (OgnlException ex) {
                evalException = ex;
                ex.setEvaluation(evaluation);
                throw ex;
            }
            catch (RuntimeException ex) {
                evalException = ex;
                throw ex;
            }
            finally {
                Evaluation eval = context.popEvaluation();
                if (evalException != null) {
                    eval.setException(evalException);
                }
                if (evalException == null && context.getRootEvaluation() == null && !context.getKeepLastEvaluation()) {
                    pool.recycleAll(eval);
                }
            }
        } else {
            this.evaluateSetValueBody(context, target, value2);
        }
    }

    protected void setValueBody(OgnlContext context, Object target, Object value2) throws OgnlException {
        throw new InappropriateExpressionException(this);
    }

    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        return false;
    }

    public boolean isConstant(OgnlContext context) throws OgnlException {
        return this.isNodeConstant(context);
    }

    public boolean isNodeSimpleProperty(OgnlContext context) throws OgnlException {
        return false;
    }

    public boolean isSimpleProperty(OgnlContext context) throws OgnlException {
        return this.isNodeSimpleProperty(context);
    }

    public boolean isSimpleNavigationChain(OgnlContext context) throws OgnlException {
        return this.isSimpleProperty(context);
    }

    public boolean isEvalChain(OgnlContext context) throws OgnlException {
        if (this._children == null) {
            return false;
        }
        for (Node child : this._children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isEvalChain(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isSequence(OgnlContext context) throws OgnlException {
        if (this._children == null) {
            return false;
        }
        for (Node child : this._children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isSequence(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isOperation(OgnlContext context) throws OgnlException {
        if (this._children == null) {
            return false;
        }
        for (Node child : this._children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isOperation(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isChain(OgnlContext context) throws OgnlException {
        if (this._children == null) {
            return false;
        }
        for (Node child : this._children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isChain(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isSimpleMethod(OgnlContext context) throws OgnlException {
        return false;
    }

    protected boolean lastChild(OgnlContext context) {
        return this._parent == null || context.get("_lastChild") != null;
    }

    protected void flattenTree() {
        boolean shouldFlatten = false;
        int newSize = 0;
        for (int i2 = 0; i2 < this._children.length; ++i2) {
            if (this._children[i2].getClass() == this.getClass()) {
                shouldFlatten = true;
                newSize += this._children[i2].jjtGetNumChildren();
                continue;
            }
            ++newSize;
        }
        if (shouldFlatten) {
            Node[] newChildren = new Node[newSize];
            int j2 = 0;
            for (int i3 = 0; i3 < this._children.length; ++i3) {
                Node c2 = this._children[i3];
                if (c2.getClass() == this.getClass()) {
                    for (int k2 = 0; k2 < c2.jjtGetNumChildren(); ++k2) {
                        newChildren[j2++] = c2.jjtGetChild(k2);
                    }
                    continue;
                }
                newChildren[j2++] = c2;
            }
            if (j2 != newSize) {
                throw new Error("Assertion error: " + j2 + " != " + newSize);
            }
            this._children = newChildren;
        }
    }

    @Override
    public ExpressionAccessor getAccessor() {
        return this._accessor;
    }

    @Override
    public void setAccessor(ExpressionAccessor accessor) {
        this._accessor = accessor;
    }
}

