/*
 * Decompiled with CFR 0.152.
 */
package ognl.internal;

import java.util.Arrays;
import ognl.ClassCacheInspector;
import ognl.internal.ClassCache;
import ognl.internal.Entry;

public class ClassCacheImpl
implements ClassCache {
    private static final int TABLE_SIZE = 512;
    private static final int TABLE_SIZE_MASK = 511;
    private Entry[] _table = new Entry[512];
    private ClassCacheInspector _classInspector;
    private int _size = 0;

    @Override
    public void setClassInspector(ClassCacheInspector inspector) {
        this._classInspector = inspector;
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this._table.length; ++i2) {
            this._table[i2] = null;
        }
        this._size = 0;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    @Override
    public final Object get(Class key2) {
        Object result2 = null;
        int i2 = key2.hashCode() & 0x1FF;
        Entry entry = this._table[i2];
        while (entry != null) {
            if (entry.key == key2) {
                result2 = entry.value;
                break;
            }
            entry = entry.next;
        }
        return result2;
    }

    @Override
    public final Object put(Class key2, Object value2) {
        if (this._classInspector != null && !this._classInspector.shouldCache(key2)) {
            return value2;
        }
        Object result2 = null;
        int i2 = key2.hashCode() & 0x1FF;
        Entry entry = this._table[i2];
        if (entry == null) {
            this._table[i2] = new Entry(key2, value2);
            ++this._size;
        } else if (entry.key == key2) {
            result2 = entry.value;
            entry.value = value2;
        } else {
            while (true) {
                if (entry.key == key2) {
                    result2 = entry.value;
                    entry.value = value2;
                    break;
                }
                if (entry.next == null) {
                    entry.next = new Entry(key2, value2);
                    break;
                }
                entry = entry.next;
            }
        }
        return result2;
    }

    public String toString() {
        return "ClassCacheImpl[_table=" + (this._table == null ? null : Arrays.asList(this._table)) + '\n' + ", _classInspector=" + this._classInspector + '\n' + ", _size=" + this._size + '\n' + ']';
    }
}

