/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections4.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections4.map.AbstractMapDecorator;
import org.apache.commons.collections4.set.AbstractSetDecorator;

abstract class AbstractInputCheckedMapDecorator<K, V>
extends AbstractMapDecorator<K, V> {
    protected AbstractInputCheckedMapDecorator() {
    }

    protected AbstractInputCheckedMapDecorator(Map<K, V> map2) {
        super(map2);
    }

    protected abstract V checkSetValue(V var1);

    protected boolean isSetValueChecking() {
        return true;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.isSetValueChecking()) {
            return new EntrySet(this.map.entrySet(), this);
        }
        return this.map.entrySet();
    }

    private class MapEntry
    extends AbstractMapEntryDecorator<K, V> {
        private final AbstractInputCheckedMapDecorator<K, V> parent;

        protected MapEntry(Map.Entry<K, V> entry, AbstractInputCheckedMapDecorator<K, V> parent) {
            super(entry);
            this.parent = parent;
        }

        @Override
        public V setValue(V value2) {
            value2 = this.parent.checkSetValue(value2);
            return this.getMapEntry().setValue(value2);
        }
    }

    private class EntrySetIterator
    extends AbstractIteratorDecorator<Map.Entry<K, V>> {
        private final AbstractInputCheckedMapDecorator<K, V> parent;

        protected EntrySetIterator(Iterator<Map.Entry<K, V>> iterator2, AbstractInputCheckedMapDecorator<K, V> parent) {
            super(iterator2);
            this.parent = parent;
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry entry = (Map.Entry)this.getIterator().next();
            return new MapEntry(entry, this.parent);
        }
    }

    private class EntrySet
    extends AbstractSetDecorator<Map.Entry<K, V>> {
        private static final long serialVersionUID = 4354731610923110264L;
        private final AbstractInputCheckedMapDecorator<K, V> parent;

        protected EntrySet(Set<Map.Entry<K, V>> set2, AbstractInputCheckedMapDecorator<K, V> parent) {
            super(set2);
            this.parent = parent;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(this.decorated().iterator(), this.parent);
        }

        @Override
        public Object[] toArray() {
            Object[] array = this.decorated().toArray();
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = new MapEntry((Map.Entry)array[i2], this.parent);
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Object[] result2 = array;
            if (array.length > 0) {
                result2 = (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
            }
            result2 = this.decorated().toArray(result2);
            for (int i2 = 0; i2 < result2.length; ++i2) {
                result2[i2] = new MapEntry((Map.Entry)result2[i2], this.parent);
            }
            if (result2.length > array.length) {
                return result2;
            }
            System.arraycopy(result2, 0, array, 0, result2.length);
            if (array.length > result2.length) {
                array[result2.length] = null;
            }
            return array;
        }
    }
}

