/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

@Deprecated
public abstract class DirectoryWalker<T> {
    private final FileFilter filter;
    private final int depthLimit;

    protected DirectoryWalker() {
        this(null, -1);
    }

    protected DirectoryWalker(FileFilter filter2, int depthLimit) {
        this.filter = filter2;
        this.depthLimit = depthLimit;
    }

    protected DirectoryWalker(IOFileFilter directoryFilter, IOFileFilter fileFilter, int depthLimit) {
        if (directoryFilter == null && fileFilter == null) {
            this.filter = null;
        } else {
            directoryFilter = directoryFilter != null ? directoryFilter : TrueFileFilter.TRUE;
            fileFilter = fileFilter != null ? fileFilter : TrueFileFilter.TRUE;
            directoryFilter = FileFilterUtils.makeDirectoryOnly(directoryFilter);
            fileFilter = FileFilterUtils.makeFileOnly(fileFilter);
            this.filter = directoryFilter.or(fileFilter);
        }
        this.depthLimit = depthLimit;
    }

    protected final void checkIfCancelled(File file2, int depth, Collection<T> results2) throws IOException {
        if (this.handleIsCancelled(file2, depth, results2)) {
            throw new CancelException(file2, depth);
        }
    }

    protected File[] filterDirectoryContents(File directory, int depth, File ... files2) throws IOException {
        return files2;
    }

    protected void handleCancelled(File startDirectory, Collection<T> results2, CancelException cancel) throws IOException {
        throw cancel;
    }

    protected boolean handleDirectory(File directory, int depth, Collection<T> results2) throws IOException {
        return true;
    }

    protected void handleDirectoryEnd(File directory, int depth, Collection<T> results2) throws IOException {
    }

    protected void handleDirectoryStart(File directory, int depth, Collection<T> results2) throws IOException {
    }

    protected void handleEnd(Collection<T> results2) throws IOException {
    }

    protected void handleFile(File file2, int depth, Collection<T> results2) throws IOException {
    }

    protected boolean handleIsCancelled(File file2, int depth, Collection<T> results2) throws IOException {
        return false;
    }

    protected void handleRestricted(File directory, int depth, Collection<T> results2) throws IOException {
    }

    protected void handleStart(File startDirectory, Collection<T> results2) throws IOException {
    }

    protected final void walk(File startDirectory, Collection<T> results2) throws IOException {
        Objects.requireNonNull(startDirectory, "startDirectory");
        try {
            this.handleStart(startDirectory, results2);
            this.walk(startDirectory, 0, results2);
            this.handleEnd(results2);
        }
        catch (CancelException cancel) {
            this.handleCancelled(startDirectory, results2, cancel);
        }
    }

    private void walk(File directory, int depth, Collection<T> results2) throws IOException {
        this.checkIfCancelled(directory, depth, results2);
        if (this.handleDirectory(directory, depth, results2)) {
            this.handleDirectoryStart(directory, depth, results2);
            int childDepth = depth + 1;
            if (this.depthLimit < 0 || childDepth <= this.depthLimit) {
                this.checkIfCancelled(directory, depth, results2);
                File[] childFiles = directory.listFiles(this.filter);
                childFiles = this.filterDirectoryContents(directory, depth, childFiles);
                if (childFiles == null) {
                    this.handleRestricted(directory, childDepth, results2);
                } else {
                    for (File childFile : childFiles) {
                        if (childFile.isDirectory()) {
                            this.walk(childFile, childDepth, results2);
                            continue;
                        }
                        this.checkIfCancelled(childFile, childDepth, results2);
                        this.handleFile(childFile, childDepth, results2);
                        this.checkIfCancelled(childFile, childDepth, results2);
                    }
                }
            }
            this.handleDirectoryEnd(directory, depth, results2);
        }
        this.checkIfCancelled(directory, depth, results2);
    }

    public static class CancelException
    extends IOException {
        private static final long serialVersionUID = 1347339620135041008L;
        private final File file;
        private final int depth;

        public CancelException(File file2, int depth) {
            this("Operation Cancelled", file2, depth);
        }

        public CancelException(String message, File file2, int depth) {
            super(message);
            this.file = file2;
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }

        public File getFile() {
            return this.file;
        }
    }
}

