/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.time.Instant;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.io.ThreadUtils;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.CleaningPathVisitor;
import org.apache.commons.io.file.CopyDirectoryVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.apache.commons.io.file.DirectoryStreamFilter;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.file.attribute.FileTimes;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOSupplier;

public final class PathUtils {
    private static final OpenOption[] OPEN_OPTIONS_TRUNCATE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] OPEN_OPTIONS_APPEND = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileAttribute<?>[] EMPTY_FILE_ATTRIBUTE_ARRAY = new FileAttribute[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    @Deprecated
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    static final LinkOption NULL_LINK_OPTION = null;
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];

    private static AccumulatorPathVisitor accumulate(Path directory, int maxDepth, FileVisitOption[] fileVisitOptions) throws IOException {
        return PathUtils.visitFileTree(((AccumulatorPathVisitor.Builder)AccumulatorPathVisitor.builder().setDirectoryPostTransformer(PathUtils::stripTrailingSeparator)).get(), directory, PathUtils.toFileVisitOptionSet(fileVisitOptions), maxDepth);
    }

    public static Counters.PathCounters cleanDirectory(Path directory) throws IOException {
        return PathUtils.cleanDirectory(directory, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters cleanDirectory(Path directory, DeleteOption ... deleteOptions) throws IOException {
        return PathUtils.visitFileTree(new CleaningPathVisitor(Counters.longPathCounters(), deleteOptions, new String[0]), directory).getPathCounters();
    }

    private static int compareLastModifiedTimeTo(Path file2, FileTime fileTime, LinkOption ... options2) throws IOException {
        return PathUtils.getLastModifiedTime(file2, options2).compareTo(fileTime);
    }

    public static boolean contentEquals(FileSystem fileSystem1, FileSystem fileSystem2) throws IOException {
        if (Objects.equals(fileSystem1, fileSystem2)) {
            return true;
        }
        List<Path> sortedList1 = PathUtils.toSortedList(fileSystem1.getRootDirectories());
        List<Path> sortedList2 = PathUtils.toSortedList(fileSystem2.getRootDirectories());
        if (sortedList1.size() != sortedList2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < sortedList1.size(); ++i2) {
            if (PathUtils.directoryAndFileContentEquals(sortedList1.get(i2), sortedList2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static long copy(IOSupplier<InputStream> in, Path target, CopyOption ... copyOptions) throws IOException {
        try (InputStream inputStream2 = in.get();){
            long l = Files.copy(inputStream2, target, copyOptions);
            return l;
        }
    }

    public static Counters.PathCounters copyDirectory(Path sourceDirectory, Path targetDirectory, CopyOption ... copyOptions) throws IOException {
        Path absoluteSource = sourceDirectory.toAbsolutePath();
        return PathUtils.visitFileTree(new CopyDirectoryVisitor(Counters.longPathCounters(), absoluteSource, targetDirectory, copyOptions), absoluteSource).getPathCounters();
    }

    public static Path copyFile(URL sourceFile, Path targetFile, CopyOption ... copyOptions) throws IOException {
        PathUtils.copy(sourceFile::openStream, targetFile, copyOptions);
        return targetFile;
    }

    public static Path copyFileToDirectory(Path sourceFile, Path targetDirectory, CopyOption ... copyOptions) throws IOException {
        Path sourceFileName = Objects.requireNonNull(sourceFile.getFileName(), "source file name");
        Path targetFile = PathUtils.resolve(targetDirectory, sourceFileName);
        return Files.copy(sourceFile, targetFile, copyOptions);
    }

    public static Path copyFileToDirectory(URL sourceFile, Path targetDirectory, CopyOption ... copyOptions) throws IOException {
        Path resolve2 = targetDirectory.resolve(FilenameUtils.getName(sourceFile.getFile()));
        PathUtils.copy(sourceFile::openStream, resolve2, copyOptions);
        return resolve2;
    }

    public static Counters.PathCounters countDirectory(Path directory) throws IOException {
        return PathUtils.visitFileTree(CountingPathVisitor.withLongCounters(), directory).getPathCounters();
    }

    public static Counters.PathCounters countDirectoryAsBigInteger(Path directory) throws IOException {
        return PathUtils.visitFileTree(CountingPathVisitor.withBigIntegerCounters(), directory).getPathCounters();
    }

    public static Path createParentDirectories(Path path2, FileAttribute<?> ... attrs) throws IOException {
        return PathUtils.createParentDirectories(path2, LinkOption.NOFOLLOW_LINKS, attrs);
    }

    public static Path createParentDirectories(Path path2, LinkOption linkOption, FileAttribute<?> ... attrs) throws IOException {
        Path parent = PathUtils.getParent(path2);
        Path path3 = parent = linkOption == LinkOption.NOFOLLOW_LINKS ? parent : PathUtils.readIfSymbolicLink(parent);
        if (parent == null) {
            return null;
        }
        boolean exists = linkOption == null ? Files.exists(parent, new LinkOption[0]) : Files.exists(parent, linkOption);
        return exists ? parent : Files.createDirectories(parent, attrs);
    }

    public static Path current() {
        return Paths.get(".", new String[0]);
    }

    public static Counters.PathCounters delete(Path path2) throws IOException {
        return PathUtils.delete(path2, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters delete(Path path2, DeleteOption ... deleteOptions) throws IOException {
        return Files.isDirectory(path2, LinkOption.NOFOLLOW_LINKS) ? PathUtils.deleteDirectory(path2, deleteOptions) : PathUtils.deleteFile(path2, deleteOptions);
    }

    public static Counters.PathCounters delete(Path path2, LinkOption[] linkOptions, DeleteOption ... deleteOptions) throws IOException {
        return Files.isDirectory(path2, linkOptions) ? PathUtils.deleteDirectory(path2, linkOptions, deleteOptions) : PathUtils.deleteFile(path2, linkOptions, deleteOptions);
    }

    public static Counters.PathCounters deleteDirectory(Path directory) throws IOException {
        return PathUtils.deleteDirectory(directory, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters deleteDirectory(Path directory, DeleteOption ... deleteOptions) throws IOException {
        LinkOption[] linkOptions = PathUtils.noFollowLinkOptionArray();
        return PathUtils.withPosixFileAttributes(PathUtils.getParent(directory), linkOptions, PathUtils.overrideReadOnly(deleteOptions), pfa -> PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptions, deleteOptions, new String[0]), directory).getPathCounters());
    }

    public static Counters.PathCounters deleteDirectory(Path directory, LinkOption[] linkOptions, DeleteOption ... deleteOptions) throws IOException {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptions, deleteOptions, new String[0]), directory).getPathCounters();
    }

    public static Counters.PathCounters deleteFile(Path file2) throws IOException {
        return PathUtils.deleteFile(file2, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters deleteFile(Path file2, DeleteOption ... deleteOptions) throws IOException {
        return PathUtils.deleteFile(file2, PathUtils.noFollowLinkOptionArray(), deleteOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counters.PathCounters deleteFile(Path file2, LinkOption[] linkOptions, DeleteOption ... deleteOptions) throws NoSuchFileException, IOException {
        if (Files.isDirectory(file2, linkOptions)) {
            throw new NoSuchFileException(file2.toString());
        }
        Counters.PathCounters pathCounts = Counters.longPathCounters();
        boolean exists = PathUtils.exists(file2, linkOptions);
        long size2 = exists && !Files.isSymbolicLink(file2) ? Files.size(file2) : 0L;
        try {
            if (Files.deleteIfExists(file2)) {
                pathCounts.getFileCounter().increment();
                pathCounts.getByteCounter().add(size2);
                return pathCounts;
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        Path parent = PathUtils.getParent(file2);
        PosixFileAttributes posixFileAttributes = null;
        try {
            if (PathUtils.overrideReadOnly(deleteOptions)) {
                posixFileAttributes = PathUtils.readPosixFileAttributes(parent, linkOptions);
                PathUtils.setReadOnly(file2, false, linkOptions);
            }
            long l = size2 = (exists = PathUtils.exists(file2, linkOptions)) && !Files.isSymbolicLink(file2) ? Files.size(file2) : 0L;
            if (Files.deleteIfExists(file2)) {
                pathCounts.getFileCounter().increment();
                pathCounts.getByteCounter().add(size2);
            }
        }
        finally {
            if (posixFileAttributes != null) {
                Files.setPosixFilePermissions(parent, posixFileAttributes.permissions());
            }
        }
        return pathCounts;
    }

    public static void deleteOnExit(Path path2) {
        Objects.requireNonNull(path2).toFile().deleteOnExit();
    }

    public static boolean directoryAndFileContentEquals(Path path1, Path path2) throws IOException {
        return PathUtils.directoryAndFileContentEquals(path1, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryAndFileContentEquals(Path path1, Path path2, LinkOption[] linkOptions, OpenOption[] openOptions, FileVisitOption[] fileVisitOption) throws IOException {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (PathUtils.notExists(path1, new LinkOption[0]) && PathUtils.notExists(path2, new LinkOption[0])) {
            return true;
        }
        RelativeSortedPaths relativeSortedPaths = new RelativeSortedPaths(path1, path2, Integer.MAX_VALUE, linkOptions, fileVisitOption);
        if (!relativeSortedPaths.equals) {
            return false;
        }
        List<Path> fileList1 = relativeSortedPaths.relativeFileList1;
        List<Path> fileList2 = relativeSortedPaths.relativeFileList2;
        boolean sameFileSystem = PathUtils.isSameFileSystem(path1, path2);
        for (Path path3 : fileList1) {
            int binarySearch;
            int n = binarySearch = sameFileSystem ? Collections.binarySearch(fileList2, path3) : Collections.binarySearch(fileList2, path3, Comparator.comparing(p -> RelativeSortedPaths.extractKey(p.getFileSystem().getSeparator(), p.toString())));
            if (binarySearch < 0) {
                throw new IllegalStateException("Unexpected mismatch.");
            }
            if (sameFileSystem && !PathUtils.fileContentEquals(path1.resolve(path3), path2.resolve(path3), linkOptions, openOptions)) {
                return false;
            }
            if (PathUtils.fileContentEquals(path1.resolve(path3.toString()), path2.resolve(path3.toString()), linkOptions, openOptions)) continue;
            return false;
        }
        return true;
    }

    public static boolean directoryContentEquals(Path path1, Path path2) throws IOException {
        return PathUtils.directoryContentEquals(path1, path2, Integer.MAX_VALUE, EMPTY_LINK_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryContentEquals(Path path1, Path path2, int maxDepth, LinkOption[] linkOptions, FileVisitOption[] fileVisitOptions) throws IOException {
        return new RelativeSortedPaths((Path)path1, (Path)path2, (int)maxDepth, (LinkOption[])linkOptions, (FileVisitOption[])fileVisitOptions).equals;
    }

    private static boolean exists(Path path2, LinkOption ... options2) {
        return path2 != null && (options2 != null ? Files.exists(path2, options2) : Files.exists(path2, new LinkOption[0]));
    }

    public static boolean fileContentEquals(Path path1, Path path2) throws IOException {
        return PathUtils.fileContentEquals(path1, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean fileContentEquals(Path path1, Path path2, LinkOption[] linkOptions, OpenOption[] openOptions) throws IOException {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        Path nPath1 = path1.normalize();
        Path nPath2 = path2.normalize();
        boolean path1Exists = PathUtils.exists(nPath1, linkOptions);
        if (path1Exists != PathUtils.exists(nPath2, linkOptions)) {
            return false;
        }
        if (!path1Exists) {
            return true;
        }
        if (Files.isDirectory(nPath1, linkOptions)) {
            throw new IOException("Can't compare directories, only files: " + nPath1);
        }
        if (Files.isDirectory(nPath2, linkOptions)) {
            throw new IOException("Can't compare directories, only files: " + nPath2);
        }
        if (Files.size(nPath1) != Files.size(nPath2)) {
            return false;
        }
        if (PathUtils.isSameFileSystem(path1, path2) && path1.equals(path2)) {
            return true;
        }
        try (RandomAccessFile raf1 = RandomAccessFileMode.READ_ONLY.create(path1.toRealPath(linkOptions));){
            boolean bl;
            block34: {
                RandomAccessFile raf2 = RandomAccessFileMode.READ_ONLY.create(path2.toRealPath(linkOptions));
                try {
                    bl = RandomAccessFiles.contentEquals(raf1, raf2);
                    if (raf2 == null) break block34;
                }
                catch (Throwable throwable) {
                    if (raf2 != null) {
                        try {
                            raf2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                raf2.close();
            }
            return bl;
        }
        catch (UnsupportedOperationException e2) {
            try (InputStream inputStream1 = Files.newInputStream(nPath1, openOptions);){
                boolean bl;
                block35: {
                    InputStream inputStream2 = Files.newInputStream(nPath2, openOptions);
                    try {
                        bl = IOUtils.contentEquals(inputStream1, inputStream2);
                        if (inputStream2 == null) break block35;
                    }
                    catch (Throwable throwable) {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    inputStream2.close();
                }
                return bl;
            }
        }
    }

    public static Path[] filter(PathFilter filter2, Path ... paths) {
        Objects.requireNonNull(filter2, "filter");
        if (paths == null) {
            return EMPTY_PATH_ARRAY;
        }
        return PathUtils.filterPaths(filter2, Stream.of(paths), Collectors.toList()).toArray(EMPTY_PATH_ARRAY);
    }

    private static <R, A> R filterPaths(PathFilter filter2, Stream<Path> stream, Collector<? super Path, A, R> collector2) {
        Objects.requireNonNull(filter2, "filter");
        Objects.requireNonNull(collector2, "collector");
        if (stream == null) {
            return Stream.empty().collect(collector2);
        }
        return stream.filter(p -> {
            try {
                return p != null && filter2.accept((Path)p, PathUtils.readBasicFileAttributes(p)) == FileVisitResult.CONTINUE;
            }
            catch (IOException e2) {
                return false;
            }
        }).collect(collector2);
    }

    public static List<AclEntry> getAclEntryList(Path sourcePath) throws IOException {
        AclFileAttributeView fileAttributeView = PathUtils.getAclFileAttributeView(sourcePath, new LinkOption[0]);
        return fileAttributeView == null ? null : fileAttributeView.getAcl();
    }

    public static AclFileAttributeView getAclFileAttributeView(Path path2, LinkOption ... options2) {
        return Files.getFileAttributeView(path2, AclFileAttributeView.class, options2);
    }

    public static String getBaseName(Path path2) {
        if (path2 == null) {
            return null;
        }
        Path fileName = path2.getFileName();
        return fileName != null ? FilenameUtils.removeExtension(fileName.toString()) : null;
    }

    public static DosFileAttributeView getDosFileAttributeView(Path path2, LinkOption ... options2) {
        return Files.getFileAttributeView(path2, DosFileAttributeView.class, options2);
    }

    public static String getExtension(Path path2) {
        String fileName = PathUtils.getFileNameString(path2);
        return fileName != null ? FilenameUtils.getExtension(fileName) : null;
    }

    public static <R> R getFileName(Path path2, Function<Path, R> function) {
        Path fileName = path2 != null ? path2.getFileName() : null;
        return fileName != null ? (R)function.apply(fileName) : null;
    }

    public static String getFileNameString(Path path2) {
        return PathUtils.getFileName(path2, Path::toString);
    }

    public static FileTime getLastModifiedFileTime(File file2) throws IOException {
        return PathUtils.getLastModifiedFileTime(file2.toPath(), null, EMPTY_LINK_OPTION_ARRAY);
    }

    public static FileTime getLastModifiedFileTime(Path path2, FileTime defaultIfAbsent, LinkOption ... options2) throws IOException {
        return Files.exists(path2, new LinkOption[0]) ? PathUtils.getLastModifiedTime(path2, options2) : defaultIfAbsent;
    }

    public static FileTime getLastModifiedFileTime(Path path2, LinkOption ... options2) throws IOException {
        return PathUtils.getLastModifiedFileTime(path2, null, options2);
    }

    public static FileTime getLastModifiedFileTime(URI uri2) throws IOException {
        return PathUtils.getLastModifiedFileTime(Paths.get(uri2), null, EMPTY_LINK_OPTION_ARRAY);
    }

    public static FileTime getLastModifiedFileTime(URL url2) throws IOException, URISyntaxException {
        return PathUtils.getLastModifiedFileTime(url2.toURI());
    }

    private static FileTime getLastModifiedTime(Path path2, LinkOption ... options2) throws IOException {
        return Files.getLastModifiedTime(Objects.requireNonNull(path2, "path"), options2);
    }

    private static Path getParent(Path path2) {
        return path2 == null ? null : path2.getParent();
    }

    public static PosixFileAttributeView getPosixFileAttributeView(Path path2, LinkOption ... options2) {
        return Files.getFileAttributeView(path2, PosixFileAttributeView.class, options2);
    }

    public static Path getTempDirectory() {
        return Paths.get(FileUtils.getTempDirectoryPath(), new String[0]);
    }

    public static boolean isDirectory(Path path2, LinkOption ... options2) {
        return path2 != null && Files.isDirectory(path2, options2);
    }

    public static boolean isEmpty(Path path2) throws IOException {
        return Files.isDirectory(path2, new LinkOption[0]) ? PathUtils.isEmptyDirectory(path2) : PathUtils.isEmptyFile(path2);
    }

    public static boolean isEmptyDirectory(Path directory) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            boolean bl = !directoryStream.iterator().hasNext();
            return bl;
        }
    }

    public static boolean isEmptyFile(Path file2) throws IOException {
        return Files.size(file2) <= 0L;
    }

    public static boolean isNewer(Path file2, ChronoZonedDateTime<?> czdt, LinkOption ... options2) throws IOException {
        Objects.requireNonNull(czdt, "czdt");
        return PathUtils.isNewer(file2, czdt.toInstant(), options2);
    }

    public static boolean isNewer(Path file2, FileTime fileTime, LinkOption ... options2) throws IOException {
        if (PathUtils.notExists(file2, new LinkOption[0])) {
            return false;
        }
        return PathUtils.compareLastModifiedTimeTo(file2, fileTime, options2) > 0;
    }

    public static boolean isNewer(Path file2, Instant instant, LinkOption ... options2) throws IOException {
        return PathUtils.isNewer(file2, FileTime.from(instant), options2);
    }

    public static boolean isNewer(Path file2, long timeMillis, LinkOption ... options2) throws IOException {
        return PathUtils.isNewer(file2, FileTime.fromMillis(timeMillis), options2);
    }

    public static boolean isNewer(Path file2, Path reference) throws IOException {
        return PathUtils.isNewer(file2, PathUtils.getLastModifiedTime(reference, new LinkOption[0]), new LinkOption[0]);
    }

    public static boolean isOlder(Path file2, FileTime fileTime, LinkOption ... options2) throws IOException {
        if (PathUtils.notExists(file2, new LinkOption[0])) {
            return false;
        }
        return PathUtils.compareLastModifiedTimeTo(file2, fileTime, options2) < 0;
    }

    public static boolean isOlder(Path file2, Instant instant, LinkOption ... options2) throws IOException {
        return PathUtils.isOlder(file2, FileTime.from(instant), options2);
    }

    public static boolean isOlder(Path file2, long timeMillis, LinkOption ... options2) throws IOException {
        return PathUtils.isOlder(file2, FileTime.fromMillis(timeMillis), options2);
    }

    public static boolean isOlder(Path file2, Path reference) throws IOException {
        return PathUtils.isOlder(file2, PathUtils.getLastModifiedTime(reference, new LinkOption[0]), new LinkOption[0]);
    }

    public static boolean isPosix(Path test, LinkOption ... options2) {
        return PathUtils.exists(test, options2) && PathUtils.readPosixFileAttributes(test, options2) != null;
    }

    public static boolean isRegularFile(Path path2, LinkOption ... options2) {
        return path2 != null && Files.isRegularFile(path2, options2);
    }

    static boolean isSameFileSystem(Path path1, Path path2) {
        return path1.getFileSystem() == path2.getFileSystem();
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, PathFilter pathFilter) throws IOException {
        return Files.newDirectoryStream(dir, new DirectoryStreamFilter(pathFilter));
    }

    public static OutputStream newOutputStream(Path path2, boolean append2) throws IOException {
        return PathUtils.newOutputStream(path2, EMPTY_LINK_OPTION_ARRAY, append2 ? OPEN_OPTIONS_APPEND : OPEN_OPTIONS_TRUNCATE);
    }

    static OutputStream newOutputStream(Path path2, LinkOption[] linkOptions, OpenOption ... openOptions) throws IOException {
        if (!PathUtils.exists(path2, linkOptions)) {
            PathUtils.createParentDirectories(path2, linkOptions != null && linkOptions.length > 0 ? linkOptions[0] : NULL_LINK_OPTION, new FileAttribute[0]);
        }
        ArrayList<OpenOption> list = new ArrayList<OpenOption>(Arrays.asList(openOptions != null ? openOptions : EMPTY_OPEN_OPTION_ARRAY));
        list.addAll(Arrays.asList(linkOptions != null ? linkOptions : EMPTY_LINK_OPTION_ARRAY));
        return Files.newOutputStream(path2, list.toArray(EMPTY_OPEN_OPTION_ARRAY));
    }

    public static LinkOption[] noFollowLinkOptionArray() {
        return (LinkOption[])NOFOLLOW_LINK_OPTION_ARRAY.clone();
    }

    private static boolean notExists(Path path2, LinkOption ... options2) {
        return Files.notExists(Objects.requireNonNull(path2, "path"), options2);
    }

    private static boolean overrideReadOnly(DeleteOption ... deleteOptions) {
        if (deleteOptions == null) {
            return false;
        }
        return Stream.of(deleteOptions).anyMatch(e2 -> e2 == StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path2, Class<A> type2, LinkOption ... options2) {
        try {
            return path2 == null ? null : (A)Files.readAttributes(path2, type2, options2);
        }
        catch (IOException | UnsupportedOperationException e2) {
            return null;
        }
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path2) throws IOException {
        return Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path2, LinkOption ... options2) {
        return PathUtils.readAttributes(path2, BasicFileAttributes.class, options2);
    }

    @Deprecated
    public static BasicFileAttributes readBasicFileAttributesUnchecked(Path path2) {
        return PathUtils.readBasicFileAttributes(path2, EMPTY_LINK_OPTION_ARRAY);
    }

    public static DosFileAttributes readDosFileAttributes(Path path2, LinkOption ... options2) {
        return PathUtils.readAttributes(path2, DosFileAttributes.class, options2);
    }

    private static Path readIfSymbolicLink(Path path2) throws IOException {
        return path2 != null ? (Files.isSymbolicLink(path2) ? Files.readSymbolicLink(path2) : path2) : null;
    }

    public static BasicFileAttributes readOsFileAttributes(Path path2, LinkOption ... options2) {
        PosixFileAttributes fileAttributes = PathUtils.readPosixFileAttributes(path2, options2);
        return fileAttributes != null ? fileAttributes : PathUtils.readDosFileAttributes(path2, options2);
    }

    public static PosixFileAttributes readPosixFileAttributes(Path path2, LinkOption ... options2) {
        return PathUtils.readAttributes(path2, PosixFileAttributes.class, options2);
    }

    public static String readString(Path path2, Charset charset) throws IOException {
        return new String(Files.readAllBytes(path2), Charsets.toCharset(charset));
    }

    static List<Path> relativize(Collection<Path> collection, Path parent, boolean sort2, Comparator<? super Path> comparator) {
        Stream<Path> stream = collection.stream().map(parent::relativize);
        if (sort2) {
            stream = comparator == null ? stream.sorted() : stream.sorted(comparator);
        }
        return stream.collect(Collectors.toList());
    }

    private static Path requireExists(Path file2, String fileParamName, LinkOption ... options2) {
        Objects.requireNonNull(file2, fileParamName);
        if (!PathUtils.exists(file2, options2)) {
            throw new IllegalArgumentException("File system element for parameter '" + fileParamName + "' does not exist: '" + file2 + "'");
        }
        return file2;
    }

    static Path resolve(Path targetDirectory, Path otherPath) {
        FileSystem fileSystemSource;
        FileSystem fileSystemTarget = targetDirectory.getFileSystem();
        if (fileSystemTarget == (fileSystemSource = otherPath.getFileSystem())) {
            return targetDirectory.resolve(otherPath);
        }
        String separatorSource = fileSystemSource.getSeparator();
        String separatorTarget = fileSystemTarget.getSeparator();
        String otherString = otherPath.toString();
        return targetDirectory.resolve(Objects.equals(separatorSource, separatorTarget) ? otherString : otherString.replace(separatorSource, separatorTarget));
    }

    private static boolean setDosReadOnly(Path path2, boolean readOnly, LinkOption ... linkOptions) throws IOException {
        DosFileAttributeView dosFileAttributeView = PathUtils.getDosFileAttributeView(path2, linkOptions);
        if (dosFileAttributeView != null) {
            dosFileAttributeView.setReadOnly(readOnly);
            return true;
        }
        return false;
    }

    public static void setLastModifiedTime(Path sourceFile, Path targetFile) throws IOException {
        Objects.requireNonNull(sourceFile, "sourceFile");
        Files.setLastModifiedTime(targetFile, PathUtils.getLastModifiedTime(sourceFile, new LinkOption[0]));
    }

    private static boolean setPosixDeletePermissions(Path parent, boolean enableDeleteChildren, LinkOption ... linkOptions) throws IOException {
        return PathUtils.setPosixPermissions(parent, enableDeleteChildren, Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), linkOptions);
    }

    private static boolean setPosixPermissions(Path path2, boolean addPermissions, List<PosixFilePermission> updatePermissions, LinkOption ... linkOptions) throws IOException {
        if (path2 != null) {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path2, linkOptions);
            HashSet<PosixFilePermission> newPermissions = new HashSet<PosixFilePermission>(permissions);
            if (addPermissions) {
                newPermissions.addAll(updatePermissions);
            } else {
                newPermissions.removeAll(updatePermissions);
            }
            if (!newPermissions.equals(permissions)) {
                Files.setPosixFilePermissions(path2, newPermissions);
            }
            return true;
        }
        return false;
    }

    private static void setPosixReadOnlyFile(Path path2, boolean readOnly, LinkOption ... linkOptions) throws IOException {
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path2, linkOptions);
        List<PosixFilePermission> readPermissions = Arrays.asList(PosixFilePermission.OWNER_READ);
        List<PosixFilePermission> writePermissions = Arrays.asList(PosixFilePermission.OWNER_WRITE);
        if (readOnly) {
            permissions.addAll(readPermissions);
            permissions.removeAll(writePermissions);
        } else {
            permissions.addAll(readPermissions);
            permissions.addAll(writePermissions);
        }
        Files.setPosixFilePermissions(path2, permissions);
    }

    public static Path setReadOnly(Path path2, boolean readOnly, LinkOption ... linkOptions) throws IOException {
        try {
            if (PathUtils.setDosReadOnly(path2, readOnly, linkOptions)) {
                return path2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path parent = PathUtils.getParent(path2);
        if (!PathUtils.isPosix(parent, linkOptions)) {
            throw new IOException(String.format("DOS or POSIX file operations not available for '%s', linkOptions %s", path2, Arrays.toString(linkOptions)));
        }
        if (readOnly) {
            PathUtils.setPosixReadOnlyFile(path2, readOnly, linkOptions);
            PathUtils.setPosixDeletePermissions(parent, false, linkOptions);
        } else {
            PathUtils.setPosixDeletePermissions(parent, true, linkOptions);
        }
        return path2;
    }

    public static long sizeOf(Path path2) throws IOException {
        PathUtils.requireExists(path2, "path", new LinkOption[0]);
        return Files.isDirectory(path2, new LinkOption[0]) ? PathUtils.sizeOfDirectory(path2) : Files.size(path2);
    }

    public static BigInteger sizeOfAsBigInteger(Path path2) throws IOException {
        PathUtils.requireExists(path2, "path", new LinkOption[0]);
        return Files.isDirectory(path2, new LinkOption[0]) ? PathUtils.sizeOfDirectoryAsBigInteger(path2) : BigInteger.valueOf(Files.size(path2));
    }

    public static long sizeOfDirectory(Path directory) throws IOException {
        return PathUtils.countDirectory(directory).getByteCounter().getLong();
    }

    public static BigInteger sizeOfDirectoryAsBigInteger(Path directory) throws IOException {
        return PathUtils.countDirectoryAsBigInteger(directory).getByteCounter().getBigInteger();
    }

    private static Path stripTrailingSeparator(Path dir) {
        String separator = dir.getFileSystem().getSeparator();
        String fileName = PathUtils.getFileNameString(dir);
        return fileName != null && fileName.endsWith(separator) ? dir.resolveSibling(fileName.substring(0, fileName.length() - 1)) : dir;
    }

    static Set<FileVisitOption> toFileVisitOptionSet(FileVisitOption ... fileVisitOptions) {
        return fileVisitOptions == null ? EnumSet.noneOf(FileVisitOption.class) : Stream.of(fileVisitOptions).collect(Collectors.toSet());
    }

    private static <T> List<T> toList(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    private static List<Path> toSortedList(Iterable<Path> rootDirectories) {
        List<Path> list = PathUtils.toList(rootDirectories);
        Collections.sort(list);
        return list;
    }

    public static Path touch(Path file2) throws IOException {
        Objects.requireNonNull(file2, "file");
        if (!Files.exists(file2, new LinkOption[0])) {
            PathUtils.createParentDirectories(file2, new FileAttribute[0]);
            Files.createFile(file2, new FileAttribute[0]);
        } else {
            FileTimes.setLastModifiedTime(file2);
        }
        return file2;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor2, Path directory) throws IOException {
        Files.walkFileTree(directory, visitor2);
        return visitor2;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor2, Path start2, Set<FileVisitOption> options2, int maxDepth) throws IOException {
        Files.walkFileTree(start2, options2, maxDepth, visitor2);
        return visitor2;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor2, String first2, String ... more) throws IOException {
        return PathUtils.visitFileTree(visitor2, Paths.get(first2, more));
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor2, URI uri2) throws IOException {
        return PathUtils.visitFileTree(visitor2, Paths.get(uri2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitFor(Path file2, Duration timeout2, LinkOption ... options2) {
        Objects.requireNonNull(file2, "file");
        Instant finishInstant = Instant.now().plus(timeout2);
        boolean interrupted = false;
        long minSleepMillis = 100L;
        try {
            while (!PathUtils.exists(file2, options2)) {
                Instant now = Instant.now();
                if (now.isAfter(finishInstant)) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    ThreadUtils.sleep(Duration.ofMillis(Math.min(100L, finishInstant.minusMillis(now.toEpochMilli()).toEpochMilli())));
                }
                catch (InterruptedException ignore) {
                    interrupted = true;
                }
                catch (Exception ex) {
                    break;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return PathUtils.exists(file2, options2);
    }

    public static Stream<Path> walk(Path start2, PathFilter pathFilter, int maxDepth, boolean readAttributes, FileVisitOption ... options2) throws IOException {
        return Files.walk(start2, maxDepth, options2).filter(path2 -> pathFilter.accept((Path)path2, readAttributes ? PathUtils.readBasicFileAttributesUnchecked(path2) : null) == FileVisitResult.CONTINUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> R withPosixFileAttributes(Path path2, LinkOption[] linkOptions, boolean overrideReadOnly, IOFunction<PosixFileAttributes, R> function) throws IOException {
        PosixFileAttributes posixFileAttributes = overrideReadOnly ? PathUtils.readPosixFileAttributes(path2, linkOptions) : null;
        try {
            R r = function.apply(posixFileAttributes);
            return r;
        }
        finally {
            if (posixFileAttributes != null && path2 != null && Files.exists(path2, linkOptions)) {
                Files.setPosixFilePermissions(path2, posixFileAttributes.permissions());
            }
        }
    }

    public static Path writeString(Path path2, CharSequence charSequence, Charset charset, OpenOption ... openOptions) throws IOException {
        Objects.requireNonNull(path2, "path");
        Objects.requireNonNull(charSequence, "charSequence");
        Files.write(path2, String.valueOf(charSequence).getBytes(Charsets.toCharset(charset)), openOptions);
        return path2;
    }

    private PathUtils() {
    }

    private static final class RelativeSortedPaths {
        final boolean equals;
        final List<Path> relativeFileList1;
        final List<Path> relativeFileList2;

        private static boolean equalsIgnoreFileSystem(List<Path> list1, List<Path> list2) {
            if (list1.size() != list2.size()) {
                return false;
            }
            Iterator<Path> iterator1 = list1.iterator();
            Iterator<Path> iterator2 = list2.iterator();
            while (iterator1.hasNext() && iterator2.hasNext()) {
                if (RelativeSortedPaths.equalsIgnoreFileSystem(iterator1.next(), iterator2.next())) continue;
                return false;
            }
            return true;
        }

        private static boolean equalsIgnoreFileSystem(Path path1, Path path2) {
            FileSystem fileSystem2;
            FileSystem fileSystem1 = path1.getFileSystem();
            if (fileSystem1 == (fileSystem2 = path2.getFileSystem())) {
                return path1.equals(path2);
            }
            String separator1 = fileSystem1.getSeparator();
            String separator2 = fileSystem2.getSeparator();
            String string1 = path1.toString();
            String string2 = path2.toString();
            if (Objects.equals(separator1, separator2)) {
                return Objects.equals(string1, string2);
            }
            return RelativeSortedPaths.extractKey(separator1, string1).equals(RelativeSortedPaths.extractKey(separator2, string2));
        }

        static String extractKey(String separator, String string) {
            return string.replaceAll("\\" + separator, ">");
        }

        private RelativeSortedPaths(Path dir1, Path dir2, int maxDepth, LinkOption[] linkOptions, FileVisitOption[] fileVisitOptions) throws IOException {
            List<Path> tmpRelativeFileList1 = null;
            List<Path> tmpRelativeFileList2 = null;
            if (dir1 == null && dir2 == null) {
                this.equals = true;
            } else if (dir1 == null ^ dir2 == null) {
                this.equals = false;
            } else {
                boolean parentDirNotExists1 = Files.notExists(dir1, linkOptions);
                boolean parentDirNotExists2 = Files.notExists(dir2, linkOptions);
                if (parentDirNotExists1 || parentDirNotExists2) {
                    this.equals = parentDirNotExists1 && parentDirNotExists2;
                } else {
                    AccumulatorPathVisitor visitor1 = PathUtils.accumulate(dir1, maxDepth, fileVisitOptions);
                    AccumulatorPathVisitor visitor2 = PathUtils.accumulate(dir2, maxDepth, fileVisitOptions);
                    if (visitor1.getDirList().size() != visitor2.getDirList().size() || visitor1.getFileList().size() != visitor2.getFileList().size()) {
                        this.equals = false;
                    } else {
                        List<Path> tmpRelativeDirList2;
                        List<Path> tmpRelativeDirList1 = visitor1.relativizeDirectories(dir1, true, null);
                        if (!RelativeSortedPaths.equalsIgnoreFileSystem(tmpRelativeDirList1, tmpRelativeDirList2 = visitor2.relativizeDirectories(dir2, true, null))) {
                            this.equals = false;
                        } else {
                            tmpRelativeFileList1 = visitor1.relativizeFiles(dir1, true, null);
                            tmpRelativeFileList2 = visitor2.relativizeFiles(dir2, true, null);
                            this.equals = RelativeSortedPaths.equalsIgnoreFileSystem(tmpRelativeFileList1, tmpRelativeFileList2);
                        }
                    }
                }
            }
            this.relativeFileList1 = tmpRelativeFileList1;
            this.relativeFileList2 = tmpRelativeFileList2;
        }
    }
}

