/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file.spi;

import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FileSystemProviders {
    private static final String SCHEME_FILE = "file";
    private static final FileSystemProviders INSTALLED = new FileSystemProviders(FileSystemProvider.installedProviders());
    private final List<FileSystemProvider> providers;

    public static FileSystemProvider getFileSystemProvider(Path path2) {
        return Objects.requireNonNull(path2, "path").getFileSystem().provider();
    }

    public static FileSystemProviders installed() {
        return INSTALLED;
    }

    private FileSystemProviders(List<FileSystemProvider> providers) {
        this.providers = providers != null ? providers : Collections.emptyList();
    }

    public FileSystemProvider getFileSystemProvider(String scheme2) {
        Objects.requireNonNull(scheme2, "scheme");
        if (scheme2.equalsIgnoreCase(SCHEME_FILE)) {
            return FileSystems.getDefault().provider();
        }
        return this.providers.stream().filter(provider2 -> provider2.getScheme().equalsIgnoreCase(scheme2)).findFirst().orElse(null);
    }

    public FileSystemProvider getFileSystemProvider(URI uri2) {
        return this.getFileSystemProvider(Objects.requireNonNull(uri2, "uri").getScheme());
    }

    public FileSystemProvider getFileSystemProvider(URL url2) {
        return this.getFileSystemProvider(Objects.requireNonNull(url2, "url").getProtocol());
    }
}

