/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class PrefixFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 8533897440809599867L;
    private final String[] prefixes;
    private final IOCase isCase;

    public PrefixFileFilter(List<String> prefixes2) {
        this(prefixes2, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(List<String> prefixes2, IOCase ioCase) {
        Objects.requireNonNull(prefixes2, "prefixes");
        this.prefixes = prefixes2.toArray(EMPTY_STRING_ARRAY);
        this.isCase = IOCase.value(ioCase, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String prefix2) {
        this(prefix2, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String ... prefixes2) {
        this(prefixes2, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String prefix2, IOCase ioCase) {
        Objects.requireNonNull(prefix2, "prefix");
        this.prefixes = new String[]{prefix2};
        this.isCase = IOCase.value(ioCase, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String[] prefixes2, IOCase ioCase) {
        Objects.requireNonNull(prefixes2, "prefixes");
        this.prefixes = (String[])prefixes2.clone();
        this.isCase = IOCase.value(ioCase, IOCase.SENSITIVE);
    }

    @Override
    public boolean accept(File file2) {
        return this.accept(file2 == null ? null : file2.getName());
    }

    @Override
    public boolean accept(File file2, String name) {
        return this.accept(name);
    }

    @Override
    public FileVisitResult accept(Path file2, BasicFileAttributes attributes2) {
        return this.toFileVisitResult(this.accept(PathUtils.getFileName(file2, Path::toFile)));
    }

    private boolean accept(String name) {
        return Stream.of(this.prefixes).anyMatch(prefix2 -> this.isCase.checkStartsWith(name, (String)prefix2));
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        this.append(this.prefixes, buffer);
        buffer.append(")");
        return buffer.toString();
    }
}

