/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.build.AbstractStreamBuilder;

public class UnsynchronizedByteArrayInputStream
extends InputStream {
    public static final int END_OF_STREAM = -1;
    private final byte[] data;
    private final int eod;
    private int offset;
    private int markedOffset;

    public static Builder builder() {
        return new Builder();
    }

    private static int minPosLen(byte[] data2, int defaultValue) {
        UnsynchronizedByteArrayInputStream.requireNonNegative(defaultValue, "defaultValue");
        return Math.min(defaultValue, data2.length > 0 ? data2.length : defaultValue);
    }

    private static int requireNonNegative(int value2, String name) {
        if (value2 < 0) {
            throw new IllegalArgumentException(name + " cannot be negative");
        }
        return value2;
    }

    @Deprecated
    public UnsynchronizedByteArrayInputStream(byte[] data2) {
        this(data2, data2.length, 0, 0);
    }

    @Deprecated
    public UnsynchronizedByteArrayInputStream(byte[] data2, int offset) {
        this(data2, data2.length, Math.min(UnsynchronizedByteArrayInputStream.requireNonNegative(offset, "offset"), UnsynchronizedByteArrayInputStream.minPosLen(data2, offset)), UnsynchronizedByteArrayInputStream.minPosLen(data2, offset));
    }

    @Deprecated
    public UnsynchronizedByteArrayInputStream(byte[] data2, int offset, int length) {
        UnsynchronizedByteArrayInputStream.requireNonNegative(offset, "offset");
        UnsynchronizedByteArrayInputStream.requireNonNegative(length, "length");
        this.data = Objects.requireNonNull(data2, "data");
        this.eod = Math.min(UnsynchronizedByteArrayInputStream.minPosLen(data2, offset) + length, data2.length);
        this.offset = UnsynchronizedByteArrayInputStream.minPosLen(data2, offset);
        this.markedOffset = UnsynchronizedByteArrayInputStream.minPosLen(data2, offset);
    }

    private UnsynchronizedByteArrayInputStream(byte[] data2, int eod, int offset, int markedOffset) {
        this.data = Objects.requireNonNull(data2, "data");
        this.eod = eod;
        this.offset = offset;
        this.markedOffset = markedOffset;
    }

    @Override
    public int available() {
        return this.offset < this.eod ? this.eod - this.offset : 0;
    }

    @Override
    public void mark(int readLimit) {
        this.markedOffset = this.offset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        return this.offset < this.eod ? this.data[this.offset++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] dest) {
        Objects.requireNonNull(dest, "dest");
        return this.read(dest, 0, dest.length);
    }

    @Override
    public int read(byte[] dest, int off, int len2) {
        Objects.requireNonNull(dest, "dest");
        if (off < 0 || len2 < 0 || off + len2 > dest.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.offset >= this.eod) {
            return -1;
        }
        int actualLen = this.eod - this.offset;
        if (len2 < actualLen) {
            actualLen = len2;
        }
        if (actualLen <= 0) {
            return 0;
        }
        System.arraycopy(this.data, this.offset, dest, off, actualLen);
        this.offset += actualLen;
        return actualLen;
    }

    @Override
    public void reset() {
        this.offset = this.markedOffset;
    }

    @Override
    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Skipping backward is not supported");
        }
        long actualSkip = this.eod - this.offset;
        if (n < actualSkip) {
            actualSkip = n;
        }
        this.offset = Math.addExact(this.offset, Math.toIntExact(n));
        return actualSkip;
    }

    public static class Builder
    extends AbstractStreamBuilder<UnsynchronizedByteArrayInputStream, Builder> {
        private int offset;
        private int length;

        @Override
        public UnsynchronizedByteArrayInputStream get() throws IOException {
            return new UnsynchronizedByteArrayInputStream(this.checkOrigin().getByteArray(), this.offset, this.length);
        }

        @Override
        public Builder setByteArray(byte[] origin2) {
            this.length = Objects.requireNonNull(origin2, "origin").length;
            return (Builder)super.setByteArray(origin2);
        }

        public Builder setLength(int length) {
            if (length < 0) {
                throw new IllegalArgumentException("length cannot be negative");
            }
            this.length = length;
            return this;
        }

        public Builder setOffset(int offset) {
            if (offset < 0) {
                throw new IllegalArgumentException("offset cannot be negative");
            }
            this.offset = offset;
            return this;
        }
    }
}

