/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;

public class ByteArrayOutputStream
extends AbstractByteArrayOutputStream<ByteArrayOutputStream> {
    public static InputStream toBufferedInputStream(InputStream input) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input, 1024);
    }

    public static InputStream toBufferedInputStream(InputStream input, int size2) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream(size2);){
            output.write(input);
            InputStream inputStream2 = output.toInputStream();
            return inputStream2;
        }
    }

    public ByteArrayOutputStream() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream(int size2) {
        if (size2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size2);
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.needNewBuffer(size2);
        }
    }

    @Override
    public synchronized void reset() {
        this.resetImpl();
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized byte[] toByteArray() {
        return this.toByteArrayImpl();
    }

    @Override
    public synchronized InputStream toInputStream() {
        return this.toInputStream(ByteArrayInputStream::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b2, int off, int len2) {
        if (off < 0 || off > b2.length || len2 < 0 || off + len2 > b2.length || off + len2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len2 == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.writeImpl(b2, off, len2);
        }
    }

    @Override
    public synchronized int write(InputStream in) throws IOException {
        return this.writeImpl(in);
    }

    @Override
    public synchronized void write(int b2) {
        this.writeImpl(b2);
    }

    @Override
    public synchronized void writeTo(OutputStream out2) throws IOException {
        this.writeToImpl(out2);
    }
}

