/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.regex.Pattern;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.serialization.ClassNameMatcher;
import org.apache.commons.io.serialization.ObjectStreamClassPredicate;

public class ValidatingObjectInputStream
extends ObjectInputStream {
    private final ObjectStreamClassPredicate predicate;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public ValidatingObjectInputStream(InputStream input) throws IOException {
        this(input, new ObjectStreamClassPredicate());
    }

    private ValidatingObjectInputStream(InputStream input, ObjectStreamClassPredicate predicate) throws IOException {
        super(input);
        this.predicate = predicate;
    }

    public ValidatingObjectInputStream accept(Class<?> ... classes) {
        this.predicate.accept(classes);
        return this;
    }

    public ValidatingObjectInputStream accept(ClassNameMatcher matcher) {
        this.predicate.accept(matcher);
        return this;
    }

    public ValidatingObjectInputStream accept(Pattern pattern2) {
        this.predicate.accept(pattern2);
        return this;
    }

    public ValidatingObjectInputStream accept(String ... patterns2) {
        this.predicate.accept(patterns2);
        return this;
    }

    private void checkClassName(String name) throws InvalidClassException {
        if (!this.predicate.test(name)) {
            this.invalidClassNameFound(name);
        }
    }

    protected void invalidClassNameFound(String className) throws InvalidClassException {
        throw new InvalidClassException("Class name not accepted: " + className);
    }

    public <T> T readObjectCast() throws ClassNotFoundException, IOException {
        return (T)super.readObject();
    }

    public ValidatingObjectInputStream reject(Class<?> ... classes) {
        this.predicate.reject(classes);
        return this;
    }

    public ValidatingObjectInputStream reject(ClassNameMatcher matcher) {
        this.predicate.reject(matcher);
        return this;
    }

    public ValidatingObjectInputStream reject(Pattern pattern2) {
        this.predicate.reject(pattern2);
        return this;
    }

    public ValidatingObjectInputStream reject(String ... patterns2) {
        this.predicate.reject(patterns2);
        return this;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        this.checkClassName(osc.getName());
        return super.resolveClass(osc);
    }

    public static class Builder
    extends AbstractStreamBuilder<ValidatingObjectInputStream, Builder> {
        private ObjectStreamClassPredicate predicate = new ObjectStreamClassPredicate();

        @Deprecated
        public Builder() {
        }

        public Builder accept(Class<?> ... classes) {
            this.predicate.accept(classes);
            return this;
        }

        public Builder accept(ClassNameMatcher matcher) {
            this.predicate.accept(matcher);
            return this;
        }

        public Builder accept(Pattern pattern2) {
            this.predicate.accept(pattern2);
            return this;
        }

        public Builder accept(String ... patterns2) {
            this.predicate.accept(patterns2);
            return this;
        }

        @Override
        public ValidatingObjectInputStream get() throws IOException {
            return new ValidatingObjectInputStream(this.getInputStream(), this.predicate);
        }

        public ObjectStreamClassPredicate getPredicate() {
            return this.predicate;
        }

        public Builder reject(Class<?> ... classes) {
            this.predicate.reject(classes);
            return this;
        }

        public Builder reject(ClassNameMatcher matcher) {
            this.predicate.reject(matcher);
            return this;
        }

        public Builder reject(Pattern pattern2) {
            this.predicate.reject(pattern2);
            return this;
        }

        public Builder reject(String ... patterns2) {
            this.predicate.reject(patterns2);
            return this;
        }

        public Builder setPredicate(ObjectStreamClassPredicate predicate) {
            this.predicate = predicate != null ? predicate : new ObjectStreamClassPredicate();
            return this;
        }
    }
}

