/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Random;
import java.util.function.Supplier;
import org.apache.commons.lang3.CachedRandomBits;
import org.apache.commons.lang3.RandomUtils;

public class RandomStringUtils {
    private static final Supplier<RandomUtils> SECURE_SUPPLIER = RandomUtils::secure;
    private static RandomStringUtils INSECURE = new RandomStringUtils(RandomUtils::insecure);
    private static RandomStringUtils SECURE = new RandomStringUtils(SECURE_SUPPLIER);
    private static RandomStringUtils SECURE_STRONG = new RandomStringUtils(RandomUtils::secureStrong);
    private static final char[] ALPHANUMERICAL_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final int ASCII_0 = 48;
    private static final int ASCII_9 = 57;
    private static final int ASCII_A = 65;
    private static final int ASCII_z = 122;
    private static final int CACHE_PADDING_BITS = 3;
    private static final int BITS_TO_BYTES_DIVISOR = 5;
    private static final int BASE_CACHE_SIZE_PADDING = 10;
    private final Supplier<RandomUtils> random;

    public static RandomStringUtils insecure() {
        return INSECURE;
    }

    @Deprecated
    public static String random(int count2) {
        return RandomStringUtils.secure().next(count2);
    }

    @Deprecated
    public static String random(int count2, boolean letters, boolean numbers) {
        return RandomStringUtils.secure().next(count2, letters, numbers);
    }

    @Deprecated
    public static String random(int count2, char ... chars) {
        return RandomStringUtils.secure().next(count2, chars);
    }

    @Deprecated
    public static String random(int count2, int start2, int end2, boolean letters, boolean numbers) {
        return RandomStringUtils.secure().next(count2, start2, end2, letters, numbers);
    }

    @Deprecated
    public static String random(int count2, int start2, int end2, boolean letters, boolean numbers, char ... chars) {
        return RandomStringUtils.secure().next(count2, start2, end2, letters, numbers, chars);
    }

    public static String random(int count2, int start2, int end2, boolean letters, boolean numbers, char[] chars, Random random2) {
        if (count2 == 0) {
            return "";
        }
        if (count2 < 0) {
            throw new IllegalArgumentException("Requested random string length " + count2 + " is less than 0.");
        }
        if (chars != null && chars.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (start2 == 0 && end2 == 0) {
            if (chars != null) {
                end2 = chars.length;
            } else if (!letters && !numbers) {
                end2 = 0x10FFFF;
            } else {
                end2 = 123;
                start2 = 32;
            }
        } else {
            if (end2 <= start2) {
                throw new IllegalArgumentException("Parameter end (" + end2 + ") must be greater than start (" + start2 + ")");
            }
            if (start2 < 0 || end2 < 0) {
                throw new IllegalArgumentException("Character positions MUST be >= 0");
            }
        }
        if (end2 > 0x10FFFF) {
            end2 = 0x10FFFF;
        }
        if (chars == null && end2 <= 127) {
            if (letters && numbers && start2 <= 48 && end2 >= 123) {
                return RandomStringUtils.random(count2, 0, 0, false, false, ALPHANUMERICAL_CHARS, random2);
            }
            if (numbers && end2 <= 48 || letters && end2 <= 65) {
                throw new IllegalArgumentException("Parameter end (" + end2 + ") must be greater then (" + 48 + ") for generating digits or greater then (" + 65 + ") for generating letters.");
            }
            if (letters && numbers) {
                start2 = Math.max(48, start2);
                end2 = Math.min(123, end2);
            } else if (numbers) {
                start2 = Math.max(48, start2);
                end2 = Math.min(58, end2);
            } else if (letters) {
                start2 = Math.max(65, start2);
                end2 = Math.min(123, end2);
            }
        }
        StringBuilder builder = new StringBuilder(count2);
        int gap = end2 - start2;
        int gapBits = 32 - Integer.numberOfLeadingZeros(gap);
        long desiredCacheSize = ((long)count2 * (long)gapBits + 3L) / 5L + 10L;
        int cacheSize = (int)Math.min(desiredCacheSize, 429496739L);
        CachedRandomBits arb = new CachedRandomBits(cacheSize, random2);
        block3: while (count2-- != 0) {
            int codePoint;
            int randomValue = arb.nextBits(gapBits) + start2;
            if (randomValue >= end2) {
                ++count2;
                continue;
            }
            if (chars == null) {
                codePoint = randomValue;
                switch (Character.getType(codePoint)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++count2;
                        continue block3;
                    }
                }
            } else {
                codePoint = chars[randomValue];
            }
            int numberOfChars = Character.charCount(codePoint);
            if (count2 == 0 && numberOfChars > 1) {
                ++count2;
                continue;
            }
            if (letters && Character.isLetter(codePoint) || numbers && Character.isDigit(codePoint) || !letters && !numbers) {
                builder.appendCodePoint(codePoint);
                if (numberOfChars != 2) continue;
                --count2;
                continue;
            }
            ++count2;
        }
        return builder.toString();
    }

    @Deprecated
    public static String random(int count2, String chars) {
        return RandomStringUtils.secure().next(count2, chars);
    }

    @Deprecated
    public static String randomAlphabetic(int count2) {
        return RandomStringUtils.secure().nextAlphabetic(count2);
    }

    @Deprecated
    public static String randomAlphabetic(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.secure().nextAlphabetic(minLengthInclusive, maxLengthExclusive);
    }

    @Deprecated
    public static String randomAlphanumeric(int count2) {
        return RandomStringUtils.secure().nextAlphanumeric(count2);
    }

    @Deprecated
    public static String randomAlphanumeric(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.secure().nextAlphanumeric(minLengthInclusive, maxLengthExclusive);
    }

    @Deprecated
    public static String randomAscii(int count2) {
        return RandomStringUtils.secure().nextAscii(count2);
    }

    @Deprecated
    public static String randomAscii(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.secure().nextAscii(minLengthInclusive, maxLengthExclusive);
    }

    @Deprecated
    public static String randomGraph(int count2) {
        return RandomStringUtils.secure().nextGraph(count2);
    }

    @Deprecated
    public static String randomGraph(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.secure().nextGraph(minLengthInclusive, maxLengthExclusive);
    }

    @Deprecated
    public static String randomNumeric(int count2) {
        return RandomStringUtils.secure().nextNumeric(count2);
    }

    @Deprecated
    public static String randomNumeric(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.secure().nextNumeric(minLengthInclusive, maxLengthExclusive);
    }

    @Deprecated
    public static String randomPrint(int count2) {
        return RandomStringUtils.secure().nextPrint(count2);
    }

    @Deprecated
    public static String randomPrint(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.secure().nextPrint(minLengthInclusive, maxLengthExclusive);
    }

    public static RandomStringUtils secure() {
        return SECURE;
    }

    public static RandomStringUtils secureStrong() {
        return SECURE_STRONG;
    }

    @Deprecated
    public RandomStringUtils() {
        this(SECURE_SUPPLIER);
    }

    private RandomStringUtils(Supplier<RandomUtils> random2) {
        this.random = random2;
    }

    public String next(int count2) {
        return this.next(count2, false, false);
    }

    public String next(int count2, boolean letters, boolean numbers) {
        return this.next(count2, 0, 0, letters, numbers);
    }

    public String next(int count2, char ... chars) {
        if (chars == null) {
            return RandomStringUtils.random(count2, 0, 0, false, false, null, this.random());
        }
        return RandomStringUtils.random(count2, 0, chars.length, false, false, chars, this.random());
    }

    public String next(int count2, int start2, int end2, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count2, start2, end2, letters, numbers, null, this.random());
    }

    public String next(int count2, int start2, int end2, boolean letters, boolean numbers, char ... chars) {
        return RandomStringUtils.random(count2, start2, end2, letters, numbers, chars, this.random());
    }

    public String next(int count2, String chars) {
        if (chars == null) {
            return RandomStringUtils.random(count2, 0, 0, false, false, null, this.random());
        }
        return this.next(count2, chars.toCharArray());
    }

    public String nextAlphabetic(int count2) {
        return this.next(count2, true, false);
    }

    public String nextAlphabetic(int minLengthInclusive, int maxLengthExclusive) {
        return this.nextAlphabetic(this.randomUtils().randomInt(minLengthInclusive, maxLengthExclusive));
    }

    public String nextAlphanumeric(int count2) {
        return this.next(count2, true, true);
    }

    public String nextAlphanumeric(int minLengthInclusive, int maxLengthExclusive) {
        return this.nextAlphanumeric(this.randomUtils().randomInt(minLengthInclusive, maxLengthExclusive));
    }

    public String nextAscii(int count2) {
        return this.next(count2, 32, 127, false, false);
    }

    public String nextAscii(int minLengthInclusive, int maxLengthExclusive) {
        return this.nextAscii(this.randomUtils().randomInt(minLengthInclusive, maxLengthExclusive));
    }

    public String nextGraph(int count2) {
        return this.next(count2, 33, 126, false, false);
    }

    public String nextGraph(int minLengthInclusive, int maxLengthExclusive) {
        return this.nextGraph(this.randomUtils().randomInt(minLengthInclusive, maxLengthExclusive));
    }

    public String nextNumeric(int count2) {
        return this.next(count2, false, true);
    }

    public String nextNumeric(int minLengthInclusive, int maxLengthExclusive) {
        return this.nextNumeric(this.randomUtils().randomInt(minLengthInclusive, maxLengthExclusive));
    }

    public String nextPrint(int count2) {
        return this.next(count2, 32, 126, false, false);
    }

    public String nextPrint(int minLengthInclusive, int maxLengthExclusive) {
        return this.nextPrint(this.randomUtils().randomInt(minLengthInclusive, maxLengthExclusive));
    }

    private Random random() {
        return this.randomUtils().random();
    }

    private RandomUtils randomUtils() {
        return this.random.get();
    }

    public String toString() {
        return "RandomStringUtils [random=" + this.random() + "]";
    }
}

