/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ConcurrentUtils {
    static Throwable checkedException(Throwable ex) {
        Validate.isTrue(ExceptionUtils.isChecked(ex), "Not a checked exception: %s", ex);
        return ex;
    }

    public static <T> Future<T> constantFuture(T value2) {
        return new ConstantFuture<T>(value2);
    }

    public static <K, V> V createIfAbsent(ConcurrentMap<K, V> map2, K key2, ConcurrentInitializer<V> init) throws ConcurrentException {
        if (map2 == null || init == null) {
            return null;
        }
        Object value2 = map2.get(key2);
        if (value2 == null) {
            return ConcurrentUtils.putIfAbsent(map2, key2, init.get());
        }
        return value2;
    }

    public static <K, V> V createIfAbsentUnchecked(ConcurrentMap<K, V> map2, K key2, ConcurrentInitializer<V> init) {
        try {
            return ConcurrentUtils.createIfAbsent(map2, key2, init);
        }
        catch (ConcurrentException cex) {
            throw new ConcurrentRuntimeException(cex.getCause());
        }
    }

    public static ConcurrentException extractCause(ExecutionException ex) {
        if (ex == null || ex.getCause() == null) {
            return null;
        }
        ExceptionUtils.throwUnchecked(ex.getCause());
        return new ConcurrentException(ex.getMessage(), ex.getCause());
    }

    public static ConcurrentRuntimeException extractCauseUnchecked(ExecutionException ex) {
        if (ex == null || ex.getCause() == null) {
            return null;
        }
        ExceptionUtils.throwUnchecked(ex.getCause());
        return new ConcurrentRuntimeException(ex.getMessage(), ex.getCause());
    }

    public static void handleCause(ExecutionException ex) throws ConcurrentException {
        ConcurrentException cause = ConcurrentUtils.extractCause(ex);
        if (cause != null) {
            throw cause;
        }
    }

    public static void handleCauseUnchecked(ExecutionException ex) {
        ConcurrentRuntimeException cause = ConcurrentUtils.extractCauseUnchecked(ex);
        if (cause != null) {
            throw cause;
        }
    }

    public static <T> T initialize(ConcurrentInitializer<T> initializer2) throws ConcurrentException {
        return initializer2 != null ? (T)initializer2.get() : null;
    }

    public static <T> T initializeUnchecked(ConcurrentInitializer<T> initializer2) {
        try {
            return ConcurrentUtils.initialize(initializer2);
        }
        catch (ConcurrentException cex) {
            throw new ConcurrentRuntimeException(cex.getCause());
        }
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> map2, K key2, V value2) {
        if (map2 == null) {
            return null;
        }
        V result2 = map2.putIfAbsent(key2, value2);
        return result2 != null ? result2 : value2;
    }

    private ConcurrentUtils() {
    }

    static final class ConstantFuture<T>
    implements Future<T> {
        private final T value;

        ConstantFuture(T value2) {
            this.value = value2;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T get(long timeout2, TimeUnit unit) {
            return this.value;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

