/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.reflect.MethodUtils;

public class EventUtils {
    public static <L> void addEventListener(Object eventSource, Class<L> listenerType, L listener) {
        try {
            MethodUtils.invokeMethod(eventSource, "add" + listenerType.getSimpleName(), listener);
        }
        catch (ReflectiveOperationException e2) {
            throw new IllegalArgumentException("Unable to add listener for class " + eventSource.getClass().getName() + " and public add" + listenerType.getSimpleName() + " method which takes a parameter of type " + listenerType.getName() + ".");
        }
    }

    public static <L> void bindEventsToMethod(Object target, String methodName, Object eventSource, Class<L> listenerType, String ... eventTypes) {
        L listener = listenerType.cast(Proxy.newProxyInstance(target.getClass().getClassLoader(), new Class[]{listenerType}, (InvocationHandler)new EventBindingInvocationHandler(target, methodName, eventTypes)));
        EventUtils.addEventListener(eventSource, listenerType, listener);
    }

    @Deprecated
    public EventUtils() {
    }

    private static final class EventBindingInvocationHandler
    implements InvocationHandler {
        private final Object target;
        private final String methodName;
        private final Set<String> eventTypes;

        EventBindingInvocationHandler(Object target, String methodName, String[] eventTypes) {
            this.target = target;
            this.methodName = methodName;
            this.eventTypes = new HashSet<String>(Arrays.asList(eventTypes));
        }

        private boolean hasMatchingParametersMethod(Method method2) {
            return MethodUtils.getAccessibleMethod(this.target.getClass(), this.methodName, method2.getParameterTypes()) != null;
        }

        @Override
        public Object invoke(Object proxy, Method method2, Object[] parameters2) throws Throwable {
            if (this.eventTypes.isEmpty() || this.eventTypes.contains(method2.getName())) {
                if (this.hasMatchingParametersMethod(method2)) {
                    return MethodUtils.invokeMethod(this.target, this.methodName, parameters2);
                }
                return MethodUtils.invokeMethod(this.target, this.methodName);
            }
            return null;
        }
    }
}

