/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.mutable.Mutable;

public class MutableBoolean
implements Mutable<Boolean>,
Serializable,
Comparable<MutableBoolean> {
    private static final long serialVersionUID = -4830728138360036487L;
    private boolean value;

    public MutableBoolean() {
    }

    public MutableBoolean(boolean value2) {
        this.value = value2;
    }

    public MutableBoolean(Boolean value2) {
        this.value = value2;
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public int compareTo(MutableBoolean other) {
        return BooleanUtils.compare(this.value, other.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableBoolean) {
            return this.value == ((MutableBoolean)obj).booleanValue();
        }
        return false;
    }

    @Override
    @Deprecated
    public Boolean getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public boolean isFalse() {
        return !this.value;
    }

    public boolean isTrue() {
        return this.value;
    }

    public void setFalse() {
        this.value = false;
    }

    public void setTrue() {
        this.value = true;
    }

    @Override
    public void setValue(boolean value2) {
        this.value = value2;
    }

    @Override
    public void setValue(Boolean value2) {
        this.value = value2;
    }

    public Boolean toBoolean() {
        return this.booleanValue();
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

