/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.FormatFactory;
import org.apache.commons.lang3.text.StrMatcher;

@Deprecated
public class ExtendedMessageFormat
extends MessageFormat {
    private static final long serialVersionUID = -2362048321261811743L;
    private static final String EMPTY_PATTERN = "";
    private static final char START_FMT = ',';
    private static final char END_FE = '}';
    private static final char START_FE = '{';
    private static final char QUOTE = '\'';
    private String toPattern;
    private final Map<String, ? extends FormatFactory> registry;

    public ExtendedMessageFormat(String pattern2) {
        this(pattern2, Locale.getDefault());
    }

    public ExtendedMessageFormat(String pattern2, Locale locale) {
        this(pattern2, locale, null);
    }

    public ExtendedMessageFormat(String pattern2, Locale locale, Map<String, ? extends FormatFactory> registry) {
        super(EMPTY_PATTERN);
        this.setLocale(LocaleUtils.toLocale(locale));
        this.registry = registry;
        this.applyPattern(pattern2);
    }

    public ExtendedMessageFormat(String pattern2, Map<String, ? extends FormatFactory> registry) {
        this(pattern2, Locale.getDefault(), registry);
    }

    private StringBuilder appendQuotedString(String pattern2, ParsePosition pos, StringBuilder appendTo) {
        assert (pattern2.toCharArray()[pos.getIndex()] == '\'') : "Quoted string must start with quote character";
        if (appendTo != null) {
            appendTo.append('\'');
        }
        this.next(pos);
        int start2 = pos.getIndex();
        char[] c2 = pattern2.toCharArray();
        for (int i2 = pos.getIndex(); i2 < pattern2.length(); ++i2) {
            if (c2[pos.getIndex()] == '\'') {
                this.next(pos);
                return appendTo == null ? null : appendTo.append(c2, start2, pos.getIndex() - start2);
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated quoted string at position " + start2);
    }

    @Override
    public final void applyPattern(String pattern2) {
        if (this.registry == null) {
            super.applyPattern(pattern2);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList<Format> foundFormats = new ArrayList<Format>();
        ArrayList<String> foundDescriptions = new ArrayList<String>();
        StringBuilder stripCustom = new StringBuilder(pattern2.length());
        ParsePosition pos = new ParsePosition(0);
        char[] c2 = pattern2.toCharArray();
        int fmtCount = 0;
        block4: while (pos.getIndex() < pattern2.length()) {
            switch (c2[pos.getIndex()]) {
                case '\'': {
                    this.appendQuotedString(pattern2, pos, stripCustom);
                    continue block4;
                }
                case '{': {
                    ++fmtCount;
                    this.seekNonWs(pattern2, pos);
                    int start2 = pos.getIndex();
                    int index = this.readArgumentIndex(pattern2, this.next(pos));
                    stripCustom.append('{').append(index);
                    this.seekNonWs(pattern2, pos);
                    Format format2 = null;
                    String formatDescription = null;
                    if (c2[pos.getIndex()] == ',' && (format2 = this.getFormat(formatDescription = this.parseFormatDescription(pattern2, this.next(pos)))) == null) {
                        stripCustom.append(',').append(formatDescription);
                    }
                    foundFormats.add(format2);
                    foundDescriptions.add(format2 == null ? null : formatDescription);
                    Validate.isTrue(foundFormats.size() == fmtCount);
                    Validate.isTrue(foundDescriptions.size() == fmtCount);
                    if (c2[pos.getIndex()] == '}') break;
                    throw new IllegalArgumentException("Unreadable format element at position " + start2);
                }
            }
            stripCustom.append(c2[pos.getIndex()]);
            this.next(pos);
        }
        super.applyPattern(stripCustom.toString());
        this.toPattern = this.insertFormats(super.toPattern(), foundDescriptions);
        if (this.containsElements(foundFormats)) {
            Format[] origFormats = this.getFormats();
            int i2 = 0;
            for (Format f2 : foundFormats) {
                if (f2 != null) {
                    origFormats[i2] = f2;
                }
                ++i2;
            }
            super.setFormats(origFormats);
        }
    }

    private boolean containsElements(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        return coll.stream().anyMatch(Objects::nonNull);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ExtendedMessageFormat)) {
            return false;
        }
        ExtendedMessageFormat other = (ExtendedMessageFormat)obj;
        return Objects.equals(this.registry, other.registry) && Objects.equals(this.toPattern, other.toPattern);
    }

    private Format getFormat(String desc) {
        if (this.registry != null) {
            FormatFactory factory2;
            String name = desc;
            String args2 = null;
            int i2 = desc.indexOf(44);
            if (i2 > 0) {
                name = desc.substring(0, i2).trim();
                args2 = desc.substring(i2 + 1).trim();
            }
            if ((factory2 = this.registry.get(name)) != null) {
                return factory2.getFormat(name, args2, this.getLocale());
            }
        }
        return null;
    }

    private void getQuotedString(String pattern2, ParsePosition pos) {
        this.appendQuotedString(pattern2, pos, null);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        return 31 * result2 + Objects.hash(this.registry, this.toPattern);
    }

    private String insertFormats(String pattern2, ArrayList<String> customPatterns) {
        if (!this.containsElements(customPatterns)) {
            return pattern2;
        }
        StringBuilder sb = new StringBuilder(pattern2.length() * 2);
        ParsePosition pos = new ParsePosition(0);
        int fe = -1;
        int depth = 0;
        block5: while (pos.getIndex() < pattern2.length()) {
            char c2 = pattern2.charAt(pos.getIndex());
            switch (c2) {
                case '\'': {
                    this.appendQuotedString(pattern2, pos, sb);
                    break;
                }
                case '{': {
                    String customPattern;
                    sb.append('{').append(this.readArgumentIndex(pattern2, this.next(pos)));
                    if (++depth != 1 || (customPattern = customPatterns.get(++fe)) == null) continue block5;
                    sb.append(',').append(customPattern);
                    break;
                }
                case '}': {
                    --depth;
                }
                default: {
                    sb.append(c2);
                    this.next(pos);
                }
            }
        }
        return sb.toString();
    }

    private ParsePosition next(ParsePosition pos) {
        pos.setIndex(pos.getIndex() + 1);
        return pos;
    }

    private String parseFormatDescription(String pattern2, ParsePosition pos) {
        int start2 = pos.getIndex();
        this.seekNonWs(pattern2, pos);
        int text = pos.getIndex();
        int depth = 1;
        while (pos.getIndex() < pattern2.length()) {
            switch (pattern2.charAt(pos.getIndex())) {
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth != 0) break;
                    return pattern2.substring(text, pos.getIndex());
                }
                case '\'': {
                    this.getQuotedString(pattern2, pos);
                    break;
                }
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated format element at position " + start2);
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String pattern, ParsePosition pos) {
        start = pos.getIndex();
        this.seekNonWs(pattern, pos);
        result = new StringBuilder();
        error = false;
        while (!error && pos.getIndex() < pattern.length()) {
            c = pattern.charAt(pos.getIndex());
            if (!Character.isWhitespace(c)) ** GOTO lbl-1000
            this.seekNonWs(pattern, pos);
            c = pattern.charAt(pos.getIndex());
            if (c != ',' && c != '}') {
                error = true;
            } else lbl-1000:
            // 2 sources

            {
                if ((c == ',' || c == '}') && result.length() > 0) {
                    try {
                        return Integer.parseInt(result.toString());
                    }
                    catch (NumberFormatException var7_7) {
                        // empty catch block
                    }
                }
                error = Character.isDigit(c) == false;
                result.append(c);
            }
            this.next(pos);
        }
        if (error) {
            throw new IllegalArgumentException("Invalid format argument index at position " + start + ": " + pattern.substring(start, pos.getIndex()));
        }
        throw new IllegalArgumentException("Unterminated format element at position " + start);
    }

    private void seekNonWs(String pattern2, ParsePosition pos) {
        int len2;
        char[] buffer = pattern2.toCharArray();
        do {
            len2 = StrMatcher.splitMatcher().isMatch(buffer, pos.getIndex());
            pos.setIndex(pos.getIndex() + len2);
        } while (len2 > 0 && pos.getIndex() < pattern2.length());
    }

    @Override
    public void setFormat(int formatElementIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormats(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatsByArgumentIndex(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toPattern() {
        return this.toPattern;
    }
}

