/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectState;
import org.apache.commons.pool2.UsageTracking;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.BaseGenericObjectPool;
import org.apache.commons.pool2.impl.DefaultPooledObjectInfo;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolMXBean;
import org.apache.commons.pool2.impl.LinkedBlockingDeque;

public class GenericKeyedObjectPool<K, T>
extends BaseGenericObjectPool<T>
implements KeyedObjectPool<K, T>,
GenericKeyedObjectPoolMXBean<K>,
UsageTracking<T> {
    private static final Integer ZERO = 0;
    private static final String ONAME_BASE = "org.apache.commons.pool2:type=GenericKeyedObjectPool,name=";
    private volatile int maxIdlePerKey = 8;
    private volatile int minIdlePerKey = 0;
    private volatile int maxTotalPerKey = 8;
    private final KeyedPooledObjectFactory<K, T> factory;
    private final boolean fairness;
    private final Map<K, ObjectDeque<T>> poolMap = new ConcurrentHashMap<K, ObjectDeque<T>>();
    private final ArrayList<K> poolKeyList = new ArrayList();
    private final ReadWriteLock keyLock = new ReentrantReadWriteLock(true);
    private final AtomicInteger numTotal = new AtomicInteger(0);
    private Iterator<K> evictionKeyIterator;
    private K evictionKey;

    public GenericKeyedObjectPool(KeyedPooledObjectFactory<K, T> factory2) {
        this(factory2, new GenericKeyedObjectPoolConfig());
    }

    public GenericKeyedObjectPool(KeyedPooledObjectFactory<K, T> factory2, GenericKeyedObjectPoolConfig<T> config2) {
        super(config2, ONAME_BASE, config2.getJmxNamePrefix());
        if (factory2 == null) {
            this.jmxUnregister();
            throw new IllegalArgumentException("Factory may not be null");
        }
        this.factory = factory2;
        this.fairness = config2.getFairness();
        this.setConfig(config2);
    }

    public GenericKeyedObjectPool(KeyedPooledObjectFactory<K, T> factory2, GenericKeyedObjectPoolConfig<T> config2, AbandonedConfig abandonedConfig) {
        this(factory2, config2);
        this.setAbandonedConfig(abandonedConfig);
    }

    private void addIdleObject(K key2, PooledObject<T> p) throws Exception {
        if (!PooledObject.isNull(p)) {
            this.factory.passivateObject(key2, p);
            LinkedBlockingDeque<PooledObject<T>> idleObjects = this.poolMap.get(key2).getIdleObjects();
            if (this.getLifo()) {
                idleObjects.addFirst(p);
            } else {
                idleObjects.addLast(p);
            }
        }
    }

    @Override
    public void addObject(K key2) throws Exception {
        this.assertOpen();
        this.register(key2);
        try {
            this.addIdleObject(key2, this.create(key2));
        }
        finally {
            this.deregister(key2);
        }
    }

    @Override
    public T borrowObject(K key2) throws Exception {
        return this.borrowObject(key2, this.getMaxWaitDuration().toMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrowObject(K key2, long borrowMaxWaitMillis) throws Exception {
        this.assertOpen();
        AbandonedConfig ac = this.abandonedConfig;
        if (ac != null && ac.getRemoveAbandonedOnBorrow() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxTotal() - 3) {
            this.removeAbandoned(ac);
        }
        PooledObject<T> p = null;
        boolean blockWhenExhausted = this.getBlockWhenExhausted();
        Instant waitTime = Instant.now();
        ObjectDeque<T> objectDeque = this.register(key2);
        try {
            while (p == null) {
                boolean create2;
                block20: {
                    create2 = false;
                    p = objectDeque.getIdleObjects().pollFirst();
                    if (p == null && !PooledObject.isNull(p = this.create(key2))) {
                        create2 = true;
                    }
                    if (blockWhenExhausted) {
                        if (PooledObject.isNull(p)) {
                            PooledObject<T> pooledObject = p = borrowMaxWaitMillis < 0L ? objectDeque.getIdleObjects().takeFirst() : objectDeque.getIdleObjects().pollFirst(borrowMaxWaitMillis, TimeUnit.MILLISECONDS);
                        }
                        if (PooledObject.isNull(p)) {
                            throw new NoSuchElementException(this.appendStats("Timeout waiting for idle object, borrowMaxWaitMillis=" + borrowMaxWaitMillis));
                        }
                    } else if (PooledObject.isNull(p)) {
                        throw new NoSuchElementException(this.appendStats("Pool exhausted"));
                    }
                    if (!p.allocate()) {
                        p = null;
                    }
                    if (PooledObject.isNull(p)) continue;
                    try {
                        this.factory.activateObject(key2, p);
                    }
                    catch (Exception e2) {
                        try {
                            this.destroy(key2, p, true, DestroyMode.NORMAL);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        p = null;
                        if (!create2) break block20;
                        NoSuchElementException nsee = new NoSuchElementException(this.appendStats("Unable to activate object"));
                        nsee.initCause(e2);
                        throw nsee;
                    }
                }
                if (PooledObject.isNull(p) || !this.getTestOnBorrow()) continue;
                boolean validate = false;
                Throwable validationThrowable = null;
                try {
                    validate = this.factory.validateObject(key2, p);
                }
                catch (Throwable t2) {
                    PoolUtils.checkRethrow(t2);
                    validationThrowable = t2;
                }
                if (validate) continue;
                try {
                    this.destroy(key2, p, true, DestroyMode.NORMAL);
                    this.destroyedByBorrowValidationCount.incrementAndGet();
                }
                catch (Exception t2) {
                    // empty catch block
                }
                p = null;
                if (!create2) continue;
                NoSuchElementException nsee = new NoSuchElementException(this.appendStats("Unable to validate object"));
                nsee.initCause(validationThrowable);
                throw nsee;
            }
        }
        finally {
            this.deregister(key2);
        }
        this.updateStatsBorrow(p, Duration.between(waitTime, Instant.now()));
        return p.getObject();
    }

    private int calculateDeficit(ObjectDeque<T> objectDeque) {
        int growLimit;
        if (objectDeque == null) {
            return this.getMinIdlePerKey();
        }
        int maxTotal = this.getMaxTotal();
        int maxTotalPerKeySave = this.getMaxTotalPerKey();
        int objectDefecit = this.getMinIdlePerKey() - objectDeque.getIdleObjects().size();
        if (maxTotalPerKeySave > 0) {
            growLimit = Math.max(0, maxTotalPerKeySave - objectDeque.getIdleObjects().size());
            objectDefecit = Math.min(objectDefecit, growLimit);
        }
        if (maxTotal > 0) {
            growLimit = Math.max(0, maxTotal - this.getNumActive() - this.getNumIdle());
            objectDefecit = Math.min(objectDefecit, growLimit);
        }
        return objectDefecit;
    }

    @Override
    public void clear() {
        this.poolMap.keySet().forEach(key2 -> this.clear(key2, false));
    }

    @Override
    public void clear(K key2) {
        this.clear(key2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(K key2, boolean reuseCapacity) {
        if (!this.poolMap.containsKey(key2)) {
            return;
        }
        ObjectDeque<T> objectDeque = this.register(key2);
        int freedCapacity = 0;
        try {
            LinkedBlockingDeque<PooledObject<T>> idleObjects = objectDeque.getIdleObjects();
            PooledObject<T> p = idleObjects.poll();
            while (p != null) {
                try {
                    if (this.destroy(key2, p, true, DestroyMode.NORMAL)) {
                        ++freedCapacity;
                    }
                }
                catch (Exception e2) {
                    this.swallowException(e2);
                }
                p = idleObjects.poll();
            }
        }
        finally {
            this.deregister(key2);
        }
        if (reuseCapacity) {
            this.reuseCapacity(freedCapacity);
        }
    }

    public void clearOldest() {
        TreeMap map2 = new TreeMap();
        this.poolMap.forEach((key2, value2) -> value2.getIdleObjects().forEach(p -> map2.put(p, key2)));
        int itemsToRemove = (int)((double)map2.size() * 0.15) + 1;
        Iterator iter = map2.entrySet().iterator();
        while (iter.hasNext() && itemsToRemove > 0) {
            Map.Entry entry = iter.next();
            Object key3 = entry.getValue();
            PooledObject p = (PooledObject)entry.getKey();
            boolean destroyed = true;
            try {
                destroyed = this.destroy(key3, p, false, DestroyMode.NORMAL);
            }
            catch (Exception e2) {
                this.swallowException(e2);
            }
            if (!destroyed) continue;
            --itemsToRemove;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.stopEvictor();
            this.closed = true;
            this.clear();
            this.jmxUnregister();
            this.poolMap.values().forEach(e2 -> e2.getIdleObjects().interuptTakeWaiters());
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledObject<T> create(K key2) throws Exception {
        int maxTotalPerKeySave = this.getMaxTotalPerKey();
        if (maxTotalPerKeySave < 0) {
            maxTotalPerKeySave = Integer.MAX_VALUE;
        }
        int maxTotal = this.getMaxTotal();
        ObjectDeque<T> objectDeque = this.poolMap.get(key2);
        boolean loop2 = true;
        while (loop2) {
            int newNumTotal = this.numTotal.incrementAndGet();
            if (maxTotal > -1 && newNumTotal > maxTotal) {
                this.numTotal.decrementAndGet();
                if (this.getNumIdle() == 0) {
                    return null;
                }
                this.clearOldest();
                continue;
            }
            loop2 = false;
        }
        Boolean create2 = null;
        while (create2 == null) {
            Object object = ((ObjectDeque)objectDeque).makeObjectCountLock;
            synchronized (object) {
                long newCreateCount = objectDeque.getCreateCount().incrementAndGet();
                if (newCreateCount > (long)maxTotalPerKeySave) {
                    objectDeque.getCreateCount().decrementAndGet();
                    if (((ObjectDeque)objectDeque).makeObjectCount == 0L) {
                        create2 = Boolean.FALSE;
                    } else {
                        ((ObjectDeque)objectDeque).makeObjectCountLock.wait();
                    }
                } else {
                    ((ObjectDeque)objectDeque).makeObjectCount++;
                    create2 = Boolean.TRUE;
                }
            }
        }
        if (!create2.booleanValue()) {
            this.numTotal.decrementAndGet();
            return null;
        }
        PooledObject<T> p = null;
        try {
            p = this.factory.makeObject(key2);
            if (PooledObject.isNull(p)) {
                this.numTotal.decrementAndGet();
                objectDeque.getCreateCount().decrementAndGet();
                throw new NullPointerException(String.format("%s.makeObject() = null", this.factory.getClass().getSimpleName()));
            }
            if (this.getTestOnCreate() && !this.factory.validateObject(key2, p)) {
                this.numTotal.decrementAndGet();
                objectDeque.getCreateCount().decrementAndGet();
                PooledObject<T> newCreateCount = null;
                return newCreateCount;
            }
        }
        catch (Exception e2) {
            this.numTotal.decrementAndGet();
            objectDeque.getCreateCount().decrementAndGet();
            throw e2;
        }
        finally {
            Object object = ((ObjectDeque)objectDeque).makeObjectCountLock;
            synchronized (object) {
                ((ObjectDeque)objectDeque).makeObjectCount--;
                ((ObjectDeque)objectDeque).makeObjectCountLock.notifyAll();
            }
        }
        AbandonedConfig ac = this.abandonedConfig;
        if (ac != null && ac.getLogAbandoned()) {
            p.setLogAbandoned(true);
            p.setRequireFullStackTrace(ac.getRequireFullStackTrace());
        }
        this.createdCount.incrementAndGet();
        objectDeque.getAllObjects().put(new BaseGenericObjectPool.IdentityWrapper<T>(p.getObject()), p);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregister(K k2) {
        Lock lock = this.keyLock.readLock();
        try {
            lock.lock();
            ObjectDeque<T> objectDeque = this.poolMap.get(k2);
            if (objectDeque == null) {
                throw new IllegalStateException("Attempt to de-register a key for a non-existent pool");
            }
            long numInterested = objectDeque.getNumInterested().decrementAndGet();
            if (numInterested < 0L) {
                throw new IllegalStateException("numInterested count for key " + k2 + " is less than zero");
            }
            if (numInterested == 0L && objectDeque.getCreateCount().get() == 0) {
                lock.unlock();
                lock = this.keyLock.writeLock();
                lock.lock();
                objectDeque = this.poolMap.get(k2);
                if (null != objectDeque && objectDeque.getNumInterested().get() == 0L && objectDeque.getCreateCount().get() == 0) {
                    this.poolMap.remove(k2);
                    this.poolKeyList.remove(k2);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroy(K key2, PooledObject<T> toDestroy, boolean always, DestroyMode destroyMode) throws Exception {
        ObjectDeque<T> objectDeque = this.register(key2);
        try {
            boolean isIdle;
            PooledObject<T> pooledObject = toDestroy;
            synchronized (pooledObject) {
                isIdle = toDestroy.getState().equals((Object)PooledObjectState.IDLE);
                if (isIdle || always) {
                    isIdle = objectDeque.getIdleObjects().remove(toDestroy);
                }
            }
            if (isIdle || always) {
                objectDeque.getAllObjects().remove(new BaseGenericObjectPool.IdentityWrapper<T>(toDestroy.getObject()));
                toDestroy.invalidate();
                try {
                    this.factory.destroyObject(key2, toDestroy, destroyMode);
                }
                finally {
                    objectDeque.getCreateCount().decrementAndGet();
                    this.destroyedCount.incrementAndGet();
                    this.numTotal.decrementAndGet();
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.deregister(key2);
        }
    }

    @Override
    void ensureMinIdle() throws Exception {
        int minIdlePerKeySave = this.getMinIdlePerKey();
        if (minIdlePerKeySave < 1) {
            return;
        }
        for (K k2 : this.poolMap.keySet()) {
            this.ensureMinIdle(k2);
        }
    }

    private void ensureMinIdle(K key2) throws Exception {
        ObjectDeque<T> objectDeque = this.poolMap.get(key2);
        int deficit = this.calculateDeficit(objectDeque);
        for (int i2 = 0; i2 < deficit && this.calculateDeficit(objectDeque) > 0; ++i2) {
            this.addObject(key2);
            if (objectDeque != null) continue;
            objectDeque = this.poolMap.get(key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict() throws Exception {
        AbandonedConfig ac;
        this.assertOpen();
        if (this.getNumIdle() > 0) {
            Object underTest = null;
            EvictionPolicy evictionPolicy = this.getEvictionPolicy();
            Object object = this.evictionLock;
            synchronized (object) {
                EvictionConfig evictionConfig = new EvictionConfig(this.getMinEvictableIdleDuration(), this.getSoftMinEvictableIdleDuration(), this.getMinIdlePerKey());
                boolean testWhileIdle = this.getTestWhileIdle();
                int m4 = this.getNumTests();
                for (int i2 = 0; i2 < m4; ++i2) {
                    boolean evict;
                    Deque idleObjects;
                    if (this.evictionIterator == null || !this.evictionIterator.hasNext()) {
                        if (this.evictionKeyIterator == null || !this.evictionKeyIterator.hasNext()) {
                            ArrayList<K> keyCopy = new ArrayList<K>();
                            Lock readLock = this.keyLock.readLock();
                            readLock.lock();
                            try {
                                keyCopy.addAll(this.poolKeyList);
                            }
                            finally {
                                readLock.unlock();
                            }
                            this.evictionKeyIterator = keyCopy.iterator();
                        }
                        while (this.evictionKeyIterator.hasNext()) {
                            this.evictionKey = this.evictionKeyIterator.next();
                            ObjectDeque<T> objectDeque = this.poolMap.get(this.evictionKey);
                            if (objectDeque == null) continue;
                            LinkedBlockingDeque<PooledObject<T>> idleObjects2 = objectDeque.getIdleObjects();
                            this.evictionIterator = new BaseGenericObjectPool.EvictionIterator(idleObjects2);
                            if (this.evictionIterator.hasNext()) break;
                            this.evictionIterator = null;
                        }
                    }
                    if (this.evictionIterator == null) {
                        return;
                    }
                    try {
                        underTest = this.evictionIterator.next();
                        idleObjects = this.evictionIterator.getIdleObjects();
                    }
                    catch (NoSuchElementException nsee) {
                        --i2;
                        this.evictionIterator = null;
                        continue;
                    }
                    if (!underTest.startEvictionTest()) {
                        --i2;
                        continue;
                    }
                    try {
                        evict = evictionPolicy.evict(evictionConfig, underTest, this.poolMap.get(this.evictionKey).getIdleObjects().size());
                    }
                    catch (Throwable t2) {
                        PoolUtils.checkRethrow(t2);
                        this.swallowException(new Exception(t2));
                        evict = false;
                    }
                    if (evict) {
                        this.destroy(this.evictionKey, (PooledObject<T>)underTest, true, DestroyMode.NORMAL);
                        this.destroyedByEvictorCount.incrementAndGet();
                        continue;
                    }
                    if (testWhileIdle) {
                        boolean active = false;
                        try {
                            this.factory.activateObject(this.evictionKey, (PooledObject<T>)underTest);
                            active = true;
                        }
                        catch (Exception e2) {
                            this.destroy(this.evictionKey, (PooledObject<T>)underTest, true, DestroyMode.NORMAL);
                            this.destroyedByEvictorCount.incrementAndGet();
                        }
                        if (active) {
                            boolean validate = false;
                            Throwable validationThrowable = null;
                            try {
                                validate = this.factory.validateObject(this.evictionKey, (PooledObject<T>)underTest);
                            }
                            catch (Throwable t3) {
                                PoolUtils.checkRethrow(t3);
                                validationThrowable = t3;
                            }
                            if (!validate) {
                                this.destroy(this.evictionKey, (PooledObject<T>)underTest, true, DestroyMode.NORMAL);
                                this.destroyedByEvictorCount.incrementAndGet();
                                if (validationThrowable != null) {
                                    if (validationThrowable instanceof RuntimeException) {
                                        throw (RuntimeException)validationThrowable;
                                    }
                                    throw (Error)validationThrowable;
                                }
                            } else {
                                try {
                                    this.factory.passivateObject(this.evictionKey, (PooledObject<T>)underTest);
                                }
                                catch (Exception e3) {
                                    this.destroy(this.evictionKey, (PooledObject<T>)underTest, true, DestroyMode.NORMAL);
                                    this.destroyedByEvictorCount.incrementAndGet();
                                }
                            }
                        }
                    }
                    underTest.endEvictionTest(idleObjects);
                }
            }
        }
        if ((ac = this.abandonedConfig) != null && ac.getRemoveAbandonedOnMaintenance()) {
            this.removeAbandoned(ac);
        }
    }

    public KeyedPooledObjectFactory<K, T> getFactory() {
        return this.factory;
    }

    @Override
    public List<K> getKeys() {
        return (List)this.poolKeyList.clone();
    }

    @Override
    public int getMaxIdlePerKey() {
        return this.maxIdlePerKey;
    }

    @Override
    public int getMaxTotalPerKey() {
        return this.maxTotalPerKey;
    }

    @Override
    public int getMinIdlePerKey() {
        int maxIdlePerKeySave = this.getMaxIdlePerKey();
        return Math.min(this.minIdlePerKey, maxIdlePerKeySave);
    }

    @Override
    public int getNumActive() {
        return this.numTotal.get() - this.getNumIdle();
    }

    @Override
    public int getNumActive(K key2) {
        ObjectDeque<T> objectDeque = this.poolMap.get(key2);
        if (objectDeque != null) {
            return objectDeque.getAllObjects().size() - objectDeque.getIdleObjects().size();
        }
        return 0;
    }

    @Override
    public Map<String, Integer> getNumActivePerKey() {
        return this.poolMap.entrySet().stream().collect(Collectors.toMap(e2 -> e2.getKey().toString(), e2 -> ((ObjectDeque)e2.getValue()).getAllObjects().size() - ((ObjectDeque)e2.getValue()).getIdleObjects().size(), (t2, u) -> u));
    }

    @Override
    public int getNumIdle() {
        return this.poolMap.values().stream().mapToInt(e2 -> e2.getIdleObjects().size()).sum();
    }

    @Override
    public int getNumIdle(K key2) {
        ObjectDeque<T> objectDeque = this.poolMap.get(key2);
        return objectDeque != null ? objectDeque.getIdleObjects().size() : 0;
    }

    private int getNumTests() {
        int totalIdle = this.getNumIdle();
        int numTests = this.getNumTestsPerEvictionRun();
        if (numTests >= 0) {
            return Math.min(numTests, totalIdle);
        }
        return (int)Math.ceil((double)totalIdle / Math.abs((double)numTests));
    }

    @Override
    public int getNumWaiters() {
        if (this.getBlockWhenExhausted()) {
            return this.poolMap.values().stream().mapToInt(e2 -> e2.getIdleObjects().getTakeQueueLength()).sum();
        }
        return 0;
    }

    @Override
    public Map<String, Integer> getNumWaitersByKey() {
        HashMap<String, Integer> result2 = new HashMap<String, Integer>();
        this.poolMap.forEach((k2, deque) -> result2.put(k2.toString(), this.getBlockWhenExhausted() ? Integer.valueOf(deque.getIdleObjects().getTakeQueueLength()) : ZERO));
        return result2;
    }

    @Override
    String getStatsString() {
        return super.getStatsString() + String.format(", fairness=%s, maxIdlePerKey%,d, maxTotalPerKey=%,d, minIdlePerKey=%,d, numTotal=%,d", this.fairness, this.maxIdlePerKey, this.maxTotalPerKey, this.minIdlePerKey, this.numTotal.get());
    }

    private boolean hasBorrowWaiters() {
        return this.getBlockWhenExhausted() && this.poolMap.values().stream().anyMatch(deque -> deque.getIdleObjects().hasTakeWaiters());
    }

    @Override
    public void invalidateObject(K key2, T obj) throws Exception {
        this.invalidateObject(key2, obj, DestroyMode.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(K key2, T obj, DestroyMode destroyMode) throws Exception {
        PooledObject<T> p;
        ObjectDeque<T> objectDeque = this.poolMap.get(key2);
        PooledObject<T> pooledObject = p = objectDeque != null ? objectDeque.getAllObjects().get(new BaseGenericObjectPool.IdentityWrapper<T>(obj)) : null;
        if (p == null) {
            throw new IllegalStateException(this.appendStats("Object not currently part of this pool"));
        }
        PooledObject<T> pooledObject2 = p;
        synchronized (pooledObject2) {
            if (p.getState() != PooledObjectState.INVALID) {
                this.destroy(key2, p, true, destroyMode);
                this.reuseCapacity();
            }
        }
    }

    @Override
    public Map<String, List<DefaultPooledObjectInfo>> listAllObjects() {
        return this.poolMap.entrySet().stream().collect(Collectors.toMap(e2 -> e2.getKey().toString(), e2 -> ((ObjectDeque)e2.getValue()).getAllObjects().values().stream().map(DefaultPooledObjectInfo::new).collect(Collectors.toList())));
    }

    public void preparePool(K key2) throws Exception {
        int minIdlePerKeySave = this.getMinIdlePerKey();
        if (minIdlePerKeySave < 1) {
            return;
        }
        this.ensureMinIdle(key2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectDeque<T> register(K k2) {
        Lock lock = this.keyLock.readLock();
        ObjectDeque<T> objectDeque = null;
        try {
            lock.lock();
            objectDeque = this.poolMap.get(k2);
            if (objectDeque == null) {
                lock.unlock();
                lock = this.keyLock.writeLock();
                lock.lock();
                AtomicBoolean allocated = new AtomicBoolean();
                objectDeque = this.poolMap.computeIfAbsent(k2, key2 -> {
                    allocated.set(true);
                    ObjectDeque deque = new ObjectDeque(this.fairness);
                    deque.getNumInterested().incrementAndGet();
                    this.poolKeyList.add(k2);
                    return deque;
                });
                if (!allocated.get()) {
                    objectDeque = this.poolMap.get(k2);
                    objectDeque.getNumInterested().incrementAndGet();
                }
            } else {
                objectDeque.getNumInterested().incrementAndGet();
            }
        }
        finally {
            lock.unlock();
        }
        return objectDeque;
    }

    private void removeAbandoned(AbandonedConfig abandonedConfig) {
        this.poolMap.forEach((key2, value2) -> {
            ArrayList remove2 = this.createRemoveList(abandonedConfig, value2.getAllObjects());
            remove2.forEach(pooledObject -> {
                if (abandonedConfig.getLogAbandoned()) {
                    pooledObject.printStackTrace(abandonedConfig.getLogWriter());
                }
                try {
                    this.invalidateObject((K)key2, (T)pooledObject.getObject(), DestroyMode.ABANDONED);
                }
                catch (Exception e2) {
                    this.swallowException(e2);
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(K key2, T obj) {
        ObjectDeque<T> objectDeque = this.poolMap.get(key2);
        if (objectDeque == null) {
            throw new IllegalStateException("No keyed pool found under the given key.");
        }
        PooledObject<T> p = objectDeque.getAllObjects().get(new BaseGenericObjectPool.IdentityWrapper<T>(obj));
        if (PooledObject.isNull(p)) {
            throw new IllegalStateException("Returned object not currently part of this pool");
        }
        this.markReturningState(p);
        Duration activeTime = p.getActiveDuration();
        try {
            if (this.getTestOnReturn() && !this.factory.validateObject(key2, p)) {
                try {
                    this.destroy(key2, p, true, DestroyMode.NORMAL);
                }
                catch (Exception e2) {
                    this.swallowException(e2);
                }
                this.whenWaitersAddObject(key2, ((ObjectDeque)objectDeque).idleObjects);
                return;
            }
            try {
                this.factory.passivateObject(key2, p);
            }
            catch (Exception e1) {
                this.swallowException(e1);
                try {
                    this.destroy(key2, p, true, DestroyMode.NORMAL);
                }
                catch (Exception e3) {
                    this.swallowException(e3);
                }
                this.whenWaitersAddObject(key2, ((ObjectDeque)objectDeque).idleObjects);
                if (this.hasBorrowWaiters()) {
                    this.reuseCapacity();
                }
                this.updateStatsReturn(activeTime);
                return;
            }
            if (!p.deallocate()) {
                throw new IllegalStateException("Object has already been returned to this pool");
            }
            int maxIdle = this.getMaxIdlePerKey();
            LinkedBlockingDeque<PooledObject<T>> idleObjects = objectDeque.getIdleObjects();
            if (this.isClosed() || maxIdle > -1 && maxIdle <= idleObjects.size()) {
                try {
                    this.destroy(key2, p, true, DestroyMode.NORMAL);
                }
                catch (Exception e4) {
                    this.swallowException(e4);
                }
            } else {
                if (this.getLifo()) {
                    idleObjects.addFirst(p);
                } else {
                    idleObjects.addLast(p);
                }
                if (this.isClosed()) {
                    this.clear(key2);
                }
            }
        }
        finally {
            if (this.hasBorrowWaiters()) {
                this.reuseCapacity();
            }
            this.updateStatsReturn(activeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reuseCapacity() {
        int maxTotalPerKeySave = this.getMaxTotalPerKey();
        int maxQueueLength = 0;
        LinkedBlockingDeque<PooledObject<T>> mostLoadedPool = null;
        K mostLoadedKey = null;
        for (Map.Entry<K, ObjectDeque<T>> entry : this.poolMap.entrySet()) {
            K k2 = entry.getKey();
            LinkedBlockingDeque<PooledObject<T>> pool = entry.getValue().getIdleObjects();
            int queueLength = pool.getTakeQueueLength();
            if (this.getNumActive(k2) >= maxTotalPerKeySave || queueLength <= maxQueueLength) continue;
            maxQueueLength = queueLength;
            mostLoadedPool = pool;
            mostLoadedKey = k2;
        }
        if (mostLoadedPool != null) {
            this.register(mostLoadedKey);
            try {
                this.addIdleObject(mostLoadedKey, this.create(mostLoadedKey));
            }
            catch (Exception e2) {
                this.swallowException(e2);
            }
            finally {
                this.deregister(mostLoadedKey);
            }
        }
    }

    private void reuseCapacity(int newCapacity) {
        int bound = newCapacity < 1 ? 1 : newCapacity;
        for (int i2 = 0; i2 < bound; ++i2) {
            this.reuseCapacity();
        }
    }

    @Override
    public void setConfig(GenericKeyedObjectPoolConfig<T> conf) {
        super.setConfig(conf);
        this.setMaxIdlePerKey(conf.getMaxIdlePerKey());
        this.setMaxTotalPerKey(conf.getMaxTotalPerKey());
        this.setMaxTotal(conf.getMaxTotal());
        this.setMinIdlePerKey(conf.getMinIdlePerKey());
    }

    public void setMaxIdlePerKey(int maxIdlePerKey) {
        this.maxIdlePerKey = maxIdlePerKey;
    }

    public void setMaxTotalPerKey(int maxTotalPerKey) {
        this.maxTotalPerKey = maxTotalPerKey;
    }

    public void setMinIdlePerKey(int minIdlePerKey) {
        this.minIdlePerKey = minIdlePerKey;
    }

    @Override
    protected void toStringAppendFields(StringBuilder builder) {
        super.toStringAppendFields(builder);
        builder.append(", maxIdlePerKey=");
        builder.append(this.maxIdlePerKey);
        builder.append(", minIdlePerKey=");
        builder.append(this.minIdlePerKey);
        builder.append(", maxTotalPerKey=");
        builder.append(this.maxTotalPerKey);
        builder.append(", factory=");
        builder.append(this.factory);
        builder.append(", fairness=");
        builder.append(this.fairness);
        builder.append(", poolMap=");
        builder.append(this.poolMap);
        builder.append(", poolKeyList=");
        builder.append(this.poolKeyList);
        builder.append(", keyLock=");
        builder.append(this.keyLock);
        builder.append(", numTotal=");
        builder.append(this.numTotal);
        builder.append(", evictionKeyIterator=");
        builder.append(this.evictionKeyIterator);
        builder.append(", evictionKey=");
        builder.append(this.evictionKey);
        builder.append(", abandonedConfig=");
        builder.append(this.abandonedConfig);
    }

    @Override
    public void use(T pooledObject) {
        AbandonedConfig abandonedCfg = this.abandonedConfig;
        if (abandonedCfg != null && abandonedCfg.getUseUsageTracking()) {
            this.poolMap.values().stream().map(pool -> pool.getAllObjects().get(new BaseGenericObjectPool.IdentityWrapper<Object>(pooledObject))).filter(Objects::nonNull).findFirst().ifPresent(PooledObject::use);
        }
    }

    private void whenWaitersAddObject(K key2, LinkedBlockingDeque<PooledObject<T>> idleObjects) {
        if (idleObjects.hasTakeWaiters()) {
            try {
                this.addObject(key2);
            }
            catch (Exception e2) {
                this.swallowException(e2);
            }
        }
    }

    private static class ObjectDeque<S> {
        private final LinkedBlockingDeque<PooledObject<S>> idleObjects;
        private final AtomicInteger createCount = new AtomicInteger(0);
        private long makeObjectCount;
        private final Object makeObjectCountLock = new Object();
        private final Map<BaseGenericObjectPool.IdentityWrapper<S>, PooledObject<S>> allObjects = new ConcurrentHashMap<BaseGenericObjectPool.IdentityWrapper<S>, PooledObject<S>>();
        private final AtomicLong numInterested = new AtomicLong();

        public ObjectDeque(boolean fairness) {
            this.idleObjects = new LinkedBlockingDeque(fairness);
        }

        public Map<BaseGenericObjectPool.IdentityWrapper<S>, PooledObject<S>> getAllObjects() {
            return this.allObjects;
        }

        public AtomicInteger getCreateCount() {
            return this.createCount;
        }

        public LinkedBlockingDeque<PooledObject<S>> getIdleObjects() {
            return this.idleObjects;
        }

        public AtomicLong getNumInterested() {
            return this.numInterested;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ObjectDeque [idleObjects=");
            builder.append(this.idleObjects);
            builder.append(", createCount=");
            builder.append(this.createCount);
            builder.append(", allObjects=");
            builder.append(this.allObjects);
            builder.append(", numInterested=");
            builder.append(this.numInterested);
            builder.append("]");
            return builder.toString();
        }
    }
}

