/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.PooledObjectFactory;

class PoolImplUtils {
    PoolImplUtils() {
    }

    static Class<?> getFactoryType(Class<? extends PooledObjectFactory> factoryClass) {
        Class<PooledObjectFactory> type2 = PooledObjectFactory.class;
        Object genericType = PoolImplUtils.getGenericType(type2, factoryClass);
        if (genericType instanceof Integer) {
            Type bound0;
            Type[] bounds;
            ParameterizedType pi = PoolImplUtils.getParameterizedType(type2, factoryClass);
            if (pi != null && (bounds = ((TypeVariable)pi.getActualTypeArguments()[(Integer)genericType]).getBounds()) != null && bounds.length > 0 && (bound0 = bounds[0]) instanceof Class) {
                return (Class)bound0;
            }
            return Object.class;
        }
        return (Class)genericType;
    }

    private static <T> Object getGenericType(Class<T> type2, Class<? extends T> clazz) {
        if (type2 == null || clazz == null) {
            return null;
        }
        ParameterizedType pi = PoolImplUtils.getParameterizedType(type2, clazz);
        if (pi != null) {
            return PoolImplUtils.getTypeParameter(clazz, pi.getActualTypeArguments()[0]);
        }
        Class<? extends T> superClass = clazz.getSuperclass();
        Object result2 = PoolImplUtils.getGenericType(type2, superClass);
        if (result2 instanceof Class) {
            return result2;
        }
        if (result2 instanceof Integer) {
            ParameterizedType superClassType = (ParameterizedType)clazz.getGenericSuperclass();
            return PoolImplUtils.getTypeParameter(clazz, superClassType.getActualTypeArguments()[(Integer)result2]);
        }
        return null;
    }

    private static <T> ParameterizedType getParameterizedType(Class<T> type2, Class<? extends T> clazz) {
        for (Type iface : clazz.getGenericInterfaces()) {
            ParameterizedType pi;
            if (!(iface instanceof ParameterizedType) || !((pi = (ParameterizedType)iface).getRawType() instanceof Class) || !type2.isAssignableFrom((Class)pi.getRawType())) continue;
            return pi;
        }
        return null;
    }

    private static Object getTypeParameter(Class<?> clazz, Type argType) {
        if (argType instanceof Class) {
            return argType;
        }
        TypeVariable<Class<?>>[] tvs = clazz.getTypeParameters();
        for (int i2 = 0; i2 < tvs.length; ++i2) {
            if (!tvs[i2].equals(argType)) continue;
            return i2;
        }
        return null;
    }

    static boolean isPositive(Duration delay2) {
        return delay2 != null && !delay2.isNegative() && !delay2.isZero();
    }

    static Instant max(Instant a2, Instant b2) {
        return a2.compareTo(b2) > 0 ? a2 : b2;
    }

    static Instant min(Instant a2, Instant b2) {
        return a2.compareTo(b2) < 0 ? a2 : b2;
    }

    static Duration nonNull(Duration value2, Duration defaultValue) {
        return value2 != null ? value2 : Objects.requireNonNull(defaultValue, "defaultValue");
    }

    static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        switch (Objects.requireNonNull(timeUnit)) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException(timeUnit.toString());
    }

    static Duration toDuration(long amount, TimeUnit timeUnit) {
        return Duration.of(amount, PoolImplUtils.toChronoUnit(timeUnit));
    }
}

