/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.TokenIterator;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.message.BasicTokenIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpResponse response2, HttpContext context) {
        HeaderIterator headerIterator;
        ProtocolVersion ver;
        block25: {
            HttpRequest request2;
            Args.notNull(response2, "HTTP response");
            Args.notNull(context, "HTTP context");
            if (response2.getStatusLine().getStatusCode() == 204) {
                Header teh;
                Header clh = response2.getFirstHeader("Content-Length");
                if (clh != null) {
                    try {
                        int contentLen = Integer.parseInt(clh.getValue());
                        if (contentLen > 0) {
                            return false;
                        }
                    }
                    catch (NumberFormatException contentLen) {
                        // empty catch block
                    }
                }
                if ((teh = response2.getFirstHeader("Transfer-Encoding")) != null) {
                    return false;
                }
            }
            if ((request2 = (HttpRequest)context.getAttribute("http.request")) != null) {
                try {
                    BasicTokenIterator ti = new BasicTokenIterator(request2.headerIterator("Connection"));
                    while (ti.hasNext()) {
                        String token2 = ti.nextToken();
                        if (!"Close".equalsIgnoreCase(token2)) continue;
                        return false;
                    }
                }
                catch (ParseException px) {
                    return false;
                }
            }
            ver = response2.getStatusLine().getProtocolVersion();
            Header teh = response2.getFirstHeader("Transfer-Encoding");
            if (teh != null) {
                if (!"chunked".equalsIgnoreCase(teh.getValue())) {
                    return false;
                }
            } else if (this.canResponseHaveBody(request2, response2)) {
                Header[] clhs = response2.getHeaders("Content-Length");
                if (clhs.length == 1) {
                    Header clh = clhs[0];
                    try {
                        long contentLen = Long.parseLong(clh.getValue());
                        if (contentLen < 0L) {
                            return false;
                        }
                        break block25;
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
                return false;
            }
        }
        if (!(headerIterator = response2.headerIterator("Connection")).hasNext()) {
            headerIterator = response2.headerIterator("Proxy-Connection");
        }
        if (headerIterator.hasNext()) {
            try {
                BasicTokenIterator ti = new BasicTokenIterator(headerIterator);
                boolean keepalive = false;
                while (ti.hasNext()) {
                    String token3 = ti.nextToken();
                    if ("Close".equalsIgnoreCase(token3)) {
                        return false;
                    }
                    if (!"Keep-Alive".equalsIgnoreCase(token3)) continue;
                    keepalive = true;
                }
                if (keepalive) {
                    return true;
                }
            }
            catch (ParseException px) {
                return false;
            }
        }
        return !ver.lessEquals(HttpVersion.HTTP_1_0);
    }

    protected TokenIterator createTokenIterator(HeaderIterator hit) {
        return new BasicTokenIterator(hit);
    }

    private boolean canResponseHaveBody(HttpRequest request2, HttpResponse response2) {
        if (request2 != null && request2.getRequestLine().getMethod().equalsIgnoreCase("HEAD")) {
            return false;
        }
        int status2 = response2.getStatusLine().getStatusCode();
        return status2 >= 200 && status2 != 204 && status2 != 304 && status2 != 205;
    }
}

