/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class AutoRetryHttpClient
implements HttpClient {
    private final HttpClient backend;
    private final ServiceUnavailableRetryStrategy retryStrategy;
    private final Log log = LogFactory.getLog(this.getClass());

    public AutoRetryHttpClient(HttpClient client2, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(client2, "HttpClient");
        Args.notNull(retryStrategy, "ServiceUnavailableRetryStrategy");
        this.backend = client2;
        this.retryStrategy = retryStrategy;
    }

    public AutoRetryHttpClient() {
        this(new DefaultHttpClient(), new DefaultServiceUnavailableRetryStrategy());
    }

    public AutoRetryHttpClient(ServiceUnavailableRetryStrategy config2) {
        this(new DefaultHttpClient(), config2);
    }

    public AutoRetryHttpClient(HttpClient client2) {
        this(client2, new DefaultServiceUnavailableRetryStrategy());
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request2) throws IOException {
        HttpContext defaultContext = null;
        return this.execute(target, request2, defaultContext);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler2) throws IOException {
        return this.execute(target, request2, responseHandler2, null);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler2, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(target, request2, context);
        return responseHandler2.handleResponse(resp);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request2) throws IOException {
        HttpContext context = null;
        return this.execute(request2, context);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request2, HttpContext context) throws IOException {
        URI uri2 = request2.getURI();
        HttpHost httpHost = new HttpHost(uri2.getHost(), uri2.getPort(), uri2.getScheme());
        return this.execute(httpHost, (HttpRequest)request2, context);
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler2) throws IOException {
        return this.execute(request2, responseHandler2, null);
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler2, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(request2, context);
        return responseHandler2.handleResponse(resp);
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request2, HttpContext context) throws IOException {
        int c2 = 1;
        while (true) {
            block8: {
                HttpResponse response2 = this.backend.execute(target, request2, context);
                try {
                    if (this.retryStrategy.retryRequest(response2, c2, context)) {
                        EntityUtils.consume(response2.getEntity());
                        long nextInterval = this.retryStrategy.getRetryInterval();
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                            break block8;
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                    return response2;
                }
                catch (RuntimeException ex) {
                    try {
                        EntityUtils.consume(response2.getEntity());
                    }
                    catch (IOException ioex) {
                        this.log.warn("I/O error consuming response content", ioex);
                    }
                    throw ex;
                }
            }
            ++c2;
        }
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    @Override
    public HttpParams getParams() {
        return this.backend.getParams();
    }
}

