/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

@Deprecated
public class DecompressingHttpClient
implements HttpClient {
    private final HttpClient backend;
    private final HttpRequestInterceptor acceptEncodingInterceptor;
    private final HttpResponseInterceptor contentEncodingInterceptor;

    public DecompressingHttpClient() {
        this(new DefaultHttpClient());
    }

    public DecompressingHttpClient(HttpClient backend) {
        this(backend, new RequestAcceptEncoding(), new ResponseContentEncoding());
    }

    DecompressingHttpClient(HttpClient backend, HttpRequestInterceptor requestInterceptor, HttpResponseInterceptor responseInterceptor) {
        this.backend = backend;
        this.acceptEncodingInterceptor = requestInterceptor;
        this.contentEncodingInterceptor = responseInterceptor;
    }

    @Override
    public HttpParams getParams() {
        return this.backend.getParams();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    @Override
    public HttpResponse execute(HttpUriRequest request2) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(request2), (HttpRequest)request2, (HttpContext)null);
    }

    public HttpClient getHttpClient() {
        return this.backend;
    }

    HttpHost getHttpHost(HttpUriRequest request2) {
        URI uri2 = request2.getURI();
        return URIUtils.extractHost(uri2);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request2, HttpContext context) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(request2), (HttpRequest)request2, context);
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request2) throws IOException, ClientProtocolException {
        return this.execute(target, request2, (HttpContext)null);
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request2, HttpContext context) throws IOException, ClientProtocolException {
        try {
            HttpContext localContext = context != null ? context : new BasicHttpContext();
            RequestWrapper wrapped = request2 instanceof HttpEntityEnclosingRequest ? new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request2) : new RequestWrapper(request2);
            this.acceptEncodingInterceptor.process(wrapped, localContext);
            HttpResponse response2 = this.backend.execute(target, (HttpRequest)wrapped, localContext);
            try {
                this.contentEncodingInterceptor.process(response2, localContext);
                if (Boolean.TRUE.equals(localContext.getAttribute("http.client.response.uncompressed"))) {
                    response2.removeHeaders("Content-Length");
                    response2.removeHeaders("Content-Encoding");
                    response2.removeHeaders("Content-MD5");
                }
                return response2;
            }
            catch (HttpException ex) {
                EntityUtils.consume(response2.getEntity());
                throw ex;
            }
            catch (IOException ex) {
                EntityUtils.consume(response2.getEntity());
                throw ex;
            }
            catch (RuntimeException ex) {
                EntityUtils.consume(response2.getEntity());
                throw ex;
            }
        }
        catch (HttpException e2) {
            throw new ClientProtocolException(e2);
        }
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler2) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(request2), (HttpRequest)request2, responseHandler2);
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler2, HttpContext context) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(request2), request2, responseHandler2, context);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler2) throws IOException, ClientProtocolException {
        return this.execute(target, request2, responseHandler2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler2, HttpContext context) throws IOException, ClientProtocolException {
        HttpResponse response2 = this.execute(target, request2, context);
        try {
            T t2 = responseHandler2.handleResponse(response2);
            return t2;
        }
        finally {
            HttpEntity entity = response2.getEntity();
            if (entity != null) {
                EntityUtils.consume(entity);
            }
        }
    }
}

