/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultRedirectStrategy
implements RedirectStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final int SC_PERMANENT_REDIRECT = 308;
    @Deprecated
    public static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";
    public static final DefaultRedirectStrategy INSTANCE = new DefaultRedirectStrategy();
    private final String[] redirectMethods;

    public DefaultRedirectStrategy() {
        this(new String[]{"GET", "HEAD"});
    }

    public DefaultRedirectStrategy(String[] redirectMethods) {
        Object[] tmp = (String[])redirectMethods.clone();
        Arrays.sort(tmp);
        this.redirectMethods = tmp;
    }

    @Override
    public boolean isRedirected(HttpRequest request2, HttpResponse response2, HttpContext context) throws ProtocolException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(response2, "HTTP response");
        int statusCode = response2.getStatusLine().getStatusCode();
        String method2 = request2.getRequestLine().getMethod();
        Header locationHeader = response2.getFirstHeader("location");
        switch (statusCode) {
            case 302: {
                return this.isRedirectable(method2) && locationHeader != null;
            }
            case 301: 
            case 307: 
            case 308: {
                return this.isRedirectable(method2);
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    public URI getLocationURI(HttpRequest request2, HttpResponse response2, HttpContext context) throws ProtocolException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(response2, "HTTP response");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Header locationHeader = response2.getFirstHeader("location");
        if (locationHeader == null) {
            throw new ProtocolException("Received redirect response " + response2.getStatusLine() + " but no location header");
        }
        String location = locationHeader.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Redirect requested to location '" + location + "'");
        }
        RequestConfig config2 = clientContext.getRequestConfig();
        URI uri2 = this.createLocationURI(location);
        try {
            if (config2.isNormalizeUri()) {
                uri2 = URIUtils.normalizeSyntax(uri2);
            }
            if (!uri2.isAbsolute()) {
                if (!config2.isRelativeRedirectsAllowed()) {
                    throw new ProtocolException("Relative redirect location '" + uri2 + "' not allowed");
                }
                HttpHost target = clientContext.getTargetHost();
                Asserts.notNull(target, "Target host");
                URI requestURI = new URI(request2.getRequestLine().getUri());
                URI absoluteRequestURI = URIUtils.rewriteURI(requestURI, target, config2.isNormalizeUri() ? URIUtils.NORMALIZE : URIUtils.NO_FLAGS);
                uri2 = URIUtils.resolve(absoluteRequestURI, uri2);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), ex);
        }
        RedirectLocations redirectLocations = (RedirectLocations)clientContext.getAttribute(REDIRECT_LOCATIONS);
        if (redirectLocations == null) {
            redirectLocations = new RedirectLocations();
            context.setAttribute(REDIRECT_LOCATIONS, redirectLocations);
        }
        if (!config2.isCircularRedirectsAllowed() && redirectLocations.contains(uri2)) {
            throw new CircularRedirectException("Circular redirect to '" + uri2 + "'");
        }
        redirectLocations.add(uri2);
        return uri2;
    }

    protected URI createLocationURI(String location) throws ProtocolException {
        try {
            return new URI(location);
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid redirect URI: " + location, ex);
        }
    }

    protected boolean isRedirectable(String method2) {
        return Arrays.binarySearch(this.redirectMethods, method2) >= 0;
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest request2, HttpResponse response2, HttpContext context) throws ProtocolException {
        URI uri2 = this.getLocationURI(request2, response2, context);
        String method2 = request2.getRequestLine().getMethod();
        if (method2.equalsIgnoreCase("HEAD")) {
            return new HttpHead(uri2);
        }
        if (method2.equalsIgnoreCase("GET")) {
            return new HttpGet(uri2);
        }
        int status2 = response2.getStatusLine().getStatusCode();
        return status2 == 307 || status2 == 308 ? RequestBuilder.copy(request2).setUri(uri2).build() : new HttpGet(uri2);
    }
}

