/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.AbstractCookieSpec;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CookieSpecBase
extends AbstractCookieSpec {
    public CookieSpecBase() {
    }

    protected CookieSpecBase(HashMap<String, CookieAttributeHandler> map2) {
        super(map2);
    }

    protected CookieSpecBase(CommonCookieAttributeHandler ... handlers) {
        super(handlers);
    }

    protected static String getDefaultPath(CookieOrigin origin2) {
        String defaultPath = origin2.getPath();
        int lastSlashIndex = defaultPath.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            if (lastSlashIndex == 0) {
                lastSlashIndex = 1;
            }
            defaultPath = defaultPath.substring(0, lastSlashIndex);
        }
        return defaultPath;
    }

    protected static String getDefaultDomain(CookieOrigin origin2) {
        return origin2.getHost();
    }

    protected List<Cookie> parse(HeaderElement[] elems, CookieOrigin origin2) throws MalformedCookieException {
        ArrayList<Cookie> cookies2 = new ArrayList<Cookie>(elems.length);
        for (HeaderElement headerelement : elems) {
            String name = headerelement.getName();
            String value2 = headerelement.getValue();
            if (name == null || name.isEmpty()) continue;
            BasicClientCookie cookie = new BasicClientCookie(name, value2);
            cookie.setPath(CookieSpecBase.getDefaultPath(origin2));
            cookie.setDomain(CookieSpecBase.getDefaultDomain(origin2));
            NameValuePair[] attribs = headerelement.getParameters();
            for (int j2 = attribs.length - 1; j2 >= 0; --j2) {
                NameValuePair attrib = attribs[j2];
                String s2 = attrib.getName().toLowerCase(Locale.ROOT);
                cookie.setAttribute(s2, attrib.getValue());
                CookieAttributeHandler handler2 = this.findAttribHandler(s2);
                if (handler2 == null) continue;
                handler2.parse(cookie, attrib.getValue());
            }
            cookies2.add(cookie);
        }
        return cookies2;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin2, "Cookie origin");
        for (CookieAttributeHandler handler2 : this.getAttribHandlers()) {
            handler2.validate(cookie, origin2);
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin2) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin2, "Cookie origin");
        for (CookieAttributeHandler handler2 : this.getAttribHandlers()) {
            if (handler2.match(cookie, origin2)) continue;
            return false;
        }
        return true;
    }
}

