/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.util.PublicSuffixList;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class PublicSuffixDomainFilter
implements CommonCookieAttributeHandler {
    private final CommonCookieAttributeHandler handler;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private final Map<String, Boolean> localDomainMap;

    private static Map<String, Boolean> createLocalDomainMap() {
        ConcurrentHashMap<String, Boolean> map2 = new ConcurrentHashMap<String, Boolean>();
        map2.put(".localhost.", Boolean.TRUE);
        map2.put(".test.", Boolean.TRUE);
        map2.put(".local.", Boolean.TRUE);
        map2.put(".local", Boolean.TRUE);
        map2.put(".localdomain", Boolean.TRUE);
        return map2;
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler2, PublicSuffixMatcher publicSuffixMatcher) {
        this.handler = Args.notNull(handler2, "Cookie handler");
        this.publicSuffixMatcher = Args.notNull(publicSuffixMatcher, "Public suffix matcher");
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler2, PublicSuffixList suffixList) {
        Args.notNull(handler2, "Cookie handler");
        Args.notNull(suffixList, "Public suffix list");
        this.handler = handler2;
        this.publicSuffixMatcher = new PublicSuffixMatcher(suffixList.getRules(), suffixList.getExceptions());
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin2) {
        String domain;
        String host2 = cookie.getDomain();
        if (host2 == null) {
            return false;
        }
        int i2 = host2.indexOf(46);
        if (i2 >= 0 ? !this.localDomainMap.containsKey(domain = host2.substring(i2)) && this.publicSuffixMatcher.matches(host2) : !host2.equalsIgnoreCase(origin2.getHost()) && this.publicSuffixMatcher.matches(host2)) {
            return false;
        }
        return this.handler.match(cookie, origin2);
    }

    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        this.handler.parse(cookie, value2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin2) throws MalformedCookieException {
        this.handler.validate(cookie, origin2);
    }

    @Override
    public String getAttributeName() {
        return this.handler.getAttributeName();
    }

    public static CommonCookieAttributeHandler decorate(CommonCookieAttributeHandler handler2, PublicSuffixMatcher publicSuffixMatcher) {
        Args.notNull(handler2, "Cookie attribute handler");
        return publicSuffixMatcher != null ? new PublicSuffixDomainFilter(handler2, publicSuffixMatcher) : handler2;
    }
}

