/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.Obsolete;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePathComparator;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.apache.http.impl.cookie.RFC2109VersionHandler;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Obsolete
@Contract(threading=ThreadingBehavior.SAFE)
public class RFC2109Spec
extends CookieSpecBase {
    static final String[] DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private final boolean oneHeader;

    public RFC2109Spec(String[] datepatterns, boolean oneHeader) {
        super(new RFC2109VersionHandler(), new BasicPathHandler(){

            @Override
            public void validate(Cookie cookie, CookieOrigin origin2) throws MalformedCookieException {
                if (!this.match(cookie, origin2)) {
                    throw new CookieRestrictionViolationException("Illegal 'path' attribute \"" + cookie.getPath() + "\". Path of origin: \"" + origin2.getPath() + "\"");
                }
            }
        }, new RFC2109DomainHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new BasicExpiresHandler(datepatterns != null ? (String[])datepatterns.clone() : DATE_PATTERNS));
        this.oneHeader = oneHeader;
    }

    public RFC2109Spec() {
        this(null, false);
    }

    protected RFC2109Spec(boolean oneHeader, CommonCookieAttributeHandler ... handlers) {
        super(handlers);
        this.oneHeader = oneHeader;
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin2) throws MalformedCookieException {
        Args.notNull(header, "Header");
        Args.notNull(origin2, "Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] elems = header.getElements();
        return this.parse(elems, origin2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        String name = cookie.getName();
        if (name.indexOf(32) != -1) {
            throw new CookieRestrictionViolationException("Cookie name may not contain blanks");
        }
        if (name.startsWith("$")) {
            throw new CookieRestrictionViolationException("Cookie name may not start with $");
        }
        super.validate(cookie, origin2);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies2) {
        List<Cookie> cookieList;
        Args.notEmpty(cookies2, "List of cookies");
        if (cookies2.size() > 1) {
            cookieList = new ArrayList<Cookie>(cookies2);
            Collections.sort(cookieList, CookiePathComparator.INSTANCE);
        } else {
            cookieList = cookies2;
        }
        return this.oneHeader ? this.doFormatOneHeader(cookieList) : this.doFormatManyHeaders(cookieList);
    }

    private List<Header> doFormatOneHeader(List<Cookie> cookies2) {
        int version2 = Integer.MAX_VALUE;
        for (Cookie cookie : cookies2) {
            if (cookie.getVersion() >= version2) continue;
            version2 = cookie.getVersion();
        }
        CharArrayBuffer buffer = new CharArrayBuffer(40 * cookies2.size());
        buffer.append("Cookie");
        buffer.append(": ");
        buffer.append("$Version=");
        buffer.append(Integer.toString(version2));
        for (Cookie cooky : cookies2) {
            buffer.append("; ");
            Cookie cookie = cooky;
            this.formatCookieAsVer(buffer, cookie, version2);
        }
        ArrayList<Header> headers2 = new ArrayList<Header>(1);
        headers2.add(new BufferedHeader(buffer));
        return headers2;
    }

    private List<Header> doFormatManyHeaders(List<Cookie> cookies2) {
        ArrayList<Header> headers2 = new ArrayList<Header>(cookies2.size());
        for (Cookie cookie : cookies2) {
            int version2 = cookie.getVersion();
            CharArrayBuffer buffer = new CharArrayBuffer(40);
            buffer.append("Cookie: ");
            buffer.append("$Version=");
            buffer.append(Integer.toString(version2));
            buffer.append("; ");
            this.formatCookieAsVer(buffer, cookie, version2);
            headers2.add(new BufferedHeader(buffer));
        }
        return headers2;
    }

    protected void formatParamAsVer(CharArrayBuffer buffer, String name, String value2, int version2) {
        buffer.append(name);
        buffer.append("=");
        if (value2 != null) {
            if (version2 > 0) {
                buffer.append('\"');
                buffer.append(value2);
                buffer.append('\"');
            } else {
                buffer.append(value2);
            }
        }
    }

    protected void formatCookieAsVer(CharArrayBuffer buffer, Cookie cookie, int version2) {
        this.formatParamAsVer(buffer, cookie.getName(), cookie.getValue(), version2);
        if (cookie.getPath() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("path")) {
            buffer.append("; ");
            this.formatParamAsVer(buffer, "$Path", cookie.getPath(), version2);
        }
        if (cookie.getDomain() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("domain")) {
            buffer.append("; ");
            this.formatParamAsVer(buffer, "$Domain", cookie.getDomain(), version2);
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "rfc2109";
    }
}

