/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolException;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ProtocolExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpProcessor httpProcessor;

    public ProtocolExec(ClientExecChain requestExecutor, HttpProcessor httpProcessor) {
        Args.notNull(requestExecutor, "HTTP client request executor");
        Args.notNull(httpProcessor, "HTTP protocol processor");
        this.requestExecutor = requestExecutor;
        this.httpProcessor = httpProcessor;
    }

    void rewriteRequestURI(HttpRequestWrapper request2, HttpRoute route, boolean normalizeUri) throws ProtocolException {
        URI uri2 = request2.getURI();
        if (uri2 != null) {
            try {
                request2.setURI(URIUtils.rewriteURIForRoute(uri2, route, normalizeUri));
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("Invalid URI: " + uri2, ex);
            }
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request2, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        String userinfo;
        URI uri2;
        block18: {
            Args.notNull(route, "HTTP route");
            Args.notNull(request2, "HTTP request");
            Args.notNull(context, "HTTP context");
            HttpRequest original = request2.getOriginal();
            uri2 = null;
            if (original instanceof HttpUriRequest) {
                uri2 = ((HttpUriRequest)original).getURI();
            } else {
                String uriString = original.getRequestLine().getUri();
                try {
                    uri2 = URI.create(uriString);
                }
                catch (IllegalArgumentException ex) {
                    if (!this.log.isDebugEnabled()) break block18;
                    this.log.debug("Unable to parse '" + uriString + "' as a valid URI; " + "request URI and Host header may be inconsistent", ex);
                }
            }
        }
        request2.setURI(uri2);
        this.rewriteRequestURI(request2, route, context.getRequestConfig().isNormalizeUri());
        HttpParams params = request2.getParams();
        HttpHost virtualHost = (HttpHost)params.getParameter("http.virtual-host");
        if (virtualHost != null && virtualHost.getPort() == -1) {
            int port2 = route.getTargetHost().getPort();
            if (port2 != -1) {
                virtualHost = new HttpHost(virtualHost.getHostName(), port2, virtualHost.getSchemeName());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using virtual host" + virtualHost);
            }
        }
        HttpHost target = null;
        if (virtualHost != null) {
            target = virtualHost;
        } else if (uri2 != null && uri2.isAbsolute() && uri2.getHost() != null) {
            target = new HttpHost(uri2.getHost(), uri2.getPort(), uri2.getScheme());
        }
        if (target == null) {
            target = request2.getTarget();
        }
        if (target == null) {
            target = route.getTargetHost();
        }
        if (uri2 != null && (userinfo = uri2.getUserInfo()) != null) {
            CredentialsProvider credsProvider = context.getCredentialsProvider();
            if (credsProvider == null) {
                credsProvider = new BasicCredentialsProvider();
                context.setCredentialsProvider(credsProvider);
            }
            credsProvider.setCredentials(new AuthScope(target), new UsernamePasswordCredentials(userinfo));
        }
        context.setAttribute("http.target_host", target);
        context.setAttribute("http.route", route);
        context.setAttribute("http.request", request2);
        this.httpProcessor.process(request2, (HttpContext)context);
        CloseableHttpResponse response2 = this.requestExecutor.execute(route, request2, context, execAware);
        try {
            context.setAttribute("http.response", response2);
            this.httpProcessor.process(response2, (HttpContext)context);
            return response2;
        }
        catch (RuntimeException ex) {
            response2.close();
            throw ex;
        }
        catch (IOException ex) {
            response2.close();
            throw ex;
        }
        catch (HttpException ex) {
            response2.close();
            throw ex;
        }
    }
}

