/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.impl.nio.DefaultNHttpClientConnectionFactory;
import org.apache.http.impl.nio.SSLNHttpClientConnectionFactory;
import org.apache.http.impl.nio.reactor.AbstractIODispatch;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpClientIODispatch<H extends NHttpClientEventHandler>
extends AbstractIODispatch<DefaultNHttpClientConnection> {
    private final H handler;
    private final NHttpConnectionFactory<? extends DefaultNHttpClientConnection> connectionFactory;

    public static <T extends NHttpClientEventHandler> DefaultHttpClientIODispatch<T> create(T handler2, SSLContext sslContext, ConnectionConfig config2) {
        return sslContext == null ? new DefaultHttpClientIODispatch<T>(handler2, config2) : new DefaultHttpClientIODispatch<T>(handler2, sslContext, config2);
    }

    public static <T extends NHttpClientEventHandler> DefaultHttpClientIODispatch<T> create(T handler2, SSLContext sslContext, SSLSetupHandler sslHandler, ConnectionConfig config2) {
        return sslContext == null ? new DefaultHttpClientIODispatch<T>(handler2, config2) : new DefaultHttpClientIODispatch<T>(handler2, sslContext, sslHandler, config2);
    }

    public DefaultHttpClientIODispatch(H handler2, NHttpConnectionFactory<? extends DefaultNHttpClientConnection> connFactory) {
        this.handler = (NHttpClientEventHandler)Args.notNull(handler2, "HTTP client handler");
        this.connectionFactory = Args.notNull(connFactory, "HTTP client connection factory");
    }

    @Deprecated
    public DefaultHttpClientIODispatch(H handler2, HttpParams params) {
        this(handler2, new DefaultNHttpClientConnectionFactory(params));
    }

    @Deprecated
    public DefaultHttpClientIODispatch(H handler2, SSLContext sslContext, SSLSetupHandler sslHandler, HttpParams params) {
        this(handler2, new SSLNHttpClientConnectionFactory(sslContext, sslHandler, params));
    }

    @Deprecated
    public DefaultHttpClientIODispatch(H handler2, SSLContext sslContext, HttpParams params) {
        this(handler2, sslContext, null, params);
    }

    public DefaultHttpClientIODispatch(H handler2, ConnectionConfig config2) {
        this(handler2, new DefaultNHttpClientConnectionFactory(config2));
    }

    public DefaultHttpClientIODispatch(H handler2, SSLContext sslContext, SSLSetupHandler sslHandler, ConnectionConfig config2) {
        this(handler2, new SSLNHttpClientConnectionFactory(sslContext, sslHandler, config2));
    }

    public DefaultHttpClientIODispatch(H handler2, SSLContext sslContext, ConnectionConfig config2) {
        this(handler2, new SSLNHttpClientConnectionFactory(sslContext, null, config2));
    }

    @Override
    protected DefaultNHttpClientConnection createConnection(IOSession session2) {
        return this.connectionFactory.createConnection(session2);
    }

    public NHttpConnectionFactory<? extends DefaultNHttpClientConnection> getConnectionFactory() {
        return this.connectionFactory;
    }

    public H getHandler() {
        return this.handler;
    }

    @Override
    protected void onConnected(DefaultNHttpClientConnection conn) {
        Object attachment = conn.getContext().getAttribute("http.session.attachment");
        try {
            this.handler.connected(conn, attachment);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpClientConnection conn) {
        this.handler.closed(conn);
    }

    @Override
    protected void onException(DefaultNHttpClientConnection conn, IOException ex) {
        this.handler.exception(conn, ex);
    }

    @Override
    protected void onInputReady(DefaultNHttpClientConnection conn) {
        conn.consumeInput((NHttpClientEventHandler)this.handler);
    }

    @Override
    protected void onOutputReady(DefaultNHttpClientConnection conn) {
        conn.produceOutput((NHttpClientEventHandler)this.handler);
    }

    @Override
    protected void onTimeout(DefaultNHttpClientConnection conn) {
        try {
            this.handler.timeout(conn);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }
}

