/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.conn;

import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;

class Wire {
    private final Log log;
    private final String id;

    public Wire(Log log2, String id) {
        this.log = log2;
        this.id = id;
    }

    private void wire(String header, byte[] b2, int pos, int off) {
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < off; ++i2) {
            byte ch = b2[pos + i2];
            if (ch == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch == 10) {
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header);
                this.log.debug(this.id + " " + buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            buffer.append('\"');
            buffer.insert(0, '\"');
            buffer.insert(0, header);
            this.log.debug(this.id + " " + buffer.toString());
        }
    }

    public boolean isEnabled() {
        return this.log.isDebugEnabled();
    }

    public void output(byte[] b2, int pos, int off) {
        this.wire(">> ", b2, pos, off);
    }

    public void input(byte[] b2, int pos, int off) {
        this.wire("<< ", b2, pos, off);
    }

    public void output(byte[] b2) {
        this.output(b2, 0, b2.length);
    }

    public void input(byte[] b2) {
        this.input(b2, 0, b2.length);
    }

    public void output(int b2) {
        this.output(new byte[]{(byte)b2});
    }

    public void input(int b2) {
        this.input(new byte[]{(byte)b2});
    }

    public void output(ByteBuffer b2) {
        if (b2.hasArray()) {
            this.output(b2.array(), b2.arrayOffset() + b2.position(), b2.remaining());
        } else {
            byte[] tmp = new byte[b2.remaining()];
            b2.get(tmp);
            this.output(tmp);
        }
    }

    public void input(ByteBuffer b2) {
        if (b2.hasArray()) {
            this.input(b2.array(), b2.arrayOffset() + b2.position(), b2.remaining());
        } else {
            byte[] tmp = new byte[b2.remaining()];
            b2.get(tmp);
            this.input(tmp);
        }
    }
}

