/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.impl.nio.reactor.IOSessionImpl;
import org.apache.http.impl.nio.reactor.InterestOpEntry;
import org.apache.http.impl.nio.reactor.InterestOpsCallback;
import org.apache.http.impl.nio.reactor.SessionClosedCallback;
import org.apache.http.impl.nio.reactor.SessionRequestImpl;
import org.apache.http.nio.reactor.IOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

public abstract class AbstractIOReactor
implements IOReactor {
    private volatile IOReactorStatus status;
    private final Object statusMutex;
    private final long selectTimeout;
    private final boolean interestOpsQueueing;
    private final Selector selector;
    private final Set<IOSession> sessions;
    private final Queue<InterestOpEntry> interestOpsQueue;
    private final Queue<IOSession> closedSessions;
    private final Queue<ChannelEntry> newChannels;

    public AbstractIOReactor(long selectTimeout) throws IOReactorException {
        this(selectTimeout, false);
    }

    public AbstractIOReactor(long selectTimeout, boolean interestOpsQueueing) throws IOReactorException {
        Args.positive(selectTimeout, "Select timeout");
        this.selectTimeout = selectTimeout;
        this.interestOpsQueueing = interestOpsQueueing;
        this.sessions = Collections.synchronizedSet(new HashSet());
        this.interestOpsQueue = new ConcurrentLinkedQueue<InterestOpEntry>();
        this.closedSessions = new ConcurrentLinkedQueue<IOSession>();
        this.newChannels = new ConcurrentLinkedQueue<ChannelEntry>();
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure opening selector", ex);
        }
        this.statusMutex = new Object();
        this.status = IOReactorStatus.INACTIVE;
    }

    protected abstract void acceptable(SelectionKey var1);

    protected abstract void connectable(SelectionKey var1);

    protected abstract void readable(SelectionKey var1);

    protected abstract void writable(SelectionKey var1);

    protected abstract void validate(Set<SelectionKey> var1);

    protected void sessionCreated(SelectionKey key2, IOSession session2) {
    }

    protected void sessionClosed(IOSession session2) {
    }

    protected void sessionTimedOut(IOSession session2) {
    }

    protected IOSession getSession(SelectionKey key2) {
        return (IOSession)key2.attachment();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.status;
    }

    public boolean getInterestOpsQueueing() {
        return this.interestOpsQueueing;
    }

    public void addChannel(ChannelEntry channelEntry) {
        Args.notNull(channelEntry, "Channel entry");
        this.newChannels.add(channelEntry);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws InterruptedIOException, IOReactorException {
        this.status = IOReactorStatus.ACTIVE;
        try {
            while (true) {
                int readyCount;
                try {
                    readyCount = this.selector.select(this.selectTimeout);
                }
                catch (InterruptedIOException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw new IOReactorException("Unexpected selector failure", ex);
                }
                if (this.status == IOReactorStatus.SHUT_DOWN) {
                    break;
                }
                if (this.status == IOReactorStatus.SHUTTING_DOWN) {
                    this.closeSessions();
                    this.closeNewChannels();
                }
                if (readyCount > 0) {
                    this.processEvents(this.selector.selectedKeys());
                }
                this.validate(this.selector.keys());
                this.processClosedSessions();
                if (this.status == IOReactorStatus.ACTIVE) {
                    this.processNewChannels();
                }
                if (this.status.compareTo(IOReactorStatus.ACTIVE) > 0 && this.sessions.isEmpty()) {
                    break;
                }
                if (!this.interestOpsQueueing) continue;
                this.processPendingInterestOps();
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            this.hardShutdown();
            Object object = this.statusMutex;
            synchronized (object) {
                this.statusMutex.notifyAll();
            }
        }
        finally {
            this.hardShutdown();
            Object readyCount = this.statusMutex;
            synchronized (readyCount) {
                this.statusMutex.notifyAll();
            }
        }
    }

    private void processEvents(Set<SelectionKey> selectedKeys) {
        for (SelectionKey key2 : selectedKeys) {
            this.processEvent(key2);
        }
        selectedKeys.clear();
    }

    protected void processEvent(SelectionKey key2) {
        IOSessionImpl session2 = (IOSessionImpl)key2.attachment();
        try {
            if (key2.isAcceptable()) {
                this.acceptable(key2);
            }
            if (key2.isConnectable()) {
                this.connectable(key2);
            }
            if (key2.isReadable()) {
                session2.resetLastRead();
                this.readable(key2);
            }
            if (key2.isWritable()) {
                session2.resetLastWrite();
                this.writable(key2);
            }
        }
        catch (CancelledKeyException ex) {
            this.queueClosedSession(session2);
            key2.attach(null);
        }
    }

    protected void queueClosedSession(IOSession session2) {
        if (session2 != null) {
            this.closedSessions.add(session2);
        }
    }

    private void processNewChannels() throws IOReactorException {
        ChannelEntry entry;
        while ((entry = this.newChannels.poll()) != null) {
            IOSessionImpl session2;
            SelectionKey key2;
            SocketChannel channel2;
            try {
                channel2 = entry.getChannel();
                channel2.configureBlocking(false);
                key2 = channel2.register(this.selector, 1);
            }
            catch (ClosedChannelException ex) {
                SessionRequestImpl sessionRequest = entry.getSessionRequest();
                if (sessionRequest != null) {
                    sessionRequest.failed(ex);
                }
                return;
            }
            catch (IOException ex) {
                throw new IOReactorException("Failure registering channel with the selector", ex);
            }
            SessionClosedCallback sessionClosedCallback = new SessionClosedCallback(){

                @Override
                public void sessionClosed(IOSession session2) {
                    AbstractIOReactor.this.queueClosedSession(session2);
                }
            };
            InterestOpsCallback interestOpsCallback = null;
            if (this.interestOpsQueueing) {
                interestOpsCallback = new InterestOpsCallback(){

                    @Override
                    public void addInterestOps(InterestOpEntry entry) {
                        AbstractIOReactor.this.queueInterestOps(entry);
                    }
                };
            }
            try {
                session2 = new IOSessionImpl(key2, interestOpsCallback, sessionClosedCallback);
                int timeout2 = 0;
                try {
                    timeout2 = channel2.socket().getSoTimeout();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                session2.setAttribute("http.session.attachment", entry.getAttachment());
                session2.setSocketTimeout(timeout2);
            }
            catch (CancelledKeyException ex) {
                continue;
            }
            try {
                this.sessions.add(session2);
                key2.attach(session2);
                SessionRequestImpl sessionRequest = entry.getSessionRequest();
                if (sessionRequest != null) {
                    if (!sessionRequest.isTerminated()) {
                        sessionRequest.completed(session2);
                    }
                    if (!sessionRequest.isTerminated() && !session2.isClosed()) {
                        this.sessionCreated(key2, session2);
                    }
                    if (!sessionRequest.isTerminated()) continue;
                    throw new CancelledKeyException();
                }
                this.sessionCreated(key2, session2);
            }
            catch (CancelledKeyException ex) {
                session2.close();
                key2.attach(null);
            }
        }
    }

    private void processClosedSessions() {
        IOSession session2;
        while ((session2 = this.closedSessions.poll()) != null) {
            if (!this.sessions.remove(session2)) continue;
            try {
                this.sessionClosed(session2);
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    private void processPendingInterestOps() {
        InterestOpEntry entry;
        if (!this.interestOpsQueueing) {
            return;
        }
        while ((entry = this.interestOpsQueue.poll()) != null) {
            SelectionKey key2 = entry.getSelectionKey();
            int eventMask = entry.getEventMask();
            if (!key2.isValid()) continue;
            try {
                key2.interestOps(eventMask);
            }
            catch (CancelledKeyException ex) {}
        }
    }

    private boolean queueInterestOps(InterestOpEntry entry) {
        Asserts.check(this.interestOpsQueueing, "Interest ops queueing not enabled");
        if (entry == null) {
            return false;
        }
        this.interestOpsQueue.add(entry);
        return true;
    }

    protected void timeoutCheck(SelectionKey key2, long now) {
        int timeout2;
        IOSessionImpl session2 = (IOSessionImpl)key2.attachment();
        if (session2 != null && (timeout2 = session2.getSocketTimeout()) > 0 && session2.getLastAccessTime() + (long)timeout2 < now) {
            try {
                this.sessionTimedOut(session2);
            }
            catch (CancelledKeyException ex) {
                session2.close();
                key2.attach(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSessions() {
        Set<IOSession> set2 = this.sessions;
        synchronized (set2) {
            for (IOSession session2 : this.sessions) {
                session2.close();
            }
        }
    }

    protected void closeNewChannels() throws IOReactorException {
        ChannelEntry entry;
        while ((entry = this.newChannels.poll()) != null) {
            SessionRequestImpl sessionRequest = entry.getSessionRequest();
            if (sessionRequest != null) {
                sessionRequest.cancel();
            }
            SocketChannel channel2 = entry.getChannel();
            try {
                channel2.close();
            }
            catch (IOException ignore) {}
        }
    }

    protected void closeActiveChannels() throws IOReactorException {
        try {
            Set<SelectionKey> keys2 = this.selector.keys();
            for (SelectionKey key2 : keys2) {
                IOSession session2 = this.getSession(key2);
                if (session2 == null) continue;
                session2.close();
            }
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulShutdown() {
        Object object = this.statusMutex;
        synchronized (object) {
            if (this.status != IOReactorStatus.ACTIVE) {
                return;
            }
            this.status = IOReactorStatus.SHUTTING_DOWN;
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hardShutdown() throws IOReactorException {
        Object object = this.statusMutex;
        synchronized (object) {
            if (this.status == IOReactorStatus.SHUT_DOWN) {
                return;
            }
            this.status = IOReactorStatus.SHUT_DOWN;
        }
        this.closeNewChannels();
        this.closeActiveChannels();
        this.processClosedSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown(long timeout2) throws InterruptedException {
        Object object = this.statusMutex;
        synchronized (object) {
            long deadline = System.currentTimeMillis() + timeout2;
            long remaining = timeout2;
            while (this.status != IOReactorStatus.SHUT_DOWN) {
                this.statusMutex.wait(remaining);
                if (timeout2 <= 0L || (remaining = deadline - System.currentTimeMillis()) > 0L) continue;
            }
        }
    }

    @Override
    public void shutdown(long gracePeriod) throws IOReactorException {
        if (this.status != IOReactorStatus.INACTIVE) {
            this.gracefulShutdown();
            try {
                this.awaitShutdown(gracePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.status != IOReactorStatus.SHUT_DOWN) {
            this.hardShutdown();
        }
    }

    @Override
    public void shutdown() throws IOReactorException {
        this.shutdown(1000L);
    }
}

