/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.AbstractIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.util.Args;

public class BaseIOReactor
extends AbstractIOReactor {
    private final long timeoutCheckInterval;
    private final Set<IOSession> bufferingSessions = new HashSet<IOSession>();
    private long lastTimeoutCheck;
    private IOReactorExceptionHandler exceptionHandler = null;
    private IOEventDispatch eventDispatch = null;

    public BaseIOReactor(long selectTimeout) throws IOReactorException {
        this(selectTimeout, false);
    }

    public BaseIOReactor(long selectTimeout, boolean interestOpsQueueing) throws IOReactorException {
        super(selectTimeout, interestOpsQueueing);
        this.timeoutCheckInterval = selectTimeout;
        this.lastTimeoutCheck = System.currentTimeMillis();
    }

    @Override
    public void execute(IOEventDispatch eventDispatch) throws InterruptedIOException, IOReactorException {
        Args.notNull(eventDispatch, "Event dispatcher");
        this.eventDispatch = eventDispatch;
        this.execute();
    }

    public void setExceptionHandler(IOReactorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected void handleRuntimeException(RuntimeException ex) {
        if (this.exceptionHandler == null || !this.exceptionHandler.handle(ex)) {
            throw ex;
        }
    }

    @Override
    protected void acceptable(SelectionKey key2) {
    }

    @Override
    protected void connectable(SelectionKey key2) {
    }

    @Override
    protected void readable(SelectionKey key2) {
        IOSession session2 = this.getSession(key2);
        try {
            for (int i2 = 0; i2 < 5; ++i2) {
                this.eventDispatch.inputReady(session2);
                if (!session2.hasBufferedInput() || (session2.getEventMask() & 1) == 0) break;
            }
            if (session2.hasBufferedInput()) {
                this.bufferingSessions.add(session2);
            }
        }
        catch (CancelledKeyException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }

    @Override
    protected void writable(SelectionKey key2) {
        IOSession session2 = this.getSession(key2);
        try {
            this.eventDispatch.outputReady(session2);
        }
        catch (CancelledKeyException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }

    @Override
    protected void validate(Set<SelectionKey> keys2) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck >= this.timeoutCheckInterval) {
            this.lastTimeoutCheck = currentTime;
            if (keys2 != null) {
                for (SelectionKey key2 : keys2) {
                    this.timeoutCheck(key2, currentTime);
                }
            }
        }
        if (!this.bufferingSessions.isEmpty()) {
            Iterator<IOSession> it = this.bufferingSessions.iterator();
            while (it.hasNext()) {
                IOSession session2 = it.next();
                if (!session2.hasBufferedInput()) {
                    it.remove();
                    continue;
                }
                try {
                    if ((session2.getEventMask() & 1) <= 0) continue;
                    this.eventDispatch.inputReady(session2);
                    if (session2.hasBufferedInput()) continue;
                    it.remove();
                }
                catch (CancelledKeyException ex) {
                    it.remove();
                    session2.close();
                }
                catch (RuntimeException ex) {
                    this.handleRuntimeException(ex);
                }
            }
        }
    }

    @Override
    protected void sessionCreated(SelectionKey key2, IOSession session2) {
        try {
            this.eventDispatch.connected(session2);
        }
        catch (CancelledKeyException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }

    @Override
    protected void sessionTimedOut(IOSession session2) {
        try {
            this.eventDispatch.timeout(session2);
        }
        catch (CancelledKeyException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }

    @Override
    protected void sessionClosed(IOSession session2) {
        try {
            this.eventDispatch.disconnected(session2);
        }
        catch (CancelledKeyException ex) {
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }
}

