/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.http.impl.nio.reactor.AbstractMultiworkerIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.impl.nio.reactor.SessionRequestHandle;
import org.apache.http.impl.nio.reactor.SessionRequestImpl;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Asserts;

public class DefaultConnectingIOReactor
extends AbstractMultiworkerIOReactor
implements ConnectingIOReactor {
    private final Queue<SessionRequestImpl> requestQueue = new ConcurrentLinkedQueue<SessionRequestImpl>();
    private long lastTimeoutCheck = System.currentTimeMillis();

    public DefaultConnectingIOReactor(IOReactorConfig config2, ThreadFactory threadFactory) throws IOReactorException {
        super(config2, threadFactory);
    }

    public DefaultConnectingIOReactor(IOReactorConfig config2) throws IOReactorException {
        this(config2, null);
    }

    public DefaultConnectingIOReactor() throws IOReactorException {
        this(null, null);
    }

    @Deprecated
    public DefaultConnectingIOReactor(int workerCount, ThreadFactory threadFactory, HttpParams params) throws IOReactorException {
        this(DefaultConnectingIOReactor.convert(workerCount, params), threadFactory);
    }

    @Deprecated
    public DefaultConnectingIOReactor(int workerCount, HttpParams params) throws IOReactorException {
        this(DefaultConnectingIOReactor.convert(workerCount, params), null);
    }

    @Override
    protected void cancelRequests() throws IOReactorException {
        SessionRequestImpl request2;
        while ((request2 = this.requestQueue.poll()) != null) {
            request2.cancel();
        }
    }

    @Override
    protected void processEvents(int readyCount) throws IOReactorException {
        long currentTime;
        this.processSessionRequests();
        if (readyCount > 0) {
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            for (SelectionKey key2 : selectedKeys) {
                this.processEvent(key2);
            }
            selectedKeys.clear();
        }
        if ((currentTime = System.currentTimeMillis()) - this.lastTimeoutCheck >= this.selectTimeout) {
            this.lastTimeoutCheck = currentTime;
            Set<SelectionKey> keys2 = this.selector.keys();
            this.processTimeouts(keys2);
        }
    }

    private void processEvent(SelectionKey key2) {
        block8: {
            try {
                if (!key2.isConnectable()) break block8;
                SocketChannel channel2 = (SocketChannel)key2.channel();
                SessionRequestHandle requestHandle = (SessionRequestHandle)key2.attachment();
                SessionRequestImpl sessionRequest = requestHandle.getSessionRequest();
                try {
                    channel2.finishConnect();
                }
                catch (IOException ex) {
                    sessionRequest.failed(ex);
                }
                key2.cancel();
                key2.attach(null);
                if (!sessionRequest.isCompleted()) {
                    this.addChannel(new ChannelEntry(channel2, sessionRequest));
                } else {
                    try {
                        channel2.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (CancelledKeyException ex) {
                SessionRequestImpl sessionRequest;
                SessionRequestHandle requestHandle = (SessionRequestHandle)key2.attachment();
                key2.attach(null);
                if (requestHandle == null || (sessionRequest = requestHandle.getSessionRequest()) == null) break block8;
                sessionRequest.cancel();
            }
        }
    }

    private void processTimeouts(Set<SelectionKey> keys2) {
        long now = System.currentTimeMillis();
        for (SelectionKey key2 : keys2) {
            SessionRequestHandle handle2;
            SessionRequestImpl sessionRequest;
            int timeout2;
            Object attachment = key2.attachment();
            if (!(attachment instanceof SessionRequestHandle) || (timeout2 = (sessionRequest = (handle2 = (SessionRequestHandle)key2.attachment()).getSessionRequest()).getConnectTimeout()) <= 0 || handle2.getRequestTime() + (long)timeout2 >= now) continue;
            sessionRequest.timeout();
        }
    }

    @Override
    public SessionRequest connect(SocketAddress remoteAddress2, SocketAddress localAddress2, Object attachment, SessionRequestCallback callback2) {
        Asserts.check(this.status.compareTo(IOReactorStatus.ACTIVE) <= 0, "I/O reactor has been shut down");
        SessionRequestImpl sessionRequest = new SessionRequestImpl(remoteAddress2, localAddress2, attachment, callback2);
        sessionRequest.setConnectTimeout(this.config.getConnectTimeout());
        this.requestQueue.add(sessionRequest);
        this.selector.wakeup();
        return sessionRequest;
    }

    private void validateAddress(SocketAddress address) throws UnknownHostException {
        InetSocketAddress endpoint;
        if (address == null) {
            return;
        }
        if (address instanceof InetSocketAddress && (endpoint = (InetSocketAddress)address).isUnresolved()) {
            throw new UnknownHostException(endpoint.getHostName());
        }
    }

    private void processSessionRequests() throws IOReactorException {
        SessionRequestImpl request2;
        while ((request2 = this.requestQueue.poll()) != null) {
            SocketChannel socketChannel;
            if (request2.isCompleted()) continue;
            try {
                socketChannel = SocketChannel.open();
            }
            catch (IOException ex) {
                request2.failed(ex);
                return;
            }
            try {
                boolean connected;
                this.validateAddress(request2.getLocalAddress());
                this.validateAddress(request2.getRemoteAddress());
                socketChannel.configureBlocking(false);
                this.prepareSocket(socketChannel.socket());
                if (request2.getLocalAddress() != null) {
                    Socket sock = socketChannel.socket();
                    sock.setReuseAddress(this.config.isSoReuseAddress());
                    sock.bind(request2.getLocalAddress());
                }
                final SocketAddress targetAddress = request2.getRemoteAddress();
                try {
                    connected = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws IOException {
                            return socketChannel.connect(targetAddress);
                        }
                    });
                }
                catch (PrivilegedActionException e2) {
                    Asserts.check(e2.getCause() instanceof IOException, "method contract violation only checked exceptions are wrapped: " + e2.getCause());
                    throw (IOException)e2.getCause();
                }
                if (connected) {
                    ChannelEntry entry = new ChannelEntry(socketChannel, request2);
                    this.addChannel(entry);
                    continue;
                }
            }
            catch (IOException ex) {
                DefaultConnectingIOReactor.closeChannel(socketChannel);
                request2.failed(ex);
                return;
            }
            catch (SecurityException ex) {
                DefaultConnectingIOReactor.closeChannel(socketChannel);
                request2.failed(new IOException(ex));
                return;
            }
            SessionRequestHandle requestHandle = new SessionRequestHandle(request2);
            try {
                SelectionKey key2 = socketChannel.register(this.selector, 8, requestHandle);
                request2.setKey(key2);
            }
            catch (IOException ex) {
                DefaultConnectingIOReactor.closeChannel(socketChannel);
                throw new IOReactorException("Failure registering channel with the selector", ex);
            }
        }
    }
}

