/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ExpandableBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.CharsetUtils;

public class SessionOutputBufferImpl
extends ExpandableBuffer
implements SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final CharsetEncoder charEncoder;
    private final int lineBufferSize;
    private CharBuffer charBuffer;

    public SessionOutputBufferImpl(int bufferSize, int lineBufferSize, CharsetEncoder charEncoder, ByteBufferAllocator allocator) {
        super(bufferSize, allocator != null ? allocator : HeapByteBufferAllocator.INSTANCE);
        this.lineBufferSize = Args.positive(lineBufferSize, "Line buffer size");
        this.charEncoder = charEncoder;
    }

    @Deprecated
    public SessionOutputBufferImpl(int bufferSize, int lineBufferSize, ByteBufferAllocator allocator, HttpParams params) {
        super(bufferSize, allocator);
        this.lineBufferSize = Args.positive(lineBufferSize, "Line buffer size");
        String charsetName = (String)params.getParameter("http.protocol.element-charset");
        Charset charset = CharsetUtils.lookup(charsetName);
        if (charset != null) {
            this.charEncoder = charset.newEncoder();
            CodingErrorAction a1 = (CodingErrorAction)params.getParameter("http.malformed.input.action");
            this.charEncoder.onMalformedInput(a1 != null ? a1 : CodingErrorAction.REPORT);
            CodingErrorAction a2 = (CodingErrorAction)params.getParameter("http.unmappable.input.action");
            this.charEncoder.onUnmappableCharacter(a2 != null ? a2 : CodingErrorAction.REPORT);
        } else {
            this.charEncoder = null;
        }
    }

    @Deprecated
    public SessionOutputBufferImpl(int bufferSize, int lineBufferSize, HttpParams params) {
        this(bufferSize, lineBufferSize, HeapByteBufferAllocator.INSTANCE, params);
    }

    public SessionOutputBufferImpl(int bufferSize) {
        this(bufferSize, 256, null, HeapByteBufferAllocator.INSTANCE);
    }

    public SessionOutputBufferImpl(int bufferSize, int lineBufferSize, Charset charset) {
        this(bufferSize, lineBufferSize, charset != null ? charset.newEncoder() : null, HeapByteBufferAllocator.INSTANCE);
    }

    public SessionOutputBufferImpl(int bufferSize, int lineBufferSize) {
        this(bufferSize, lineBufferSize, null, HeapByteBufferAllocator.INSTANCE);
    }

    public void reset(HttpParams params) {
        this.clear();
    }

    @Override
    public int flush(WritableByteChannel channel2) throws IOException {
        Args.notNull(channel2, "Channel");
        this.setOutputMode();
        return channel2.write(this.buffer);
    }

    @Override
    public void write(ByteBuffer src) {
        if (src == null) {
            return;
        }
        this.setInputMode();
        int requiredCapacity = this.buffer.position() + src.remaining();
        this.ensureCapacity(requiredCapacity);
        this.buffer.put(src);
    }

    @Override
    public void write(ReadableByteChannel src) throws IOException {
        if (src == null) {
            return;
        }
        this.setInputMode();
        src.read(this.buffer);
    }

    private void write(byte[] b2) {
        if (b2 == null) {
            return;
        }
        this.setInputMode();
        boolean off = false;
        int len2 = b2.length;
        int requiredCapacity = this.buffer.position() + len2;
        this.ensureCapacity(requiredCapacity);
        this.buffer.put(b2, 0, len2);
    }

    private void writeCRLF() {
        this.write(CRLF);
    }

    @Override
    public void writeLine(CharArrayBuffer lineBuffer) throws CharacterCodingException {
        if (lineBuffer == null) {
            return;
        }
        this.setInputMode();
        if (lineBuffer.length() > 0) {
            if (this.charEncoder == null) {
                int requiredCapacity = this.buffer.position() + lineBuffer.length();
                this.ensureCapacity(requiredCapacity);
                if (this.buffer.hasArray()) {
                    byte[] b2 = this.buffer.array();
                    int len2 = lineBuffer.length();
                    int off = this.buffer.position();
                    for (int i2 = 0; i2 < len2; ++i2) {
                        b2[off + i2] = (byte)lineBuffer.charAt(i2);
                    }
                    this.buffer.position(off + len2);
                } else {
                    for (int i3 = 0; i3 < lineBuffer.length(); ++i3) {
                        this.buffer.put((byte)lineBuffer.charAt(i3));
                    }
                }
            } else {
                int l;
                if (this.charBuffer == null) {
                    this.charBuffer = CharBuffer.allocate(this.lineBufferSize);
                }
                this.charEncoder.reset();
                int offset = 0;
                for (int remaining = lineBuffer.length(); remaining > 0; remaining -= l) {
                    l = this.charBuffer.remaining();
                    boolean eol = false;
                    if (remaining <= l) {
                        l = remaining;
                        eol = true;
                    }
                    this.charBuffer.put(lineBuffer.buffer(), offset, l);
                    this.charBuffer.flip();
                    boolean retry2 = true;
                    while (retry2) {
                        CoderResult result2 = this.charEncoder.encode(this.charBuffer, this.buffer, eol);
                        if (result2.isError()) {
                            result2.throwException();
                        }
                        if (result2.isOverflow()) {
                            this.expand();
                        }
                        retry2 = !result2.isUnderflow();
                    }
                    this.charBuffer.compact();
                    offset += l;
                }
                boolean retry3 = true;
                while (retry3) {
                    CoderResult result3 = this.charEncoder.flush(this.buffer);
                    if (result3.isError()) {
                        result3.throwException();
                    }
                    if (result3.isOverflow()) {
                        this.expand();
                    }
                    retry3 = !result3.isUnderflow();
                }
            }
        }
        this.writeCRLF();
    }

    @Override
    public void writeLine(String s2) throws IOException {
        if (s2 == null) {
            return;
        }
        if (s2.length() > 0) {
            CharArrayBuffer tmp = new CharArrayBuffer(s2.length());
            tmp.append(s2);
            this.writeLine(tmp);
        } else {
            this.write(CRLF);
        }
    }

    @Override
    public void clear() {
        super.clear();
    }
}

