/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.client.methods.ZeroCopyConsumer;
import org.apache.http.nio.client.methods.ZeroCopyPost;
import org.apache.http.nio.client.methods.ZeroCopyPut;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.util.Args;

public final class HttpAsyncMethods {
    public static HttpAsyncRequestProducer create(HttpHost target, HttpRequest request2) {
        Args.notNull(target, "HTTP host");
        Args.notNull(request2, "HTTP request");
        return new RequestProducerImpl(target, request2);
    }

    public static HttpAsyncRequestProducer create(HttpUriRequest request2) {
        Args.notNull(request2, "HTTP request");
        HttpHost target = URIUtils.extractHost(request2.getURI());
        return new RequestProducerImpl(target, request2);
    }

    public static HttpAsyncRequestProducer createGet(URI requestURI) {
        return HttpAsyncMethods.create(new HttpGet(requestURI));
    }

    public static HttpAsyncRequestProducer createGet(String requestURI) {
        return HttpAsyncMethods.create(new HttpGet(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createHead(URI requestURI) {
        return HttpAsyncMethods.create(new HttpHead(requestURI));
    }

    public static HttpAsyncRequestProducer createHead(String requestURI) {
        return HttpAsyncMethods.create(new HttpHead(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createDelete(URI requestURI) {
        return HttpAsyncMethods.create(new HttpDelete(requestURI));
    }

    public static HttpAsyncRequestProducer createDelete(String requestURI) {
        return HttpAsyncMethods.create(new HttpDelete(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createOptions(URI requestURI) {
        return HttpAsyncMethods.create(new HttpOptions(requestURI));
    }

    public static HttpAsyncRequestProducer createOptions(String requestURI) {
        return HttpAsyncMethods.create(new HttpOptions(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createTrace(URI requestURI) {
        return HttpAsyncMethods.create(new HttpTrace(requestURI));
    }

    public static HttpAsyncRequestProducer createTrace(String requestURI) {
        return HttpAsyncMethods.create(new HttpTrace(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createPost(URI requestURI, String content2, ContentType contentType2) throws UnsupportedEncodingException {
        HttpPost httppost = new HttpPost(requestURI);
        NStringEntity entity = new NStringEntity(content2, contentType2);
        httppost.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httppost, entity);
    }

    public static HttpAsyncRequestProducer createPost(String requestURI, String content2, ContentType contentType2) throws UnsupportedEncodingException {
        return HttpAsyncMethods.createPost(URI.create(requestURI), content2, contentType2);
    }

    public static HttpAsyncRequestProducer createPost(URI requestURI, byte[] content2, ContentType contentType2) {
        HttpPost httppost = new HttpPost(requestURI);
        NByteArrayEntity entity = new NByteArrayEntity(content2, contentType2);
        httppost.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httppost, entity);
    }

    public static HttpAsyncRequestProducer createPost(String requestURI, byte[] content2, ContentType contentType2) {
        return HttpAsyncMethods.createPost(URI.create(requestURI), content2, contentType2);
    }

    public static HttpAsyncRequestProducer createPut(URI requestURI, String content2, ContentType contentType2) throws UnsupportedEncodingException {
        HttpPut httpput = new HttpPut(requestURI);
        NStringEntity entity = new NStringEntity(content2, contentType2);
        httpput.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httpput, entity);
    }

    public static HttpAsyncRequestProducer createPut(String requestURI, String content2, ContentType contentType2) throws UnsupportedEncodingException {
        return HttpAsyncMethods.createPut(URI.create(requestURI), content2, contentType2);
    }

    public static HttpAsyncRequestProducer createPut(URI requestURI, byte[] content2, ContentType contentType2) {
        HttpPut httpput = new HttpPut(requestURI);
        NByteArrayEntity entity = new NByteArrayEntity(content2, contentType2);
        httpput.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httpput, entity);
    }

    public static HttpAsyncRequestProducer createPut(String requestURI, byte[] content2, ContentType contentType2) {
        return HttpAsyncMethods.createPut(URI.create(requestURI), content2, contentType2);
    }

    public static HttpAsyncRequestProducer createZeroCopyPost(URI requestURI, File content2, ContentType contentType2) throws FileNotFoundException {
        return new ZeroCopyPost(requestURI, content2, contentType2);
    }

    public static HttpAsyncRequestProducer createZeroCopyPost(String requestURI, File content2, ContentType contentType2) throws FileNotFoundException {
        return new ZeroCopyPost(URI.create(requestURI), content2, contentType2);
    }

    public static HttpAsyncRequestProducer createZeroCopyPut(URI requestURI, File content2, ContentType contentType2) throws FileNotFoundException {
        return new ZeroCopyPut(requestURI, content2, contentType2);
    }

    public static HttpAsyncRequestProducer createZeroCopyPut(String requestURI, File content2, ContentType contentType2) throws FileNotFoundException {
        return new ZeroCopyPut(URI.create(requestURI), content2, contentType2);
    }

    public static HttpAsyncResponseConsumer<HttpResponse> createConsumer() {
        return new BasicAsyncResponseConsumer();
    }

    public static HttpAsyncResponseConsumer<HttpResponse> createZeroCopyConsumer(File file2) throws FileNotFoundException {
        return new ZeroCopyConsumer<HttpResponse>(file2){

            @Override
            protected HttpResponse process(HttpResponse response2, File file2, ContentType contentType2) {
                return response2;
            }
        };
    }

    static class RequestProducerImpl
    extends BasicAsyncRequestProducer {
        protected RequestProducerImpl(HttpHost target, HttpEntityEnclosingRequest request2, HttpAsyncContentProducer producer) {
            super(target, request2, producer);
        }

        public RequestProducerImpl(HttpHost target, HttpRequest request2) {
            super(target, request2);
        }
    }
}

